<?php
session_start();
$conn = new mysqli("localhost","dropjwxg_ad_generator","ad_generator","dropjwxg_ad_generator");
header('Content-Type: application/json');

$userid = $_SESSION['user_id'] ?? 0;
if(!$userid) { echo json_encode(['status'=>'error','message'=>'Not logged in']); exit; }

$campid = $_POST['campid'] ?? 0;
$actionid = $_POST['actionid'] ?? 0;
$website = $_POST['website'] ?? '';
$product = $_POST['productname'] ?? '';
$language = $_POST['language'] ?? '';
$platform = $_POST['platform'] ?? '';
$platlinks = $_POST['platlinks'] ?? '';
$platlinksjson = '[]';
$uniqueVisitors = $_POST['uniqueVisitors'] ?? 0;
$bounceRate     = $_POST['bounceRate'] ?? 50;






// Convert lines to JSON array if needed
if (!empty($platlinks) && in_array($platform, ['Referral','Social','Organic'])) {
    $lines = array_filter(array_map('trim', preg_split("/\r\n|\n|\r/", $platlinks)));
    $platlinksjson = json_encode($lines, JSON_UNESCAPED_UNICODE);
}

// Step 1: Ensure campaign exists
$campaignName = $_POST['campaignName'] ?? 'Test Campaign';

// Step 1: Ensure campaign exists
if (empty($campid) || $campid == 0) {
    // Insert new campaign
    $stmt = $conn->prepare("INSERT INTO campaign (Name, userid, status) VALUES (?, ?, 1)");
    $stmt->bind_param("si",$campaignName,$userid);
    $stmt->execute();
    $campid = $stmt->insert_id;
    $stmt->close();
} else {
    // Update existing campaign
    $stmt = $conn->prepare("UPDATE campaign SET Name=? WHERE campid=? AND userid=?");
    $stmt->bind_param("sii",$campaignName,$campid,$userid);
    $stmt->execute();
    $stmt->close();
}



// Step 2: Ensure action exists
if(!$actionid){
    $stmt = $conn->prepare("SELECT id FROM actions WHERE userid=? AND campid=? LIMIT 1");
    $stmt->bind_param("ii",$userid,$campid);
    $stmt->execute();
    $stmt->bind_result($foundId);
    $stmt->fetch();
    $stmt->close();
    if($foundId) $actionid = $foundId;
    else {
        $stmt = $conn->prepare("INSERT INTO actions (userid,campid) VALUES (?,?)");
        $stmt->bind_param("ii",$userid,$campid);
        $stmt->execute();
        $actionid = $stmt->insert_id;
        $stmt->close();
    }
}

// Step 3: Update row
$stmt = $conn->prepare("UPDATE actions 
    SET website=?, Productname=?, language=?, Platform=?, 
        platlinks=?, platlinksjason=?, 
        UniqueVisitors=?, `Bounce Rate`=? 
    WHERE id=? AND userid=?");



$stmt->bind_param("ssssssiiii",
    $website,
    $product,
    $language,
    $platform,
    $platlinks,
    $platlinksjson,
    $uniqueVisitors,
    $bounceRate,
    $actionid,
    $userid
);
    
$stmt->execute();


echo json_encode(['status'=>'saved','campid'=>$campid,'actionid'=>$actionid,'affected'=>$stmt->affected_rows]);
$stmt->close();
$conn->close();
?>
