<?php
session_start();
$conn = new mysqli("localhost","dropjwxg_ad_generator","ad_generator","dropjwxg_ad_generator");
header('Content-Type: application/json');

$userid = $_SESSION['user_id'] ?? 0;
if(!$userid) { echo json_encode(['status'=>'error','message'=>'Not logged in']); exit; }

$campid = $_POST['campid'] ?? 0;
$actionid = $_POST['actionid'] ?? 0;
$uniqueVisitors = $_POST['unique_visitors'] ?? 0;
$bounceRate = $_POST['bounce_rate'] ?? 0;
$device = $_POST['device'] ?? '';
$devicesJson = $_POST['devicesjosn'] ?? '[]';
$geo = $_POST['geo'] ?? '';
$geoJson = $_POST['geojason'] ?? '[]';

if(!$campid || !$actionid){
    echo json_encode(['status'=>'error','message'=>'Missing campid or actionid']);
    exit;
}

// Only update existing action
$stmt = $conn->prepare("
    UPDATE actions SET 
        `UniqueVisitors` = ?, 
        `Bounce Rate` = ?, 
        `devices` = ?, 
        `devicesjosn` = ?, 
        `geo` = ?, 
        `geojason` = ? 
    WHERE id=? AND userid=?
");
$stmt->bind_param("iissssii", $uniqueVisitors, $bounceRate, $device, $devicesJson, $geo, $geoJson, $actionid, $userid);
if(!$stmt->execute()){
    echo json_encode(['status'=>'error','message'=>$stmt->error]);
    exit;
}

echo json_encode([
    'status'=>'saved',
    'campid'=>$campid,
    'actionid'=>$actionid,
    'affected'=>$stmt->affected_rows
]);

$stmt->close();
$conn->close();
?>
