<?php
session_start();

// DB connection
$conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");
if ($conn->connect_error) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

$userId = $_SESSION['user_id'] ?? 0;
if ($userId == 0) {
    echo json_encode(['status' => 'error', 'message' => 'Not logged in']);
    exit;
}

// Get user's package
$res = $conn->query("
    SELECT p.id AS packid, p.apicount 
    FROM Package p
    INNER JOIN users u ON u.packid = p.id
    WHERE p.userid = $userId AND p.status = 1
");

if (!$res || $res->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'No active package found. Please upgrade your package.']);
    exit;
}

$package = $res->fetch_assoc();
$remaining = (int)$package['apicount'];

if ($remaining <= 0) {
    echo json_encode(['status' => 'exceeded', 'message' => 'You have exceeded your package limit. Please upgrade your package.']);
    exit;
}

// Decrement apicount by 1
$newCount = $remaining - 1;
$update = $conn->query("UPDATE Package SET apicount = $newCount WHERE id = " . $package['packid']);
if (!$update) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update package count']);
    exit;
}

// Return success with remaining hits
echo json_encode(['status' => 'ok', 'remaining' => $newCount]);

$conn->close();
