<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'templates/header.php';

// Check if returning from step2
$isReturning = isset($_GET['return']) && $_GET['return'] == '1';

// Defaults
$campaignName = 'Company Name';
$website = '';
$product = '';
$selectedLanguage = 'English';
$selectedPlatform = 'Google Search';

if ($isReturning) {
    $conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");
    if (!$conn->connect_error) {
        $userid = $_SESSION['user_id'];
        $result = $conn->query("SELECT name AS campaign_name, website
                        FROM competitor 
                        WHERE userid = $userid 
                        ORDER BY id DESC LIMIT 1");

        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $campaignName = $row['campaign_name'];
            $website = $row['website'];
            $product = $row['Productname'];
            $selectedLanguage = $row['language'];
            $selectedPlatform = $row['platform'];
        }

        $conn->close();
    }
}
?>

<style>
    .main-wrapper {
        display: flex;
        min-height: 100vh;
    }

    .sidebar {
        width: 250px;
        background-color: #343a40;
        padding: 20px 0;
        color: #fff;
    }

    .sidebar a {
        display: block;
        padding: 12px 20px;
        color: #fff;
        text-decoration: none;
    }

    .sidebar a:hover,
    .sidebar a.active {
        background-color: #495057;
    }

    .main-content {
        flex-grow: 1;
        padding: 40px 30px;
        background-color: #e8f0fe; /* light pastel blue background */
    }

    h1 {
        font-weight: 700;
        color: #1a237e; /* dark navy blue */
        margin-bottom: 30px;
        font-size: 28px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* New form container styling */
    form {
        background-color: #ffffff;
        border-radius: 16px;
        padding: 40px 50px;
        box-shadow: 0 8px 30px rgba(26, 35, 126, 0.12);
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 28px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group label {
        font-weight: 600;
        margin-bottom: 8px;
        color: #3949ab; /* medium blue */
    }

    .form-group input,
    .form-group select {
        padding: 12px 15px;
        font-size: 16px;
        border: 1.8px solid #c5cae9; /* soft blue border */
        border-radius: 10px;
        background-color: #f5f7ff; /* very light blue */
        color: #1a237e;
        box-shadow: inset 0 2px 5px rgba(60, 66, 201, 0.05);
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }

    .form-group input:focus,
    .form-group select:focus {
        border-color: #3949ab; /* highlight on focus */
        box-shadow: 0 0 8px rgba(57, 73, 171, 0.4);
        outline: none;
        background-color: #e8ecff;
    }

    .form-group input.error {
        border-color: #e53935;
        background-color: #ffebee;
        box-shadow: 0 0 6px 2px rgba(229, 57, 53, 0.6);
        color: #b71c1c;
    }

    .error-msg {
        color: #e53935;
        font-size: 14px;
        margin-top: 5px;
        display: none;
        font-weight: 600;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .button-group {
        grid-column: 1 / -1;
        display: flex;
        justify-content: flex-end;
        gap: 14px;
        margin-top: 28px;
    }

    .btn-primary {
        background: linear-gradient(135deg, #3949ab, #1a237e);
        color: white;
        padding: 12px 28px;
        border: none;
        border-radius: 10px;
        font-weight: 700;
        font-size: 16px;
        cursor: pointer;
        box-shadow: 0 6px 20px rgba(26, 35, 126, 0.5);
        transition: background 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #1a237e, #121858);
        box-shadow: 0 8px 25px rgba(18, 24, 88, 0.7);
    }

    .btn-secondary {
        background-color: #c5cae9;
        color: #3949ab;
        padding: 12px 28px;
        border: none;
        border-radius: 10px;
        font-weight: 600;
        font-size: 16px;
        cursor: pointer;
        box-shadow: none;
        transition: background-color 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .btn-secondary:hover {
        background-color: #9fa8da;
        color: #1a237e;
    }

    .flag, .platform-icon {
        margin-right: 8px;
        width: 20px;
        height: 15px;
        vertical-align: middle;
    }

    @media screen and (max-width: 768px) {
        form {
            grid-template-columns: 1fr;
        }
    }

    /* Keep your popup styles exactly the same as before */

    #confirm-modal {
        display: none;
        position: fixed;
        top: 0; left: 0; right: 0; bottom: 0;
        background: rgba(62, 39, 35, 0.75);
        z-index: 1000;
        align-items: center;
        justify-content: center;
    }

    #confirm-modal.active {
        display: flex;
    }

    #confirm-modal .modal-content {
        background: #fff3e0;
        border-radius: 14px;
        padding: 40px 35px;
        max-width: 430px;
        width: 90%;
        box-shadow:
            0 6px 25px rgba(160, 82, 45, 0.4),
            0 0 18px 4px rgba(255, 152, 0, 0.7);
        text-align: center;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        border: 4px solid #fb8c00;
        color: #6d4c41;
        transition: transform 0.3s ease;
    }

    #confirm-modal.active .modal-content {
        transform: scale(1);
    }

    #confirm-modal .modal-content p {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 30px;
        line-height: 1.5;
        white-space: pre-line;
    }

    #confirm-modal .modal-buttons {
        display: flex;
        justify-content: center;
        gap: 22px;
    }

    #confirm-modal .modal-buttons button {
        padding: 14px 30px;
        border-radius: 10px;
        font-size: 17px;
        cursor: pointer;
        transition: all 0.35s ease;
        min-width: 120px;
        font-weight: 700;
        box-shadow: 0 5px 14px rgba(0, 0, 0, 0.1);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    #confirm-modal .btn-ok {
        background: linear-gradient(135deg, #fb8c00, #ef6c00);
        border: none;
        color: #fff;
        box-shadow:
            0 5px 20px rgba(251, 140, 0, 0.75);
    }
    #confirm-modal .btn-ok:hover {
        background: linear-gradient(135deg, #ef6c00, #e65100);
        box-shadow:
            0 7px 24px rgba(230, 81, 0, 0.85);
        transform: translateY(-3px);
    }

    #confirm-modal .btn-cancel {
        background: #fff8e1;
        border: 3px solid #a1887f;
        color: #6d4c41;
        box-shadow: none;
    }
    #confirm-modal .btn-cancel:hover {
        background: #ffe0b2;
        border-color: #8d6e63;
        color: #4e342e;
        transform: translateY(-3px);
    }

    /* Loader overlay - Added only */
    #loading-overlay {
        display: none;
        position: fixed;
        top: 0; left: 0; right: 0; bottom: 0;
        background: rgba(26, 35, 126, 0.6);
        z-index: 2000;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        color: white;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        font-size: 22px;
        font-weight: 700;
    }

    .loader {
        border: 8px solid #f3f3f3;
        border-top: 8px solid #3949ab;
        border-radius: 50%;
        width: 70px;
        height: 70px;
        animation: spin 1.3s linear infinite;
        margin-bottom: 15px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

</style>

<div class="main-wrapper">
  <!-- Sidebar -->
<div class="sidebar">
  <nav>
    <ul class="sidebar-menu">
      <li><a href="dashboard.php" class="sidebar-link"><span class="icon">🏠</span> Dashboard</a></li>
      <li><a href="create_campaign.php" class="sidebar-link active"><span class="icon">📈</span> Create Campaign</a></li>
      <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
      <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
    </ul>
  </nav>
</div>

<style>
.sidebar {
    width: 260px;
    background-color: #1e1e2f;
    padding-top: 40px;
    padding-bottom: 40px;
    color: #ddd;
    box-shadow: 2px 0 12px rgba(0,0,0,0.2);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    user-select: none;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.sidebar-menu {
    list-style: none;
    padding: 0;
    margin: 0;
    width: 100%;
}

.sidebar-menu li {
    margin: 12px 0;
}

.sidebar-link {
    display: flex;
    align-items: center;
    text-decoration: none;
    color: #bbb;
    font-size: 18px;
    padding: 12px 24px;
    border-radius: 8px;
    transition: background-color 0.3s ease, color 0.3s ease;
}

.sidebar-link .icon {
    margin-right: 14px;
    font-size: 22px;
    line-height: 1;
}

.sidebar-link:hover {
    background: #3a3f55;
    color: #fff;
    box-shadow: 0 4px 12px rgba(58, 63, 85, 0.6);
}

.sidebar-link.active {
    background: #4f63d3;
    color: #fff;
    box-shadow: 0 4px 20px rgba(79, 99, 211, 0.7);
    font-weight: 600;
}

.sidebar-link .icon {
    margin-right: 14px;
    font-size: 20px;
    width: 32px;
    height: 32px;
    background: #fff;
    color: #4f63d3;
    border-radius: 50%;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
}

</style>


    <div class="main-content">
        <h1>Step 1: Submit Your Competitor Website URL(Domain)</h1>

        <form id="campaign-form" method="POST" action="save_competitoranalysis.php" onsubmit="return onFormSubmit(event)">
            <div class="form-group">
                <label for="campaign_name">Company Name:</label>
                <input type="text" id="campaign_name" name="campaign_name"
                    value="<?= htmlspecialchars($campaignName) ?>"
                    <?= $isReturning ? 'readonly' : '' ?>>
                <div id="campaign_name-error" class="error-msg">Company name is required.</div>
            </div>

            <div class="form-group">
                <label for="website">Website URL:</label>
                <input type="text" id="website" name="website"
                    value="<?= htmlspecialchars($website) ?>"
                    <?= $isReturning ? 'readonly' : '' ?>>
                <div id="website-error" class="error-msg">Please enter a valid website URL.</div>
            </div>

            

            

            

            <div class="button-group">
                <?php if (!$isReturning): ?>
                    <button type="submit" class="btn-primary">Next</button>
                <?php endif; ?>
                
            </div>
        </form>
    </div>
</div>

<!-- Confirmation Modal -->
<div id="confirm-modal">
    <div class="modal-content">
        <p>Once you click Next, you won't be able to change this data later.
You have to come with a New Campaign.</p>
        <div class="modal-buttons">
            <button class="btn-ok">OK</button>
            <button class="btn-cancel">Cancel</button>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loading-overlay">
    <div class="loader"></div>
    <div>OUR AI TOOL IS ANALYZING, PLEASE HOLD...</div>
</div>

<script>
    const isReturning = <?= $isReturning ? 'true' : 'false' ?>;

    function validateForm() {
        if (isReturning) return false;

        let valid = true;
        const campaign = document.getElementById('campaign_name');
        const website = document.getElementById('website');
        const product = document.getElementById('product');

        const campaignError = document.getElementById("campaign_name-error");
        const websiteError = document.getElementById("website-error");
        const productError = document.getElementById("product-error");

        campaignError.style.display = "none";
        websiteError.style.display = "none";
        productError.style.display = "none";

        campaign.classList.remove("error");
        website.classList.remove("error");
        product.classList.remove("error");

        const urlRegex = /^(https?:\/\/)?([\w\-]+\.)+[\w\-]+(\/[\w\-]*)*$/;

        if (campaign.value.trim() === "") {
            campaignError.style.display = "block";
            campaign.classList.add("error");
            valid = false;
        }

        if (!urlRegex.test(website.value.trim())) {
            websiteError.style.display = "block";
            website.classList.add("error");
            valid = false;
        }

        if (product.value.trim() === "") {
            productError.style.display = "block";
            product.classList.add("error");
            valid = false;
        }

        return valid;
    }

    function validateField(field) {
        const value = field.value.trim();
        const id = field.id;
        const errorElem = document.getElementById(id + '-error');

        if (!errorElem) return;

        if (id === 'campaign_name' || id === 'product') {
            if (value === '') {
                errorElem.style.display = 'block';
                field.classList.add('error');
            } else {
                errorElem.style.display = 'none';
                field.classList.remove('error');
            }
        }

        if (id === 'website') {
            const urlRegex = /^(https?:\/\/)?([\w\-]+\.)+[\w\-]+(\/[\w\-]*)*$/;
            if (!urlRegex.test(value)) {
                errorElem.style.display = 'block';
                field.classList.add('error');
            } else {
                errorElem.style.display = 'none';
                field.classList.remove('error');
            }
        }
    }

    ['campaign_name', 'website', 'product'].forEach(id => {
        const field = document.getElementById(id);
        if (field) {
            field.addEventListener('input', () => validateField(field));
        }
    });

    function onFormSubmit(event) {
        if (isReturning) {
            event.preventDefault();
            return false;
        }

        if (!validateForm()) {
            event.preventDefault();
            return false;
        }

        event.preventDefault();
        showModal();
        return false;
    }

    function showModal() {
        const modal = document.getElementById('confirm-modal');
        modal.classList.add('active');
    }

    function hideModal() {
        const modal = document.getElementById('confirm-modal');
        modal.classList.remove('active');
    }

    document.querySelector('#confirm-modal .btn-cancel').addEventListener('click', () => {
        hideModal();
    });

    document.querySelector('#confirm-modal .btn-ok').addEventListener('click', () => {
        hideModal();

        // Show loading overlay before submitting the form
        document.getElementById('loading-overlay').style.display = 'flex';

        document.getElementById('campaign-form').submit();
    });
</script>
