<?php
$servername = "localhost";
$username = "dropjwxg_ad_generator";
$password = "ad_generator";
$dbname = "dropjwxg_ad_generator";

// DB connect
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$campid = 2;
$sql = "SELECT response FROM apidata WHERE campid = $campid LIMIT 1";
$result = $conn->query($sql);

$responseMessage = "";

if ($result && $row = $result->fetch_assoc()) {
    $jsonString = $row['response'];

    // First decode attempt
    $decoded = json_decode($jsonString, true);

    // If still a string (double-encoded), decode again
    if (is_string($decoded)) {
        $decoded = json_decode($decoded, true);
    }

    if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
        if (isset($decoded['message'])) {
            $responseMessage = $decoded['message'];
        } else {
            $responseMessage = "⚠️ 'message' key not found.";
        }
    } else {
        $responseMessage = "❌ Still Invalid JSON after decoding.";
    }
} else {
    $responseMessage = "❌ No data found for this campaign.";
}

$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>API Message</title>
    <style>
        .msg {
            background: #fff3cd;
            border: 1px solid #ffeeba;
            color: #856404;
            padding: 20px;
            margin: 30px auto;
            width: fit-content;
            font-family: sans-serif;
            border-radius: 6px;
            font-size: 18px;
        }
    </style>
</head>
<body>

<?php if ($responseMessage): ?>
    <div class="msg">⚠️ <?= htmlspecialchars($responseMessage) ?></div>
<?php endif; ?>

</body>
</html>
