<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

include 'templates/header.php';
?>

<style>
    .main-wrapper {
        display: flex;
        min-height: 100vh;
    }

    .sidebar {
        width: 250px;
        background-color: #343a40;
        padding: 20px 0;
        color: #fff;
    }

    .sidebar a {
        display: block;
        padding: 12px 20px;
        color: #fff;
        text-decoration: none;
    }

    .sidebar a:hover,
    .sidebar a.active {
        background-color: #495057;
    }

    .main-content {
        flex-grow: 1;
        padding: 40px 30px;
        background-color: #f8f9fa;
    }

    h2.goal-heading {
        font-weight: bold;
        color: #000;
        margin-bottom: 30px;
        font-size: 28px;
    }

    .goal-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    .goal-box {
        display: flex;
        align-items: center;
        background-color: #f0f8ff;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
        transition: transform 0.2s ease;
        cursor: pointer;
        border: 2px solid transparent;
    }

    .goal-box:hover {
        transform: translateY(-3px);
    }

    .goal-box.selected {
        border: 2px solid red;
        background-color: #ffecec;
    }

    .goal-icon {
        font-size: 40px;
        margin-right: 20px;
        color: #007bff;
        flex-shrink: 0;
    }

    .goal-content {
        flex-grow: 1;
    }

    .goal-content h4 {
        margin: 0 0 8px 0;
        font-size: 22px;
        font-weight: 600;
        color: #333;
    }

    .goal-content p {
        margin: 0;
        color: #555;
        font-size: 15px;
    }

    .checkmark {
        font-size: 24px;
        color: red;
        margin-left: 15px;
        flex-shrink: 0;
    }

    .scroll-section {
        max-height: 550px;
        overflow-y: auto;
        padding-right: 5px;
    }

    .scroll-section::-webkit-scrollbar {
        width: 6px;
    }

    .scroll-section::-webkit-scrollbar-thumb {
        background: #007bff;
        border-radius: 6px;
    }

    .next-btn-container {
        margin-top: 40px;
        text-align: right;
        position: relative;
    }

    .btn-next {
        background-color: #007bff;
        color: #fff;
        padding: 12px 24px;
        border: none;
        border-radius: 6px;
        font-size: 16px;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .btn-next:hover {
        background-color: #0056b3;
    }

    .spinner {
        border: 6px solid #f3f3f3;
        border-top: 6px solid #007bff;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        animation: spin 1s linear infinite;
        margin: 0 auto;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    @media (max-width: 768px) {
        .goal-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="main-wrapper">

   <!-- Sidebar -->
<div class="sidebar">
  <nav>
    <ul class="sidebar-menu">
      <li><a href="dashboard.php" class="sidebar-link"><span class="icon">🏠</span> Dashboard</a></li>
      <li><a href="create_campaign.php" class="sidebar-link active"><span class="icon">📈</span> Create Campaign</a></li>
      <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
      <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
    </ul>
  </nav>
</div>

<style>
.sidebar {
    width: 260px;
    background-color: #1e1e2f;
    padding-top: 40px;
    padding-bottom: 40px;
    color: #ddd;
    box-shadow: 2px 0 12px rgba(0,0,0,0.2);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    user-select: none;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.sidebar-menu {
    list-style: none;
    padding: 0;
    margin: 0;
    width: 100%;
}

.sidebar-menu li {
    margin: 12px 0;
}

.sidebar-link {
    display: flex;
    align-items: center;
    text-decoration: none;
    color: #bbb;
    font-size: 18px;
    padding: 12px 24px;
    border-radius: 8px;
    transition: background-color 0.3s ease, color 0.3s ease;
}

.sidebar-link .icon {
    margin-right: 14px;
    font-size: 22px;
    line-height: 1;
}

.sidebar-link:hover {
    background: #3a3f55;
    color: #fff;
    box-shadow: 0 4px 12px rgba(58, 63, 85, 0.6);
}

.sidebar-link.active {
    background: #4f63d3;
    color: #fff;
    box-shadow: 0 4px 20px rgba(79, 99, 211, 0.7);
    font-weight: 600;
}

.sidebar-link .icon {
    margin-right: 14px;
    font-size: 20px;
    width: 32px;
    height: 32px;
    background: #fff;
    color: #4f63d3;
    border-radius: 50%;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
}

</style>


    <!-- Main content area -->
    <div class="main-content">
        <h2 class="goal-heading">What is your advertising goal?</h2>

        <div class="scroll-section">
            <div class="goal-grid">
                <div class="goal-box selected" data-goal="website_traffic">
                    <div class="goal-icon">🌐</div>
                    <div class="goal-content">
                        <h4>Website Traffic</h4>
                        <p>Drive more visitors to your website to boost online visibility & engagement.</p>
                    </div>
                    <div class="checkmark">✔</div>
                </div>

                <div class="goal-box" data-goal="brand_awareness">
                    <div class="goal-icon">📢</div>
                    <div class="goal-content">
                        <h4>Brand Awareness</h4>
                        <p>Enhance your brand's visibility and reputation to build long-term customer loyalty.</p>
                    </div>
                    <div class="checkmark" style="visibility:hidden;">✔</div>
                </div>

                <div class="goal-box" data-goal="online_leads">
                    <div class="goal-icon">📝</div>
                    <div class="goal-content">
                        <h4>Online Leads</h4>
                        <p>Capture new leads on your website & grow your client base.</p>
                    </div>
                    <div class="checkmark" style="visibility:hidden;">✔</div>
                </div>

                <div class="goal-box" data-goal="online_sales">
                    <div class="goal-icon">🛒</div>
                    <div class="goal-content">
                        <h4>Online Sales</h4>
                        <p>Increase your e-commerce sales by driving targeted traffic to your online store.</p>
                    </div>
                    <div class="checkmark" style="visibility:hidden;">✔</div>
                </div>
            </div>

            <div class="next-btn-container">
                <form id="nextForm" action="step1_submit_details.php" method="get">
                    <input type="hidden" name="goal" id="selectedGoal" value="website_traffic">
                    <button type="submit" class="btn-next" id="nextButton">Next →</button>
                </form>

                <div id="loadingStep" style="display:none;margin-top:20px;text-align:center;">
                    <div class="spinner"></div>
                    <p style="margin-top:12px;font-weight:bold;">Preparing your campaign step...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    const goalBoxes = document.querySelectorAll('.goal-box');
    const selectedGoalInput = document.getElementById('selectedGoal');
    const form = document.getElementById('nextForm');
    const nextButton = document.getElementById('nextButton');
    const loadingStep = document.getElementById('loadingStep');

    goalBoxes.forEach(box => {
        box.addEventListener('click', () => {
            goalBoxes.forEach(b => {
                b.classList.remove('selected');
                b.querySelector('.checkmark').style.visibility = 'hidden';
            });
            box.classList.add('selected');
            box.querySelector('.checkmark').style.visibility = 'visible';
            selectedGoalInput.value = box.getAttribute('data-goal');
        });
    });

    form.addEventListener('submit', function(e) {
        e.preventDefault(); // Prevent instant redirect

        nextButton.style.display = 'none';
        loadingStep.style.display = 'block';

        setTimeout(() => {
            form.submit(); // Submit after showing animation
        }, 1500);
    });
</script>

<?php include 'templates/footer.php'; ?>
