<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'templates/header.php';
?>

<style>
    .main-wrapper {
        display: flex;
        min-height: 100vh;
    }

    .sidebar {
        width: 250px;
        background-color: #343a40;
        padding: 20px 0;
        color: #fff;
    }

    .sidebar a {
        display: block;
        padding: 12px 20px;
        color: #fff;
        text-decoration: none;
    }

    .sidebar a:hover,
    .sidebar a.active {
        background-color: #495057;
    }

    .main-content {
        flex-grow: 1;
        padding: 40px 30px;
        background-color: #f8f9fa;
    }

    h2.goal-heading {
        font-weight: bold;
        color: #000;
        margin-bottom: 30px;
        font-size: 28px;
    }

    .goal-box {
        display: flex;
        align-items: flex-start;
        background-color: #f0f8ff;
        border-radius: 12px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
        transition: transform 0.2s ease;
    }

    .goal-box:hover {
        transform: translateY(-3px);
    }

    .goal-icon {
        font-size: 40px;
        margin-right: 20px;
        color: #007bff;
        flex-shrink: 0;
    }

    .goal-content h4 {
        margin: 0 0 8px 0;
        font-size: 22px;
        font-weight: 600;
        color: #333;
    }

    .goal-content p {
        margin: 0;
        color: #555;
        font-size: 15px;
    }

    .scroll-section {
        max-height: 450px;
        overflow-y: auto;
        padding-right: 5px;
    }

    .scroll-section::-webkit-scrollbar {
        width: 6px;
    }

    .scroll-section::-webkit-scrollbar-thumb {
        background: #007bff;
        border-radius: 6px;
    }
</style>

<div class="main-wrapper">

     <!-- Sidebar -->
<div class="sidebar">
  <nav>
    <ul class="sidebar-menu">
      <li><a href="dashboard.php" class="sidebar-link active"><span class="icon">🏠</span> Dashboard</a></li>
      <li><a href="create_campaign.php" class="sidebar-link "><span class="icon">📢</span> Create Campaign</a></li>
      <li><a href="competitor_step1_data.php" class="sidebar-link "><span class="icon">🎯</span> Competitor Analysis</a></li>
      
      <li><a href="howitswork.php" class="sidebar-link"><span class="icon">💡</span> How it Works? </a></li>
      <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
      <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
    </ul>
  </nav>
</div>

<style>
.sidebar {
    width: 260px;
    background-color: #1e1e2f;
    padding-top: 40px;
    padding-bottom: 40px;
    color: #ddd;
    box-shadow: 2px 0 12px rgba(0,0,0,0.2);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    user-select: none;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.sidebar-menu {
    list-style: none;
    padding: 0;
    margin: 0;
    width: 100%;
}

.sidebar-menu li {
    margin: 12px 0;
}

.sidebar-link {
    display: flex;
    align-items: center;
    text-decoration: none;
    color: #bbb;
    font-size: 18px;
    padding: 12px 24px;
    border-radius: 8px;
    transition: background-color 0.3s ease, color 0.3s ease;
}

.sidebar-link .icon {
    margin-right: 14px;
    font-size: 22px;
    line-height: 1;
}

.sidebar-link:hover {
    background: #3a3f55;
    color: #fff;
    box-shadow: 0 4px 12px rgba(58, 63, 85, 0.6);
}

.sidebar-link.active {
    background: #4f63d3;
    color: #fff;
    box-shadow: 0 4px 20px rgba(79, 99, 211, 0.7);
    font-weight: 600;
}

.sidebar-link .icon {
    margin-right: 14px;
    font-size: 20px;
    width: 32px;
    height: 32px;
    background: #fff;
    color: #4f63d3;
    border-radius: 50%;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
}

</style>

    <!-- Main content -->
    <div class="main-content">
        <h2>👋 Welcome back, <?php echo htmlspecialchars($_SESSION['username']); ?>!</h2>

        <div class="card">
            <p>This is your dashboard overview. From here, you can manage campaigns, view performance, and more.</p>
        </div>

        <!-- How It Works Section -->
        <h2>🚀 How It Works</h2>

        <div class="card">
            <h3 style="color: #007bff;">Step 1: Submit Your Website & Product Name</h3>
            <p>We use your website and product details to understand your niche and target audience.</p>
        </div>

        <div class="card">
            <h3 style="color: #28a745;">Step 2: Our AI Tool Analyzes & Suggests</h3>
            <ul>
                <li>✅ Ad Descriptions</li>
                <li>✅ Suggested Keywords</li>
                <li>✅ Estimated CTR (Click-Through Rate)</li>
                <li>✅ Estimated CPC (Cost Per Click)</li>
                <li>✅ Recommended Budget</li>
                <li>✅ Competitive Level</li>
            </ul>
        </div>

        <div class="card">
            <h3 style="color: #ffc107;">Step 3: Preview and Launch</h3>
            <p>Once you're happy with the results, you can preview your ad and get ready to publish it on Google Ads.</p>
        </div>
    </div>
</div>

<?php include 'templates/footer.php'; ?>
