<?php
include 'db_config.php';

header('Content-Type: application/json');

$conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");

if ($conn->connect_error) {
    echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

$reviews = [];
$sql = "SELECT 
            r.comment,
            r.created_at,
            u.firstname,
            u.country
        FROM reviews r
        JOIN users u ON r.userid = u.id
        ORDER BY r.id DESC LIMIT 10";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $created_time = strtotime($row['created_at']);
        $time_diff = time() - $created_time;

        if ($time_diff < 60) {
            $time_string = "just now";
        } elseif ($time_diff < 3600) {
            $minutes = floor($time_diff / 60);
            $time_string = $minutes . " minute" . ($minutes > 1 ? "s" : "") . " ago";
        } elseif ($time_diff < 86400) {
            $hours = floor($time_diff / 3600);
            $time_string = $hours . " hour" . ($hours > 1 ? "s" : "") . " ago";
        } else {
            $days = floor($time_diff / 86400);
            $time_string = $days . " day" . ($days > 1 ? "s" : "") . " ago";
        }
        $row['time_ago'] = $time_string;
        $reviews[] = $row;
    }
}
$conn->close();

echo json_encode($reviews);
?>