<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['website'])) {
    $url = filter_var($_POST['website'], FILTER_VALIDATE_URL);

    if (!$url) {
        echo "Invalid URL.";
        return;
    }

    $html = @file_get_contents($url);
    if (!$html) {
        echo "Unable to fetch website content.";
        return;
    }

    $doc = new DOMDocument();
    @$doc->loadHTML($html);
    $tags = $doc->getElementsByTagName('p');

    $text = '';
    foreach ($tags as $tag) {
        $text .= $tag->nodeValue . ' ';
    }

    $words = str_word_count(strtolower(strip_tags($text)), 1);
    $freq = array_count_values($words);
    arsort($freq);
    $keywords = array_slice(array_keys($freq), 0, 5);

    $headline = "Get the Best " . ucfirst($keywords[0]) . " Services";
    $description = "Looking for reliable " . $keywords[0] . "? Visit us now and see why people choose us for " . $keywords[1] . " and " . $keywords[2] . ".";

    echo "<h3>Suggested Google Ad:</h3>";
    echo "<div style='border:1px solid #ccc; padding:15px; max-width:400px;'>
            <strong>$headline</strong><br>
            <span>$description</span><br>
            <a href='$url' target='_blank'>$url</a>
          </div>";

    echo "<h4>Top Keywords:</h4>";
    echo implode(', ', $keywords);
}
?>
