<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    echo json_encode(['error'=>'Not logged in']);
    exit;
}

$userid = (int)$_SESSION['user_id'];
$campid = (int)($_GET['campid'] ?? 0);

if (!$campid) {
    http_response_code(400);
    echo json_encode(['error'=>'Missing campaign ID']);
    exit;
}

$conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");
$conn->set_charset('utf8mb4');

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error'=>'DB connection failed']);
    exit;
}

// Fetch campaign info
$camp_sql = "SELECT * FROM campaign WHERE campid=$campid AND userid=$userid LIMIT 1";
$camp_res = $conn->query($camp_sql);

if(!$camp_res || $camp_res->num_rows == 0){
    http_response_code(404);
    echo json_encode(['error'=>'Campaign not found']);
    exit;
}

$campaign = $camp_res->fetch_assoc();

// Fetch related action (status=1) with aliases for consistency
$action_sql = "
SELECT 
    website,
    Productname,
    language,
    Platform,
    UniqueVisitors,
    `Bounce Rate` AS BounceRate,
    geo,
    devices AS device,
    platlinks AS platlinksjason,
    startdate,
    endate
FROM actions
WHERE campid=$campid AND status=1
LIMIT 1
";
$action_res = $conn->query($action_sql);

$action = $action_res && $action_res->num_rows > 0 ? $action_res->fetch_assoc() : [];

// Merge campaign + action data
$result = array_merge($campaign, $action);

echo json_encode($result);

$conn->close();
?>