<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'templates/header.php';
?>

<style>
    .main-wrapper {
        display: flex;
        min-height: 100vh;
    }

    /* Sidebar styles */
    .sidebar {
        width: 260px;
        background-color: #1e1e2f;
        padding-top: 40px;
        padding-bottom: 40px;
        color: #ddd;
        box-shadow: 2px 0 12px rgba(0, 0, 0, 0.2);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        user-select: none;
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .sidebar-menu {
        list-style: none;
        padding: 0;
        margin: 0;
        width: 100%;
    }

    .sidebar-menu li {
        margin: 12px 0;
    }

    .sidebar-link {
        display: flex;
        align-items: center;
        text-decoration: none;
        color: #bbb;
        font-size: 18px;
        padding: 12px 24px;
        border-radius: 8px;
        transition: background-color 0.3s ease, color 0.3s ease;
    }

    .sidebar-link .icon {
        margin-right: 14px;
        font-size: 20px;
        width: 32px;
        height: 32px;
        background: #fff;
        color: #4f63d3;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
    }

    .sidebar-link:hover {
        background: #3a3f55;
        color: #fff;
        box-shadow: 0 4px 12px rgba(58, 63, 85, 0.6);
    }

    .sidebar-link.active {
        background: #4f63d3;
        color: #fff;
        box-shadow: 0 4px 20px rgba(79, 99, 211, 0.7);
        font-weight: 600;
    }

    /* Main content */
    .main-content {
        flex-grow: 1;
        padding: 40px 30px;
        background-color: #f8f9fa;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* How It Works Section */

    .how-steps-row {
        display: flex;
        gap: 20px;
        justify-content: center;
        align-items: center;
        margin-bottom: 30px;
        position: relative;
    }

    .how-steps-row .card {
        width: 320px;
        padding: 24px 28px;
        font-size: 16px;
        border-radius: 12px;
        color: #fff;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease;
        position: relative;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        cursor: default;
    }

    .how-steps-row .card:hover {
        transform: translateY(-6px);
    }

    /* Colorful gradient backgrounds for Step 1 and Step 2 */
    .step1 {
        background: linear-gradient(135deg, #007bff, #0056b3);
        border-left: none;
        box-shadow: 0 8px 20px rgba(0, 123, 255, 0.4);
    }

    .step2 {
        background: linear-gradient(135deg, #28a745, #1e7e34);
        border-left: none;
        box-shadow: 0 8px 20px rgba(40, 167, 69, 0.4);
    }

    .how-arrow {
        font-size: 48px;
        color: #666;
        font-style: italic;
        user-select: none;
        margin: 0 10px;
        flex-shrink: 0;
        transition: color 0.3s ease;
    }

    .how-arrow:hover {
        color: #000;
    }

    .how-center {
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
        margin-bottom: 40px;
        gap: 20px;
    }

    .how-center .card {
        width: 340px;
        padding: 28px 32px;
        font-size: 16px;
        border-radius: 12px;
        color: #212529;
        background: linear-gradient(135deg, #ffc107, #e0a800);
        box-shadow: 0 8px 20px rgba(255, 193, 7, 0.4);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        transition: transform 0.3s ease;
        cursor: default;
    }

    .how-center .card:hover {
        transform: translateY(-6px);
    }

    /* Vertical arrow between rows */
    .vertical-arrow {
        font-size: 48px;
        color: #666;
        font-style: italic;
        user-select: none;
        margin-left: 10px;
        transform: rotate(90deg);
        transition: color 0.3s ease;
    }

    .vertical-arrow:hover {
        color: #000;
    }
    
    h2 {
  text-align: center;
  font-size: 40px;
  font-weight: 700;
  margin-bottom: 40px;
}

</style>

<div class="main-wrapper">

    <!-- Sidebar -->
    <div class="sidebar">
        <nav>
            <ul class="sidebar-menu">
                <li><a href="dashboard.php" class="sidebar-link active"><span class="icon">🏠</span> Dashboard</a></li>
                <li><a href="create_campaign.php" class="sidebar-link"><span class="icon">📈</span> Create Campaign</a></li>
                <li><a href="howitswork.php" class="sidebar-link"><span class="icon">💡</span> How it works?</a></li>
                <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
                <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
            </ul>
        </nav>
    </div>

    <!-- Main content -->
    <div class="main-content">

        <!-- How It Works Section -->
        <h2>🚀How It Works🚀</h2>

        <div class="how-steps-row">
            <div class="card step1">
                <h3>Step 1: Submit Website & Product</h3>
                <p>We use your website and product details to understand your niche and audience.</p>
            </div>

            <div class="how-arrow" aria-hidden="true">➔</div>

            <div class="card step2">
                <h3>Step 2: AI Analyzes & Suggests</h3>
                <ul>
                    
                    <li>✅ Ad Descriptions</li>
                    <li>✅ Keywords</li>
                    <li>✅ CTR & CPC</li>
                    <li>✅ Budget & Competition</li>
                </ul>
            </div>
        </div>

        <div class="how-center">
            <div class="vertical-arrow" aria-hidden="true">➔</div>
            <div class="card">
                <h3>Step 3: Preview and Launch</h3>
                <p>Review the AI suggestions and launch your campaign on Google Ads.</p>
            </div>
        </div>

    </div>
</div>

<?php include 'templates/footer.php'; ?>
