<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require 'config.php';
include 'templates/header.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    if (empty($email) || empty($password)) {
        $error = "Please enter both email and password.";
    } else {
        $stmt = $conn->prepare("SELECT id, password, role FROM users WHERE email = ?");
        if (!$stmt) {
            $error = "Prepare failed: " . $conn->error;
        } else {
            $stmt->bind_param("s", $email);
            $stmt->execute();
            $stmt->bind_result($id, $hashed_password, $role);

            if ($stmt->fetch()) {
                if (password_verify($password, $hashed_password)) {
                    $_SESSION['user_id'] = $id;
                    $_SESSION['role'] = $role;

                    if ($role === 'admin') {
                        header("Location: admin.php");
                    } else {
                        header("Location: dashboard.php");
                    }
                    exit;
                } else {
                    $error = "Incorrect password.";
                }
            } else {
                $error = "No user found with that email.";
            }

            $stmt->close();
        }
    }
}
?>

<!-- Style -->
<style>
  .login-wrapper {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 90vh;
    
  }

  .login-container {
    background: #ffffff;
    padding: 2.5rem 3rem;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
    width: 100%;
    max-width: 400px;
    text-align: center;
  }

  .login-container h2 {
    margin-bottom: 1.5rem;
    color: #333;
  }

  form {
    display: flex;
    flex-direction: column;
    gap: 1rem;
  }

  input[type="email"],
  input[type="password"] {
    padding: 0.75rem 1rem;
    font-size: 1rem;
    border: 1px solid #ccc;
    border-radius: 8px;
    width: 100%;
  }

  .form-options {
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 0.9rem;
    margin-top: -0.5rem;
  }

  .form-options label {
    display: flex;
    align-items: center;
    gap: 5px;
  }

  .form-options a {
    color: #007bff;
    text-decoration: none;
  }

  .form-options a:hover {
    text-decoration: underline;
  }

  button {
    background-color: #007bff;
    color: #ffffff;
    border: none;
    padding: 0.75rem;
    border-radius: 8px;
    font-size: 1.05rem;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.3s ease;
  }

  button:hover {
    background-color: #0056b3;
  }

  .error-message {
    background-color: #f8d7da;
    color: #842029;
    padding: 0.75rem 1rem;
    margin-bottom: 1rem;
    border-radius: 8px;
    font-size: 0.9rem;
  }

  .signup-link {
    margin-top: 1rem;
    font-size: 0.9rem;
  }

  .signup-link a {
    color: #007bff;
    text-decoration: none;
    font-weight: 500;
  }

  .signup-link a:hover {
    text-decoration: underline;
  }
  
   body, html {
    height: 100%;
    width:100%;
    margin: 0;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #667eea, #764ba2);
    display: flex;
    justify-content: center;
    align-items: center;
  }
</style>

<!-- Login HTML -->
<div class="login-wrapper">
  <div class="login-container">
    <h2>Login</h2>

    <?php if (!empty($error)) : ?>
      <div class="error-message"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" novalidate>
      <input type="email" name="email" placeholder="Email Address" required />
      <input type="password" name="password" placeholder="Password" required />

      <div class="form-options">
        <label><input type="checkbox" name="remember"> Remember me</label>
        <a href="forgot_password.php">Forgot Password?</a>
      </div>

      <button type="submit">Log In</button>
    </form>

    <div class="signup-link">
      Don’t have an account? <a href="register.php">Sign Up</a>
    </div>
  </div>
</div>
