<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// TEMP: show PHP errors while we fix (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'templates/header.php';

$userid = (int)$_SESSION['user_id'];
$savedDevice = $row['device'] ?? 'desktop'; // This line is not used to load campaigns but is harmless

$conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");
if ($conn->connect_error) { die("Connection failed: " . $conn->connect_error); }
$conn->set_charset('utf8mb4');

/**
 * Fetch first name from users table
 */
$firstName = 'User'; // fallback
$user_sql = "SELECT firstname FROM users WHERE id = $userid LIMIT 1";
$user_res = $conn->query($user_sql);
if ($user_res && $user_res->num_rows > 0) {
    $user_row = $user_res->fetch_assoc();
    $firstName = $user_row['firstname'];
}

/**
 * Fetch campaigns
 */
/**
 * Final working code:
 * Fetches only campaigns that have a valid start and end date.
 */
/**
 * Final working code:
 * Fetches campaigns and sets status based on end date.
 */
$sql = "
SELECT
    c.campid,
    c.Name,
    CASE
        WHEN a.endate < CURDATE() THEN 0
        ELSE IFNULL(MAX(a.status), 0)
    END AS status,
    MAX(a.startdate) AS startdate,
    MAX(a.endate) AS endate
FROM
    campaign c
JOIN
    actions a ON a.campid = c.campid
WHERE
    c.userid = $userid
    AND a.endate IS NOT NULL AND a.endate <> '' AND a.endate <> '0000-00-00'
GROUP BY
    c.campid
ORDER BY
    c.campid DESC
";

$campaigns_res = $conn->query($sql);
$campaigns = [];
if ($campaigns_res) {
    while ($row = $campaigns_res->fetch_assoc()) {
        $campaigns[] = $row;
    }
}
?>
<style>
/* Custom Alert Styles */
.custom-alert-container {
    position: fixed;
    bottom: 20px;
    left: 50%;
    transform: translateX(-50%);
    z-index: 2000;
    opacity: 0;
    visibility: hidden;
    transition: opacity 0.5s ease, visibility 0.5s ease;
    padding: 15px 30px;
    background-color: #4CAF50; /* Green background */
    color: white;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    font-family: sans-serif;
    display: flex;
    align-items: center;
    gap: 15px;
}

.custom-alert-container.show {
    opacity: 1;
    visibility: visible;
}

.custom-alert-icon {
    font-size: 24px;
}
/* --- Existing CSS --- */
.form-group { width: 100%; max-width: 800px; margin: 10px auto; }
.main-wrapper { display: flex; min-height: 100vh; }
.sidebar { width: 250px !important; background-color: #1e1e2f; padding: 40px 0; color: #ddd; box-shadow: 2px 0 12px rgba(0,0,0,0.2); font-family: 'Segoe UI', sans-serif; display: flex; flex-direction: column; align-items: center; }
.sidebar-menu { list-style: none; padding: 0; margin: 0; width: 100%; }
.sidebar-menu li { margin: 12px 0; }
.sidebar-link { display: flex; align-items: center; text-decoration: none; color: #bbb; font-size: 18px; padding: 12px 24px; border-radius: 8px; transition: background-color 0.3s ease, color 0.3s ease; }
.sidebar-link .icon { margin-right: 14px; font-size: 20px; width: 32px; height: 32px; background: #fff; color: #4f63d3; border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1); }
.sidebar-link:hover { background: #3a3f55; color: #fff; box-shadow: 0 4px 12px rgba(58,63,85,0.6); }
.sidebar-link.active { background: #4f63d3; color: #fff; box-shadow: 0 4px 20px rgba(79,99,211,0.7); font-weight:600; }

.main-content { flex-grow: 1; padding: 40px 30px; background-color: #f8f9fa; display:flex; flex-direction:column; gap:20px; }
.dashboard-header, .welcome-section { padding: 10px 15px; margin-bottom: 10px; }

.campaign-list { display: flex; flex-wrap: wrap; gap: 20px; max-height: 400px; overflow-y: auto; padding-right: 8px; }
.campaign-card { flex: 1 1 calc(50% - 20px); height: 200px; box-sizing: border-box; border: 1px solid #ddd; border-radius: 10px; padding: 15px; background: #fff; cursor:pointer; }

.empty-state { padding:16px; background:#fff; border-radius:10px; border:1px dashed #cdd3ea; color:#556; }

/* --- Modal Styles --- */
.details { display:none; position: fixed; top:0; left:0; width:100%; height:100%; z-index:1000; }
.modal-overlay { position:absolute; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); 
    
}
.modal-content { position:relative; background:#fff; width:90%; max-width:900px; margin:50px auto; padding:20px 30px; border-radius:10px; max-height:80%; overflow-y:auto; box-shadow:0 5px 20px rgba(0,0,0,0.3); }
.close-btn { position:absolute; top:15px; right:15px; background:none; border:none; font-size:20px; cursor:pointer; }
.modal-content h2 { margin-top:0; }

/* Form Columns */
.modal-content form { display:block; }
.modal-content label { display:block; margin-top:10px; font-weight:bold; }
.modal-content input, .modal-content textarea, .modal-content select { width:100%; padding:8px; margin-top:5px; border-radius:5px; border:1px solid #ccc; }

/* Step containers */
.form-step { display:none; }
.form-step.active { display:block; }
.step-actions { display:flex; justify-content:flex-end; gap:12px; margin-top:16px; }
.modal-content .btn { padding:10px 16px; border:none; border-radius:6px; cursor:pointer; }
.btn-primary { background:#4f63d3; color:#fff; }
.btn-secondary { background:#e5e7eb; color:#111827; }
.btn-primary:hover { background:#3548a1; }

/* Waving hand animation */
.wave-hand { display: inline-block; animation: wave 2s infinite; transform-origin: 70% 70%; }
@keyframes wave { 0% { transform: rotate(0deg); } 10% { transform: rotate(14deg); } 20% { transform: rotate(-8deg); } 30% { transform: rotate(14deg); } 40% { transform: rotate(-4deg); } 50% { transform: rotate(10deg); } 60% { transform: rotate(0deg); } 100% { transform: rotate(0deg); } }

/* Platform tabs (from first code) */
.platform-tab {
  padding: 8px 14px;
  border: 1px solid #ccc;
  background-color: #f9f9f9;
  cursor: pointer;
  border-radius: 6px;
  color: #000;
  transition: background-color 0.2s ease;
}
.platform-tab.active { background-color: #4f63d3; color: #fff; border-color: #4f63d3; }

/* Device tabs (your style) */
.device-tab {
  padding: 8px 14px;
  border: 1px solid #ccc;
  background-color: #f9f9f9;
  cursor: pointer;
  border-radius: 6px;
  color: #000;
  transition: background-color 0.2s ease;
}
.device-tab:hover:not(.active) { background-color: #d4d9f8; }
.device-tab.active {
  background-color: #FF0000;
  border-color: #1a237e;
  color: white;
  font-weight: 700;
  box-shadow: 0 6px 20px rgba(26, 35, 126, 0.5);
}
.device-tabs-container { display:flex; flex-wrap:wrap; gap:10px; }

/* Tooltip (from first code) */
.info-icon { position: relative; display:inline-block; cursor: pointer; font-size: 16px; color: #e53935; }
.info-icon .tooltip {
  visibility: hidden; width: 200px; background-color: #3949ab; color: #fff; text-align: left; border-radius: 6px; padding: 8px;
  position: absolute; z-index: 1; bottom: 125%; left: 50%; transform: translateX(-50%); opacity: 0; transition: opacity 0.3s ease;
}
.info-icon:hover .tooltip, .info-icon:focus .tooltip { visibility: visible; opacity: 1; }
.info-icon .tooltip::after {
  content:""; position:absolute; top:100%; left:50%; transform:translateX(-50%);
  border-width:6px; border-style:solid; border-color:#3949ab transparent transparent transparent;
}

.close-btn { 
    position:absolute; 
    top:10px; 
    right:10px; 
    background:#4f63d3; 
    color: #fff; 
    border: none; 
    width: 30px; 
    height: 30px;
    border-radius: 50%;
    font-size: 16px;
    cursor: pointer; 
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 2px 5px rgba(0,0,0,0.3);
}

.custom-alert-container {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    z-index: 2000;
    opacity: 0;
    visibility: hidden;
    transition: opacity 0.5s ease, visibility 0.5s ease;
    padding: 10px 30px; /* Reduced vertical padding for a smaller height */
    background-color: #E53935; /* Red background */
    color: white;
    font-weight: bold; /* Make the text bold */
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    font-family: sans-serif;
    display: flex;
    align-items: center;
    gap: 15px;
}

/* Small helpers */
.small { font-size:12px; color:#666; }

/* Status Notification Styles */
.status-notification-container {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    z-index: 2000;
    opacity: 0;
    visibility: hidden;
    transition: all 0.5s ease;
    padding: 15px 40px;
    background-color: #333; /* Dark gray background for neutrality */
    color: white;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    font-family: sans-serif;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
}

.status-notification-container.show {
    opacity: 1;
    visibility: visible;
}

.status-notification-icon {
    font-size: 3rem;
    margin-bottom: 10px;
    width: 3rem;
    height: 3rem;
}

/* Loading spinner animation */
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.status-notification-container .spinner::before {
    content: "🔄";
    display: block;
    animation: spin 1.2s infinite linear;
}

/* Success message styling */
.status-notification-container .success::before {
    content: "✅";
    font-size: 3rem;
    display: block;
    animation: none;
}
/* New CSS for the Campaign Grid and Blinking Light */
.campaign-list {
  display: grid;
  grid-template-columns: repeat(3, 1fr); /* Creates a 3-column layout */
  gap: 20px;
  max-height: 400px;
  overflow-y: auto;
  padding-right: 8px;
}
.campaign-card {
  height: auto; /* Allow height to adjust to content */
  box-sizing: border-box;
  border: 1px solid #ddd;
  border-radius: 10px;
  padding: 20px;
  background: #fff;
  cursor: pointer;
  display: flex;
  flex-direction: column;
  gap: 10px;
}
.campaign-name {
  font-size: 1.2rem;
  font-weight: bold;
}
.campaign-status {
  display: flex;
  align-items: center;
  gap: 8px;
  font-weight: bold;
}
.status-bulb {
  width: 12px;
  height: 12px;
  border-radius: 50%;
  background-color: #ccc;
}
.status-bulb.active {
  background-color: #4CAF50; /* Green color */
  box-shadow: 0 0 10px #4CAF50;
  animation: blink 1.5s infinite;
}
@keyframes blink {
  0% { opacity: 0.2; }
  50% { opacity: 1; }
  100% { opacity: 0.2; }
}
.campaign-dates {
  font-size: 0.9rem;
  color: #666;
}

.status-bulb.inactive {
    

    background-color:  #dc3545; /* Green color */
  box-shadow: 0 0 10px #4CAF50;
  animation: blink 1.5s infinite;
}

.status-bulb {
  width: 12px;
  height: 12px;
  border-radius: 50%;
  background-color: #ccc;
}


@keyframes blink-red-bulb {
    0%   { color: red; } /* Red color at the start */
    50%  { color: gray; } /* Changes to gray in the middle */
    100% { color: red; } /* Returns to red at the end */
}

.animated-heading {
    display: flex;
    align-items: center;
}

.animated-icon {
    font-size: 2rem;
    margin-right: 10px;
    animation: shake 0.82s cubic-bezier(.36,.07,.19,.97) both infinite;
    transform: translate3d(0, 0, 0);
    backface-visibility: hidden;
    perspective: 1000px;
}

@keyframes shake {
    10%, 90% {
        transform: translate3d(-1px, 0, 0);
    }
    
    20%, 80% {
        transform: translate3d(2px, 0, 0);
    }

    30%, 50%, 70% {
        transform: translate3d(-4px, 0, 0);
    }

    40%, 60% {
        transform: translate3d(4px, 0, 0);
    }
}
</style>

<div class="main-wrapper">
  <div class="sidebar">
    <nav>
      <ul class="sidebar-menu">
        <li><a href="dashboard.php" class="sidebar-link active"><span class="icon">🏠</span> Dashboard</a></li>
        <li><a href="create_campaign.php" class="sidebar-link"><span class="icon">📢</span> Create Campaign</a></li>
<li><a href="mycampaign.php" class="sidebar-link"><span class="icon">📋</span> My Campaigns</a></li>
        <li><a href="competitor_step1_data.php" class="sidebar-link"><span class="icon">🎯</span> Competitor Analysis</a></li>
        <li><a href="howitswork.php" class="sidebar-link"><span class="icon">💡</span> How it Works?</a></li>
        <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
        <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
      </ul>
    </nav>
  </div>

  <div class="main-content">
    <h2><span class="wave-hand">👋</span> Welcome back, <?= htmlspecialchars($firstName ?? 'User'); ?>!</h2>
    <p><b><span style="color:red;">This is your campaigns overview. Click on a campaign to view or edit details.</span></b></p>
<h2 class="animated-heading">
    <span class="animated-icon">📋</span> My Campaigns
</h2>

   <div class="campaign-list" id="campaignList">
    <?php if (!empty($campaigns)): ?>
        <?php foreach($campaigns as $campaign): ?>
            <div class="campaign-card" data-campid="<?= (int)$campaign['campid'] ?>">
                <div class="campaign-name"><?= htmlspecialchars($campaign['Name']) ?></div>
                <div class="campaign-status">
                    Status:
                    <?php if ($campaign['status'] == 1): ?>
                        <span class="status-bulb active"></span> Active
                    <?php else: ?>
                    
                         <span class="status-bulb inactive"></span>Inactive
                    <?php endif; ?>
                </div>
                <div class="campaign-dates">
                    Start: <?= htmlspecialchars($campaign['startdate'] ?? 'N/A') ?><br>
                    End: <?= htmlspecialchars($campaign['endate'] ?? 'N/A') ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="empty-state">
            <p>You don't have any active campaigns yet. Get started by creating one!</p>
        </div>
    <?php endif; ?>
</div>

    <div class="details" id="campaignDetails">
      <div class="modal-overlay" onclick="closeCampaignDetails()"></div>
      <div class="modal-content">
        <button class="close-btn" onclick="closeCampaignDetails()">✖</button>
        <h2 style="text-align: center;">Campaign Details</h2>

        <form id="campaignForm">
          <input type="hidden" id="campid" name="campid" value="">
          <input type="hidden" id="actionid" name="actionid" value="">

          <div class="form-step active" id="step1">
           <h3 style="text-align: center; color: red;">Step 1: Submit Your Website & Product</h3>
            
            <label for="campaign_name">
              Campaign Name:
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">You can set Campaign Name</span>
              </span>
            </label>
            <input type="text" id="campaign_name" name="campaign_name" placeholder="My Campaign">

            <label for="website">
              Website URL:
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">Please type your correct URL</span>
              </span>
            </label>
            <input type="url" id="website" name="website" placeholder="https://example.com">
            <div id="website-error" class="error-msg" style="display:none; color:#e53935; margin-top:4px;">Please enter a valid website URL.</div>
            <div id="website-empty-error" class="error-msg" style="display:none; color:#e53935; margin-top:4px;">You cannot submit a campaign without a website URL.</div>

            <label for="Productname">
              Product Name:
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">Please Type your Product Name</span>
              </span>
            </label>
            <input type="text" id="Productname" name="Productname" placeholder="Your product">

            <label for="language">
              Language:
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">Please select your site language</span>
              </span>
            </label>
            <select id="language" name="language">
              <option value="English">🇬🇧 English</option>
              <option value="Spanish">🇪🇸 Spanish</option>
              <option value="French">🇫🇷 French</option>
              <option value="German">🇩🇪 German</option>
              <option value="Sinhala">🇱🇰 Sinhala</option>
            </select>

            <label>
              Platform:
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">Please select Platform (default: Direct)</span>
              </span>
            </label>
            <div id="platform-tabs" style="display:flex; gap:10px; margin-bottom:8px;">
              <button type="button" class="platform-tab active" data-value="Organic">Organic</button>
              <button type="button" class="platform-tab" data-value="Referral">Referral</button>
              <button type="button" class="platform-tab" data-value="Social">Social</button>
              <button type="button" class="platform-tab" data-value="Direct">Direct</button>
            </div>
            <input type="hidden" name="Platform" id="Platform" value="Direct" />

            <div id="platform-links-container">
              <div id="platform-description" class="small" style="color:#444; margin-bottom:4px;">
                Organic traffic: free visits from search engines.
              </div>
              <label id="platform-links-label" for="platlinks">Enter Your Keywords (one per line):</label>
              <textarea id="platlinksjason" name="platlinksjason" rows="4" style="width:100%;" placeholder="Enter one entry per line"></textarea>
              <div id="platform-links-error" class="error-msg" style="display:none; color:#e53935;">
                Please enter at least one entry.
              </div>
            </div>

            <div class="step-actions">
              <button type="button" class="btn btn-primary" id="to-step2">Next</button>
            </div>
          </div>

          <div class="form-step" id="step2">
           <h3 style="text-align: center; color: red;">Step 2: Traffic & Targeting</h3>

            <label for="UniqueVisitors">
              Unique Visitors per Day:
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">Enter how many unique visitors are expected per day.</span>
              </span>
            </label>
            <input type="number" id="UniqueVisitors" name="UniqueVisitors" min="0" value="0" placeholder="Ex: 1000 daily">

            <label for="BounceRate">
              Bounce Rate (%):
              <span id="bounce-rate-display">50</span>%
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">Percentage of visitors who view one page</span>
              </span>
            </label>
            <input type="range" id="bounce-rate-range" min="0" max="100" value="50" step="1" />
            <input type="number" id="BounceRate" name="BounceRate" min="0" max="100" value="50" style="margin-top:8px;" />

            <label>Devices:
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">Choose which devices to target</span>
              </span>
            </label>
            <div class="device-tabs-container">
              <button type="button" class="device-tab active" data-device="desktop" title="Only desktop visitors">
                🖥️ Desktop
              </button>
              <button type="button" class="device-tab" data-device="mobile" title="Only mobile visitors">
                📱 Mobile
              </button>
              <button type="button" class="device-tab" data-device="tablet" title="Only tablet visitors">
                📲 Tablet
              </button>
              <button type="button" class="device-tab" data-device="random" title="Random device visitors">
                🎲 Random
              </button>
              <button type="button" class="device-tab" data-device="realistic" title="Realistic device visitors">
                🤖 Realistic
              </button>
            </div>
            <input type="hidden" name="device" id="device" value="desktop" />
            <input type="hidden" name="devices" id="devices" value="desktop" />

            <label for="geo">
              Geo Targeting:
              <span class="info-icon" tabindex="0">ℹ️
                <span class="tooltip">Select target Country 100% Residential IPs</span>
              </span>
            </label>
            <small class="small">Please select at least one country. (Hold CTRL/Command to select multiple)</small>
            <select id="geo" name="geo[]" multiple
              style="width: 100%; height: 250px; font-size: 14px; line-height: 1.5; padding: 4px;">
              <option value="ALLcountry" selected>All-Country</option>
              <option value="AF">Afghanistan</option>
              <option value="AL">Albania</option>
              <option value="DZ">Algeria</option>
              <option value="AD">Andorra</option>
              <option value="AO">Angola</option>
              <option value="AR">Argentina</option>
              <option value="AM">Armenia</option>
              <option value="AU">Australia</option>
              <option value="AT">Austria</option>
              <option value="AZ">Azerbaijan</option>
              <option value="BH">Bahrain</option>
              <option value="BD">Bangladesh</option>
              <option value="BY">Belarus</option>
              <option value="BE">Belgium</option>
              <option value="BT">Bhutan</option>
              <option value="BO">Bolivia</option>
              <option value="BA">Bosnia and Herzegovina</option>
              <option value="BR">Brazil</option>
              <option value="BG">Bulgaria</option>
              <option value="KH">Cambodia</option>
              <option value="CM">Cameroon</option>
              <option value="CA">Canada</option>
              <option value="CL">Chile</option>
              <option value="CN">China</option>
              <option value="CO">Colombia</option>
              <option value="CR">Costa Rica</option>
              <option value="HR">Croatia</option>
              <option value="CU">Cuba</option>
              <option value="CY">Cyprus</option>
              <option value="CZ">Czech Republic</option>
              <option value="DK">Denmark</option>
              <option value="DO">Dominican Republic</option>
              <option value="EC">Ecuador</option>
              <option value="EG">Egypt</option>
              <option value="SV">El Salvador</option>
              <option value="EE">Estonia</option>
              <option value="ET">Ethiopia</option>
              <option value="FI">Finland</option>
              <option value="FR">France</option>
              <option value="DE">Germany</option>
              <option value="GH">Ghana</option>
              <option value="GR">Greece</option>
              <option value="HK">Hong Kong</option>
              <option value="HU">Hungary</option>
              <option value="IS">Iceland</option>
              <option value="IN">India</option>
              <option value="ID">Indonesia</option>
              <option value="IR">Iran</option>
              <option value="IQ">Iraq</option>
              <option value="IE">Ireland</option>
              <option value="IL">Israel</option>
              <option value="IT">Italy</option>
              <option value="JP">Japan</option>
              <option value="JO">Jordan</option>
              <option value="KZ">Kazakhstan</option>
              <option value="KE">Kenya</option>
              <option value="KR">Korea, South</option>
              <option value="KW">Kuwait</option>
              <option value="LV">Latvia</option>
              <option value="LB">Lebanon</option>
              <option value="LT">Lithuania</option>
              <option value="LU">Luxembourg</option>
              <option value="MY">Malaysia</option>
              <option value="MV">Maldives</option>
              <option value="MT">Malta</option>
              <option value="MX">Mexico</option>
              <option value="MD">Moldova</option>
              <option value="MC">Monaco</option>
              <option value="MN">Mongolia</option>
              <option value="MA">Morocco</option>
              <option value="NP">Nepal</option>
              <option value="NL">Netherlands</option>
              <option value="NZ">New Zealand</option>
              <option value="NG">Nigeria</option>
              <option value="NO">Norway</option>
              <option value="OM">Oman</option>
              <option value="PK">Pakistan</option>
              <option value="PA">Panama</option>
              <option value="PE">Peru</option>
              <option value="PH">Philippines</option>
              <option value="PL">Poland</option>
              <option value="PT">Portugal</option>
              <option value="QA">Qatar</option>
              <option value="RO">Romania</option>
              <option value="RU">Russia</option>
              <option value="SA">Saudi Arabia</option>
              <option value="RS">Serbia</option>
              <option value="SG">Singapore</option>
              <option value="SK">Slovakia</option>
              <option value="SI">Slovenia</option>
              <option value="ZA">South Africa</option>
              <option value="ES">Spain</option>
              <option value="LK">Sri Lanka</option>
              <option value="SE">Sweden</option>
              <option value="CH">Switzerland</option>
              <option value="TW">Taiwan</option>
              <option value="TH">Thailand</option>
              <option value="TR">Turkey</option>
              <option value="UA">Ukraine</option>
              <option value="AE">United Arab Emirates</option>
              <option value="GB">United Kingdom</option>
              <option value="US">United States</option>
              <option value="VN">Vietnam</option>
              <option value="ZW">Zimbabwe</option>
            </select>

            <div class="step-actions">
              <button type="button" class="btn btn-secondary" id="back-to-step1">Previous</button>
              <button type="button" class="btn btn-primary" onclick="saveCampaign()">Save Changes</button>
            </div>
          </div>

          <div class="form-group" style="margin-top:16px;">
            <label>Campaign Start Date</label>
            <input type="date" name="startdate" id="startdate" readonly>
          </div>
          <div class="form-group">
            <label>Campaign End Date</label>
            <input type="date" name="endate" id="endate" min="">
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<div id="status-notification" class="status-notification-container">
    <div class="status-notification-icon" id="status-icon"></div>
    <div class="status-notification-text" id="status-text"></div>
</div>

<script>window.saveCampaign = function() {
    const formData = new FormData(document.getElementById('campaignForm'));
    fetch('save_campaign.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(result => {
        // Show the new custom popup instead of the alert()
        const alertElement = document.getElementById('custom-alert');
        const alertMessage = document.getElementById('custom-alert-message');

        alertMessage.textContent = result;
        alertElement.classList.add('show');

        // Hide the popup automatically after 3 seconds
        setTimeout(() => {
            alertElement.classList.remove('show');
        }, 3000);

        closeCampaignDetails();
        location.reload(); // Re-add this if you need to refresh the campaign list
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while saving the campaign.');
    });
};</script>


<script>
// Close modal
function closeCampaignDetails(){
  document.getElementById('campaignDetails').style.display = 'none';
}

// Step navigation
const step1 = document.getElementById('step1');
const step2 = document.getElementById('step2');
document.getElementById('to-step2').addEventListener('click', () => {
  // 1. Validate Website URL
  const website = document.getElementById('website').value.trim();
  const websiteError = document.getElementById('website-error');
  const websiteEmptyError = document.getElementById('website-empty-error');

  // Check if URL field is empty
  if (website === '') {
      websiteError.style.display = 'none'; // Hide the invalid format error
      websiteEmptyError.style.display = 'block';
      return;
  } else {
      websiteEmptyError.style.display = 'none';
  }

  // Check if URL is in a valid format
  if (!/^https?:\/\/.+/i.test(website)) {
      websiteError.style.display = 'block';
      return;
  } else {
      websiteError.style.display = 'none';
  }

  // 2. Validate Platform Links
  const platformInput = document.getElementById('Platform');
  const platlinksTextarea = document.getElementById('platlinksjason');
  const platlinksError = document.getElementById('platform-links-error');

  // Check if the platform is not 'Direct' and the textarea is empty
  if (platformInput.value !== 'Direct' && platlinksTextarea.value.trim() === '') {
      platlinksError.style.display = 'block';
      return; // Stop the function and don't proceed to the next step
  } else {
      platlinksError.style.display = 'none';
  }

  // If all validations pass, proceed to the next step
  step1.classList.remove('active');
  step2.classList.add('active');
});

document.getElementById('back-to-step1').addEventListener('click', () => {
  step2.classList.remove('active');
  step1.classList.add('active');
});

// Bounce rate slider <-> number sync
const bounceRange = document.getElementById('bounce-rate-range');
const bounceNumber = document.getElementById('BounceRate');
const bounceDisplay = document.getElementById('bounce-rate-display');
function syncBounce(fromRange) {
  if (fromRange) {
    bounceNumber.value = bounceRange.value;
  } else {
    let v = parseInt(bounceNumber.value || 0, 10);
    if (v < 0) v = 0;
    if (v > 100) v = 100;
    bounceNumber.value = v;
    bounceRange.value = v;
  }
  bounceDisplay.textContent = bounceRange.value;
}
bounceRange.addEventListener('input', () => syncBounce(true));
bounceNumber.addEventListener('input', () => syncBounce(false));
syncBounce(true);

// Date constraints
const todayStr = new Date().toISOString().split('T')[0];
document.getElementById("startdate").value = todayStr;
document.getElementById("endate").setAttribute("min", todayStr);

// Consolidated JavaScript to handle campaign loading and form state
(function(){
  const list = document.getElementById('campaignList');
  const details = document.getElementById('campaignDetails');
  const form = document.getElementById('campaignForm');

  // Caching these elements to prevent repeated lookups
  const platlinksContainer = document.getElementById('platform-links-container');
  const platlinksTextarea = document.getElementById('platlinksjason');
  const platlinksLabel = document.getElementById('platform-links-label');
  const platlinksDescription = document.getElementById('platform-description');
  const platformTabs = document.querySelectorAll('.platform-tab');
  const platformInput = document.getElementById('Platform');
  const deviceTabs = document.querySelectorAll('.device-tab');
  const deviceInput = document.getElementById('device');
  const devicesField = document.getElementById('devices');

  const descriptions = {
      Organic: "Organic traffic: free visits from search engines.",
      Referral: "Referral traffic: visitors coming from other websites.",
      Social: "Social traffic: visits from social media platforms.",
      Direct: "Direct traffic: people entering your website directly."
  };
  
  // Platform tabs behavior
  platformTabs.forEach(btn => {
      btn.addEventListener('click', () => {
          platformTabs.forEach(b => b.classList.remove('active'));
          btn.classList.add('active');
          const val = btn.dataset.value;
          platformInput.value = val;
          
          // Update labels and visibility based on user click
          platlinksDescription.textContent = descriptions[val];
          platlinksContainer.style.display = (val === 'Direct') ? 'none' : 'block';
          
          // New logic for label and placeholder
          if (val === 'Organic') {
            platlinksLabel.innerHTML = 'Enter Your Keywords (one per line): ' +
              '<span class="info-icon" tabindex="0">ℹ️' +
              '<span class="tooltip">All Major Search Engines Supported Ex-Google,Yahoo,Bing</span>' +
              '</span>';
            platlinksTextarea.placeholder = 'Enter one entry per line';
          } else if (val === 'Referral') {
            platlinksLabel.innerHTML = 'Referral links (one per line): ' +
              '<span class="info-icon" tabindex="0">ℹ️' +
              '<span class="tooltip">Enter one referral link per line<br> Ex-https://yourdomain.com</span>' +
              '</span>';
            platlinksTextarea.placeholder = 'Enter referral links one per line ';
          } else if (val === 'Social') {
            platlinksLabel.innerHTML = 'Social links (one per line): ' +
              '<span class="info-icon" tabindex="0">ℹ️' +
              '<span class="tooltip">Enter one social link per line <br> Ex-https://yourdomain.com</span>' +
              '</span>';
            platlinksTextarea.placeholder = 'Enter social links one per line ';
          } else { // Direct
            platlinksLabel.textContent = 'No extra input required for Direct.';
            platlinksTextarea.placeholder = '';
          }
      });
  });

  // Device tabs behavior
  deviceTabs.forEach(tab => {
      tab.addEventListener('click', () => {
          deviceTabs.forEach(t => t.classList.remove('active'));
          tab.classList.add('active');
          const dv = tab.getAttribute('data-device');
          deviceInput.value = dv;
          devicesField.value = dv;
      });
  });

  if (!list) return;

  list.addEventListener('click', function(e){
    const card = e.target.closest('.campaign-card');
    if (!card) return;

    const campid = card.dataset.campid;
    fetch('get_campaign.php?campid=' + encodeURIComponent(campid))
      .then(res => res.json())
      .then(data => {
        if (data.error) { alert(data.error); return; }

        details.style.display = 'block';

        const pick = (...keys) => {
          for (const k of keys) if (data && data[k] !== undefined && data[k] !== null) return data[k];
          return '';
        };

        // IDs
        form.campid.value = pick('campid','id');
        document.getElementById('actionid').value = pick('actionid','action_id');

        // Step 1
        document.getElementById('campaign_name').value = pick('campaign_name','Name','CampaignName');
        document.getElementById('website').value = pick('website','Website','site');
        document.getElementById('Productname').value = pick('Productname','productname','product','Product');
        document.getElementById('language').value = pick('language','Language') || 'English';

        // Platform + tabs
        const platformVal = pick('Platform','platform') || 'Direct';
        platformInput.value = platformVal;
        platformTabs.forEach(b => {
          if (b.dataset.value === platformVal) b.classList.add('active'); else b.classList.remove('active');
        });
        
        const platlinksVal = pick('platlinksjason','platlinksjson','platlinks','PlatformLinks') || '';
        platlinksTextarea.value = platlinksVal;
        
        // Update labels and visibility based on the retrieved value
        platlinksDescription.textContent = descriptions[platformVal];
        platlinksContainer.style.display = (platformVal === 'Direct') ? 'none' : 'block';
        
        // New logic for label and placeholder on load
        if (platformVal === 'Organic') {
            platlinksLabel.innerHTML = 'Enter Your Keywords (one per line): ' +
              '<span class="info-icon" tabindex="0">ℹ️' +
              '<span class="tooltip">All Major Search Engines Supported Ex-Google,Yahoo,Bing</span>' +
              '</span>';
            platlinksTextarea.placeholder = 'Enter one entry per line';
        } else if (platformVal === 'Referral') {
            platlinksLabel.innerHTML = 'Referral links (one per line): ' +
              '<span class="info-icon" tabindex="0">ℹ️' +
              '<span class="tooltip">Enter one referral link per line<br> Ex-https://yourdomain.com</span>' +
              '</span>';
            platlinksTextarea.placeholder = 'Enter referral links one per line ';
        } else if (platformVal === 'Social') {
            platlinksLabel.innerHTML = 'Social links (one per line): ' +
              '<span class="info-icon" tabindex="0">ℹ️' +
              '<span class="tooltip">Enter one social link per line <br> Ex-https://yourdomain.com</span>' +
              '</span>';
            platlinksTextarea.placeholder = 'Enter social links one per line ';
        } else { // Direct
            platlinksLabel.textContent = 'No extra input required for Direct.';
            platlinksTextarea.placeholder = '';
        }

        // Step 2
        document.getElementById('UniqueVisitors').value = pick('UniqueVisitors','unique_visitors','visitors') || 0;

        const br = pick('BounceRate','bounce_rate','Bounce Rate');
        if (br !== '') {
          bounceNumber.value = br;
          syncBounce(false);
        } else {
          bounceNumber.value = 50;
          syncBounce(false);
        }

        // Devices
        const dev = pick('device','devices','Device') || 'desktop';
        deviceInput.value = dev;
        devicesField.value = dev;
        deviceTabs.forEach(t => {
          if (t.dataset.device === dev) t.classList.add('active'); else t.classList.remove('active');
        });

        // Geo (if array or CSV)
        const geoSel = document.getElementById('geo');
        const geoVal = pick('geo','geotargeting','GeoTargeting');

        // First, deselect all options
        Array.from(geoSel.options).forEach(opt => { opt.selected = false; });
        
        // Split the string and select the corresponding options
        if (geoVal && typeof geoVal === 'string') {
          const selectedCountries = geoVal.split(',');
          selectedCountries.forEach(v => {
            const o = Array.from(geoSel.options).find(x => x.value === v.trim());
            if (o) o.selected = true;
          });
        }
        
        // If no countries are selected, or if the value is empty, select 'All-Country'
        if (!geoVal || geoVal.trim() === '' || Array.from(geoSel.options).every(opt => !opt.selected)) {
          const all = Array.from(geoSel.options).find(x => x.value === 'ALLcountry');
          if (all) all.selected = true;
        }

        // Dates
        document.getElementById('startdate').value = pick('startdate') || todayStr;
        const endate = pick('endate') || '';
        document.getElementById('endate').value = endate;

        // Start at step 1 always on open
        step2.classList.remove('active');
        step1.classList.add('active');

        // Scroll modal to top
        details.querySelector('.modal-content').scrollTop = 0;
      })
      .catch(err => {
        alert('Failed to load campaign: ' + err.message);
      });
  });
})();

// Save
// Save
function saveCampaign(){
    const form = document.getElementById('campaignForm');
    const formData = new FormData(form);

    const alertContainer = document.getElementById('status-notification');
    const alertIcon = document.getElementById('status-icon');
    const alertText = document.getElementById('status-text');

    if (!formData.get('campid')) {
        alertText.textContent = 'Missing campaign IDs';
        alertIcon.className = 'status-notification-icon error';
        alertContainer.style.backgroundColor = '#E53935';
        alertContainer.classList.add('show');
        setTimeout(() => alertContainer.classList.remove('show'), 3000);
        return;
    }

    // 1. Show a very fast "Saving..." message
    alertIcon.className = 'status-notification-icon spinner';
    alertText.textContent = 'Saving...';
    alertContainer.style.backgroundColor = '#333';
    alertContainer.classList.add('show');

    fetch('save_campaign.php', {
        method: 'POST',
        body: formData
    })
    .then(res => res.text())
    .then(msg => {
        // 2. On success, show the new message and icon
        alertIcon.className = 'status-notification-icon success';
        alertText.textContent = 'Campaign Successfully Saved! ✅';
        alertContainer.style.backgroundColor = '#4CAF50'; // Green
        
        // Hide the popup very quickly after 1.5 seconds
        setTimeout(() => {
            alertContainer.classList.remove('show');
            closeCampaignDetails();
            location.reload();
        }, 1500); 
    })
    .catch(error => {
        // 3. On error, show an error message
        console.error('Error:', error);
        alertIcon.className = 'status-notification-icon error';
        alertText.textContent = 'An error occurred while saving.';
        alertContainer.style.backgroundColor = '#E53935'; // Red
        setTimeout(() => alertContainer.classList.remove('show'), 3000);
    });
}
</script>