<?php
// Start the session at the very beginning to access session variables.
session_start();

// Security check: Verify that the user is logged in before proceeding.
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Check if the form was submitted via the POST method.
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Check which website field actually has data
    $website_urls = '';
    if (!empty($_POST['website_urls'])) {
        $website_urls = trim($_POST['website_urls']);
    } elseif (!empty($_POST['website'])) {
        $website_urls = trim($_POST['website']);
    } else {
        // Log the error instead of dying directly.
        error_log("Error: Website URL field is required for user " . $_SESSION['user_id']);
        die("Error: Website URL field is required.");
    }

    // Validate other required fields
    $required_fields = ['campaign_name', 'keywords', 'package_id', 'billing_period', 'amount'];
    foreach ($required_fields as $field) {
        if (empty($_POST[$field])) {
            error_log("Error: Required field '$field' is missing for user " . $_SESSION['user_id']);
            die("Error: Required field '$field' is missing.");
        }
    }

    // Retrieve and sanitize data from the form.
    $campaign_name = trim($_POST['campaign_name']);
    $keywords = trim($_POST['keywords']);
    $package_id = trim($_POST['package_id']);
    $billing_period = trim($_POST['billing_period']);
    $amount = floatval($_POST['amount']);
    $discount_amount = isset($_POST['discount_amount']) ? floatval($_POST['discount_amount']) : 0;

    // Retrieve the user ID from the secure session variable.
    $userid = $_SESSION['user_id'];

    // Database connection details.
    // NOTE: In a production environment, these credentials should be stored
    // outside of the web root in a separate configuration file for security.
    $servername = "localhost";
    $username = "dropjwxg_ad_generator";
    $password = "ad_generator";
    $dbname = "dropjwxg_ad_generator";

    // Create a new database connection.
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Check for connection errors.
    if ($conn->connect_error) {
        // Log the error but don't expose sensitive info to the user.
        error_log("Connection failed: " . $conn->connect_error);
        die("Connection to the database failed. Please try again later.");
    }

    // Step 1: Insert data into the `campaign` table.
    $sql1 = "INSERT INTO `campaign` (`Name`, `userid`, `status`) VALUES (?, ?, 'active')";
    $stmt1 = $conn->prepare($sql1);

    if (!$stmt1) {
        error_log("Prepare failed (campaign): " . $conn->error);
        die("Database error. Please try again.");
    }

    $stmt1->bind_param("si", $campaign_name, $userid);

    if ($stmt1->execute()) {
        $campid = $stmt1->insert_id; // Get the ID of the new campaign.
        $stmt1->close();

        // Step 2: Insert data into the `seoactions` table.
        $sql2 = "INSERT INTO `seoactions` (`userid`, `campid`, `websiteurl`, `startdate`, `status`, `amount`, `disamount`, `packid`, `campaignduration`, `keywords`) VALUES (?, ?, ?, NOW(), 'pending', ?, ?, ?, ?, ?)";
        $stmt2 = $conn->prepare($sql2);

        if (!$stmt2) {
            error_log("Prepare failed (seoactions): " . $conn->error);
            die("Database error. Please try again.");
        }

        // CORRECTED bind_param: The original code had a mismatch between
        // the number of placeholders (8) and the number of type specifiers (7).
        // The correct type string should be "iisdsss" for 8 variables.
        // i - userid, i - campid, s - websiteurl, d - amount, d - disamount, s - packid, s - campaignduration, s - keywords
        $stmt2->bind_param("iisdsss", $userid, $campid, $website_urls, $amount, $discount_amount, $package_id, $billing_period, $keywords);

        if ($stmt2->execute()) {
            $stmt2->close();
            $conn->close();

            // Data insertion was successful. Now, display the data in an HTML view.
            // This is a common pattern to show a receipt-like page.
            ?>
            <!DOCTYPE html>
            <html lang="en">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Campaign Submitted</title>
                <style>
                    body { font-family: sans-serif; background-color: #f4f4f4; padding: 20px; }
                    .container { max-width: 600px; margin: auto; background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
                    h1 { color: #333; text-align: center; }
                    .data-summary p { background: #e9ecef; padding: 10px; border-radius: 5px; margin-bottom: 10px; }
                    strong { color: #007bff; }
                    .success-message { text-align: center; color: green; font-weight: bold; }
                </style>
            </head>
            <body>
                <div class="container">
                    <h1>🎉 Campaign Submitted Successfully!</h1>
                    <p class="success-message">Your campaign has been successfully saved to the database.</p>
                    <hr>
                    <h2>Campaign Details Summary</h2>
                    <div class="data-summary">
                        <p><strong>Campaign Name:</strong> <?= htmlspecialchars($campaign_name); ?></p>
                        <p><strong>Keywords:</strong> <?= htmlspecialchars($keywords); ?></p>
                        <p><strong>Website URLs:</strong><br><?= nl2br(htmlspecialchars($website_urls)); ?></p>
                        <p><strong>Package ID:</strong> <?= htmlspecialchars($package_id); ?></p>
                        <p><strong>Billing Period:</strong> <?= htmlspecialchars($billing_period); ?></p>
                        <p><strong>Amount Paid:</strong> $<?= number_format($amount, 2); ?></p>
                        <p><strong>Discount Applied:</strong> $<?= number_format($discount_amount, 2); ?></p>
                    </div>
                </div>
            </body>
            </html>
            <?php
            exit();

        } else {
            // Error handling for the second insertion.
            error_log("Error inserting into seoactions: " . $stmt2->error);
            die("Error inserting into seoactions: " . $stmt2->error);
        }

    } else {
        // Error handling for the first insertion.
        error_log("Error inserting into campaign: " . $stmt1->error);
        die("Error inserting into campaign: " . $stmt1->error);
    }

} else {
    // If the form was not submitted via POST, display an error message.
    echo "Invalid request method.";
}
?>
