<?php
require 'config.php';
include 'templates/header.php';

$message = "";

function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ips[0]);
    }
    return $_SERVER['REMOTE_ADDR'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $firstname = trim($_POST['firstname']);
    $lastname  = trim($_POST['lastname']);
    $phone     = trim($_POST['phone']);
    $country   = trim($_POST['country']);
    $email     = trim($_POST['email']);
    $password  = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $ip        = getUserIP();
    $created_at = date('Y-m-d H:i:s');
    $status     = 1;
    $balance    = 1;
    $package    = 'Free'; 

    if (!isset($_POST['terms'])) {
        $message = "<div class='error-msg'>Please agree to the Terms and Privacy Policy.</div>";
    } else {
        $stmt_check = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt_check->bind_param("s", $email);
        $stmt_check->execute();
        $stmt_check->store_result();

        if ($stmt_check->num_rows > 0) {
            $message = "<div class='error-msg'>Email already registered.</div>";
        } else {
            $stmt_check->close();
            $stmt = $conn->prepare("INSERT INTO users (firstname, lastname, phone, country, email, password, ip_address, created_at, status, balance, package) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssssssssis", $firstname, $lastname, $phone, $country, $email, $password, $ip, $created_at, $status, $balance, $package);

            if ($stmt->execute()) {
                echo "
                <div id='success-overlay'>
                    <div class='overlay-content'>
                      <div class='loader'></div>
                      <p>Registration successful! Redirecting to login page...</p>
                    </div>
                </div>
                <script>
                  setTimeout(() => {
                    window.location.href = 'login.php';
                  }, 3000);
                </script>";
                exit;
            } else {
                $message = "<div class='error-msg'>Error during registration. Please try again.</div>";
            }

            $stmt->close();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Create Account</title>

<style>
  * {
    box-sizing: border-box;
  }
  body, html {
    margin: 0;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #667eea, #764ba2);
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
  }

  .register-container {
    background: #fff;
    padding: 40px 35px;
    border-radius: 15px;
    max-width: 460px;
    width: 95%;
    box-shadow: 0 20px 50px rgba(0, 0, 0, 0.2);
  }

  h2 {
    text-align: center;
    margin-bottom: 8px;
    color: #333;
    font-weight: 700;
    font-size: 28px;
  }

  p.subtitle {
    text-align: center;
    color: #666;
    margin-bottom: 30px;
    font-size: 15px;
  }

  .message {
    margin-bottom: 20px;
    padding: 12px 18px;
    border-radius: 8px;
    font-size: 14px;
  }
  .error-msg {
    background: #ffe6e6;
    color: #b00020;
    border: 1px solid #b00020;
  }

  form {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 18px 25px;
  }

  .form-group {
    display: flex;
    flex-direction: column;
    width: 100%;
  }

  .form-group input,
  .form-group select {
    width: 100%;
    background: #fff;
  }

  label {
    font-weight: 600;
    margin-bottom: 6px;
    color: #444;
  }

  input[type="text"],
  input[type="email"],
  input[type="password"],
  input[type="tel"],
  select {
    padding: 12px 14px;
    border-radius: 8px;
    border: 1.8px solid #ccc;
    font-size: 15px;
    transition: border-color 0.3s ease;
  }

  input:focus,
  select:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 5px rgba(102, 126, 234, 0.6);
  }

  .terms {
    grid-column: 1 / -1;
    display: flex;
    align-items: center;
    gap: 10px;
    font-size: 14px;
    color: #555;
  }
  .terms input[type="checkbox"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
  }
  .terms a {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
  }

  button.register-btn {
    grid-column: 1 / -1;
    padding: 15px;
    background: #667eea;
    border: none;
    color: white;
    font-weight: 700;
    font-size: 17px;
    border-radius: 10px;
    cursor: pointer;
    transition: background-color 0.3s ease;
  }
  button.register-btn:hover {
    background: #5469d4;
  }

  @media (max-width: 600px) {
    form {
      grid-template-columns: 1fr;
    }
  }

  /* Success overlay styling */
  #success-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.6);
    z-index: 9999;
    display: flex;
    justify-content: center;
    align-items: center;
  }

  .overlay-content {
    background: white;
    padding: 30px 40px;
    border-radius: 12px;
    text-align: center;
    box-shadow: 0 10px 40px rgba(0,0,0,0.3);
    color: #333;
    font-size: 16px;
  }

  .loader {
    border: 5px solid #f3f3f3;
    border-top: 5px solid #667eea;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
    margin: 0 auto 15px;
  }

  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }
</style>
</head>
<body>

<div class="register-container">
  <h2>Create an Account</h2>
  <p class="subtitle">Start your free trial</p>

  <?php if ($message): ?>
    <div class="message error-msg"><?= $message ?></div>
  <?php endif; ?>

  <form method="POST" novalidate>
    <div class="form-group">
      <label for="firstname">First Name</label>
      <input id="firstname" type="text" name="firstname" required />
    </div>
    <div class="form-group">
      <label for="lastname">Last Name</label>
      <input id="lastname" type="text" name="lastname" required />
    </div>

    <div class="form-group">
      <label for="phone">Phone Number</label>
      <input id="phone" type="tel" name="phone" placeholder="+94xxxxxxxxx" required />
    </div>
    <div class="form-group">
      <label for="country">Country</label>
      <select id="country" name="country" required>
        <option value="">Loading countries...</option>
      </select>
    </div>

    <div class="form-group">
      <label for="email">Email Address</label>
      <input id="email" type="email" name="email" required />
    </div>
    <div class="form-group">
      <label for="password">Password</label>
      <input id="password" type="password" name="password" required />
    </div>

    <label class="terms">
      <input type="checkbox" name="terms" required checked />
      I agree to the <a href="#" target="_blank">Terms of Service</a> and <a href="#" target="_blank">Privacy Policy</a>.
    </label>

    <button type="submit" class="register-btn">Create Account</button>
  </form>
</div>

<script>
// Load country list
const countries = [
  "Afghanistan", "Albania", "Algeria", "Andorra", "Angola",
  "Argentina", "Armenia", "Australia", "Austria", "Azerbaijan",
  "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus",
  "Belgium", "Belize", "Benin", "Bhutan", "Bolivia",
  "Bosnia and Herzegovina", "Botswana", "Brazil", "Brunei", "Bulgaria",
  "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada",
  "Cape Verde", "Central African Republic", "Chad", "Chile", "China",
  "Colombia", "Comoros", "Congo", "Costa Rica", "Croatia",
  "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti",
  "Dominica", "Dominican Republic", "Ecuador", "Egypt", "El Salvador",
  "Equatorial Guinea", "Eritrea", "Estonia", "Eswatini", "Ethiopia",
  "Fiji", "Finland", "France", "Gabon", "Gambia",
  "Georgia", "Germany", "Ghana", "Greece", "Grenada",
  "Guatemala", "Guinea", "Guinea-Bissau", "Guyana", "Haiti",
  "Honduras", "Hungary", "Iceland", "India", "Indonesia",
  "Iran", "Iraq", "Ireland", "Israel", "Italy",
  "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya",
  "Kiribati", "Kuwait", "Kyrgyzstan", "Laos", "Latvia",
  "Lebanon", "Lesotho", "Liberia", "Libya", "Liechtenstein",
  "Lithuania", "Luxembourg", "Madagascar", "Malawi", "Malaysia",
  "Maldives", "Mali", "Malta", "Marshall Islands", "Mauritania",
  "Mauritius", "Mexico", "Micronesia", "Moldova", "Monaco",
  "Mongolia", "Montenegro", "Morocco", "Mozambique", "Myanmar",
  "Namibia", "Nauru", "Nepal", "Netherlands", "New Zealand",
  "Nicaragua", "Niger", "Nigeria", "North Korea", "North Macedonia",
  "Norway", "Oman", "Pakistan", "Palau", "Panama",
  "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Poland",
  "Portugal", "Qatar", "Romania", "Russia", "Rwanda",
  "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent and the Grenadines",
  "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Senegal",
  "Serbia", "Seychelles", "Sierra Leone", "Singapore", "Slovakia",
  "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Korea",
  "South Sudan", "Spain", "Sri Lanka", "Sudan", "Suriname",
  "Sweden", "Switzerland", "Syria", "Taiwan", "Tajikistan",
  "Tanzania", "Thailand", "Togo", "Tonga", "Trinidad and Tobago",
  "Tunisia", "Turkey", "Turkmenistan", "Tuvalu", "Uganda",
  "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "Uruguay",
  "Uzbekistan", "Vanuatu", "Vatican City", "Venezuela", "Vietnam",
  "Yemen", "Zambia", "Zimbabwe"
];
const countrySelect = document.getElementById('country');
countrySelect.innerHTML = countries.map(c => `<option value="${c}">${c}</option>`).join('');

// Auto-select by IP
fetch('https://ipapi.co/json/')
  .then(res => res.json())
  .then(data => {
    const countryName = data.country_name;
    for (let i = 0; i < countrySelect.options.length; i++) {
      if (countrySelect.options[i].value === countryName) {
        countrySelect.selectedIndex = i;
        break;
      }
    }
  });
</script>

</body>
</html>
