<?php
session_start();
error_log(print_r($_POST, true));
header('Content-Type: text/plain');

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    echo "Error: Not logged in.";
    exit;
}

$userid = (int)$_SESSION['user_id'];
$campid = (int)($_POST['campid'] ?? 0);

if ($campid <= 0) {
    echo "Error: Missing campaign ID.";
    exit;
}

// DB connection
$conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");
if ($conn->connect_error) {
    die("Error: Connection failed: " . $conn->connect_error);
}
$conn->set_charset('utf8mb4');

// Collect & sanitize inputs
$campaign_name   = $_POST['campaign_name']    ?? '';
$website         = $_POST['website']          ?? '';
$productname     = $_POST['Productname']      ?? '';
$language        = $_POST['language']         ?? '';
$platform        = $_POST['Platform']         ?? '';
$unique_visitors = (int)($_POST['UniqueVisitors'] ?? 0);
$bounce_rate     = (int)($_POST['BounceRate'] ?? 0);
$geo             = isset($_POST['geo']) ? implode(',', $_POST['geo']) : '';
$devices         = $_POST['devices']          ?? '';
$platlinksjason  = $_POST['platlinksjason']   ?? '';
$endate          = $_POST['endate']           ?? null;

// === STEP 1: Update the 'campaign' table ===
$sql_campaign = "UPDATE campaign SET Name = ? WHERE campid = ? AND userid = ?";
$stmt_campaign = $conn->prepare($sql_campaign);
if (!$stmt_campaign) {
    echo "Error: Campaign update prepare failed: " . $conn->error;
    $conn->close();
    exit;
}
$stmt_campaign->bind_param("sii", $campaign_name, $campid, $userid);
$stmt_campaign->execute();
$stmt_campaign->close();

// === STEP 2: Update the 'actions' table ===
$sql_actions = "UPDATE actions SET 
    website = ?,
    Productname = ?,
    language = ?,
    Platform = ?,
    UniqueVisitors = ?,
    `Bounce Rate` = ?,
    geo = ?,
    devices = ?,
    platlinks = ?,
    endate = ?
WHERE campid = ? AND userid = ? AND status = 1";

$stmt_actions = $conn->prepare($sql_actions);
if (!$stmt_actions) {
    echo "Error: Actions update prepare failed: " . $conn->error;
    $conn->close();
    exit;
}

// Corrected bind_param string: ssss i i s s s s i i
$stmt_actions->bind_param(
    "ssssiissisii",
    $website,
    $productname,
    $language,
    $platform,
    $unique_visitors,
    $bounce_rate,
    $geo,
    $devices,
    $platlinksjason,
    $endate,
    $campid,
    $userid
);

// Log the variables being bound for the actions table update
error_log("--- ACTIONS UPDATE VARIABLES ---");
error_log("Website: " . $website);
error_log("Product Name: " . $productname);
error_log("Language: " . $language);
error_log("Platform: " . $platform);
error_log("Unique Visitors: " . $unique_visitors);
error_log("Bounce Rate: " . $bounce_rate);
error_log("Geo: " . $geo);
error_log("Devices: " . $devices);
error_log("Platlinks JSON: " . $platlinksjason);
error_log("End Date: " . $endate);
error_log("Campaign ID: " . $campid);
error_log("User ID: " . $userid);
error_log("--------------------------------");
if ($stmt_actions->execute()) {
   // echo "Campaign updated successfully!";
} else {
    echo "Error: Update failed: " . $stmt_actions->error;
}

$stmt_actions->close();
$conn->close();
?>