<?php
session_start();

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    file_put_contents("log.txt", "POST: " . json_encode($_POST) . "\n", FILE_APPEND);

    if (!isset($_SESSION['user_id'])) {
        http_response_code(403);
        echo "User not logged in";
        exit;
    }

   $userid = $_SESSION['user_id'];
    $campaign_name = trim($_POST['campaign_name'] ?? '');
    $website = trim($_POST['website'] ?? '');

    // Validate website URL
    if (!filter_var($website, FILTER_VALIDATE_URL)) {
        http_response_code(400);
        echo "Invalid website URL";
        exit;
    }

    if (!empty($campaign_name) && !empty($website)) {
        $conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");
        if ($conn->connect_error) {
            http_response_code(500);
            echo "DB connection failed";
            exit;
        }

        // ✅ Insert into Competitor table
       $stmt1 = $conn->prepare("INSERT INTO Competitor (Name, userid, status, website) VALUES (?, ?, 1, ?)");

        if ($stmt1) {
            $stmt1->bind_param("sis", $campaign_name, $userid, $website);

            $stmt1->execute();
            $campid = $conn->insert_id;
            $stmt1->close();

            // ✅ Parse domain from website
            $parsedUrl = parse_url($website);
            $domain = $parsedUrl['host'] ?? '';
            if (empty($domain)) {
                echo "Could not extract domain from URL";
                exit;
            }

            // ✅ New API Call
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => "https://google-ads-library.p.rapidapi.com/search?domain=" . $domain . "&country_code=US&format=ALL&limit=40",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "x-rapidapi-host: google-ads-library.p.rapidapi.com",
                    "x-rapidapi-key: b2c3068295msh01cbe5f76a46a69p1b3c47jsna4af4654b449"
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            // ✅ Log and insert response
            $logFile = '/home/dropjwxg/public_html/googleads/api_log.txt';
            $log = "=== API Request Log ===\n";
            $log .= "Time: " . date("Y-m-d H:i:s") . "\n";
            $log .= "User ID: $userid\n";
            $log .= "Campaign ID: $campid\n";
            $log .= "Domain: $domain\n";
            $log .= "Response:\n" . ($err ? "Error: $err" : $response) . "\n";
            $log .= "========================\n\n";
            file_put_contents($logFile, $log, FILE_APPEND);

            if (!$err && $response) {
                $stmt2 = $conn->prepare("INSERT INTO apidata (userid, campid, responset, status) VALUES (?, ?, ?, 1)");
                if ($stmt2) {
                    $stmt2->bind_param("iis", $userid, $campid, $response);
                    $stmt2->execute();
                    $stmt2->close();
                } else {
                    file_put_contents("log.txt", "apidata insert error: " . $conn->error . "\n", FILE_APPEND);
                }
            }

            $conn->close();

            header("Location: competitor_step2_data.php");
            exit;

        } else {
            echo "Prepare Competitor insert failed: " . $conn->error;
            $conn->close();
        }

    } else {
        http_response_code(400);
        echo "Missing required fields";
    }
} else {
    http_response_code(405);
    echo "Method Not Allowed";
}