<?php
session_start();

include 'templates/headerother.php';
// Database connection
$conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get POST values safely
$campaignName   = $_POST['campaign_name'] ?? 'Test Campaign';
$website        = $_POST['website'] ?? '';
$product        = $_POST['product'] ?? '';
$language       = $_POST['language'] ?? 'English';
$platform       = $_POST['platform'] ?? 'Organic';
$platformLinks  = $_POST['platlinks'] ?? '';

$uniqueVisitors = $_POST['unique_visitors'] ?? 0;
$bounceRate     = $_POST['bounce_rate'] ?? 50;
$device         = $_POST['device'] ?? 'desktop';
$geoTargeting   = $_POST['geo_targeting'] ?? ['All-Country'];
$userid         = $_POST['user_id'] ?? 0;
$campid         = $_POST['campid'] ?? 0;
$actionid       = $_POST['actionid'] ?? 0;

$startdate = !empty($_POST['start_date']) ? $_POST['start_date'] : '0000-00-00';
$endate    = !empty($_POST['end_date'])   ? $_POST['end_date']   : '0000-00-00';

$status = 1;
$packid = 1;

// Sanitize strings for safe HTML output
function safeOutput($str) {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

// For array fields like geo_targeting
if (!is_array($geoTargeting)) $geoTargeting = [$geoTargeting];
$geoTargetingStr  = implode(', ', array_map('safeOutput', $geoTargeting));
$geoTargetingJson = json_encode($geoTargeting);

// JSON version of device
$deviceJson = json_encode([$device]);

/* --- Database logic (insert/update) --- */

// Step 1: Ensure campaign exists
if (empty($campid) || $campid == 0) {
    $stmt = $conn->prepare("INSERT INTO campaign (Name, userid, status) VALUES (?, ?, 1)");
    $stmt->bind_param("si", $campaignName, $userid);
    $stmt->execute();
    if ($stmt->error) die("MySQL Error (insert campaign): " . $stmt->error);
    $campid = $stmt->insert_id;
    $stmt->close();
} else {
    $stmt = $conn->prepare("UPDATE campaign SET Name=? WHERE campid=? AND userid=?");
    $stmt->bind_param("sii", $campaignName, $campid, $userid);
    $stmt->execute();
    if ($stmt->error) die("MySQL Error (update campaign): " . $stmt->error);
    $stmt->close();
}

// Step 2: Ensure action exists and update/insert
if ($actionid) {
    // Update existing action
    $stmt = $conn->prepare("
        UPDATE actions SET
            website=?, Productname=?, language=?, Platform=?,
            platlinks=?, platlinksjason=?,
            UniqueVisitors=?, `Bounce Rate`=?,
            devices=?, devicesjosn=?, geo=?, geojason=?,
            startdate=?, endate=?
        WHERE id=? AND userid=? AND campid=?
    ");
    $platlinksjson = json_encode(array_filter(array_map('trim', explode("\n", $platformLinks))));
    $stmt->bind_param(
        "ssssssiiissssiii",
        $website,
        $product,
        $language,
        $platform,
        $platformLinks,
        $platlinksjson,
        $uniqueVisitors,
        $bounceRate,
        $device,
        $deviceJson,
        $geoTargetingStr,
        $geoTargetingJson,
        $startdate,
        $endate,
        $actionid,
        $userid,
        $campid
    );
    $stmt->execute();
    if ($stmt->error) die("MySQL Error (update action): " . $stmt->error);
    $stmt->close();
} else {
    // Insert default action record
    $stmt = $conn->prepare("
        INSERT INTO actions
    (userid, campid, website, Productname, language, Platform, platlinks, platlinksjason,
    UniqueVisitors, `Bounce Rate`, devices, devicesjosn, status, packid, geo, geojason, startdate, endate)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, 1, ?, ?, ?, ?)
    ");
    $platlinksjson = json_encode(array_filter(array_map('trim', explode("\n", $platformLinks))));
    $stmt->bind_param(
        "iissssssiiisssss",
        $userid,
        $campid,
        $website,
        $product,
        $language,
        $platform,
        $platformLinks,
        $platlinksjson,
        $uniqueVisitors,
        $bounceRate,
        $device,
        $deviceJson,
        $geoTargetingStr,
        $geoTargetingJson,
        $startdate,
        $endate
    );
    $stmt->execute();
    if ($stmt->error) die("MySQL Error (insert action): " . $stmt->error);
    $actionid = $stmt->insert_id;
    $stmt->close();
}

/* --- End Database Logic --- */

// ---- PREVIEW SECTION ----
?>
<!DOCTYPE html>
<!DOCTYPE html>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Campaign Success</title>
<style>
    body {
        font-family: 'Arial', sans-serif;
        text-align: center;
        background: #f4f6f9;
        margin: 0;
        padding: 0;
        overflow: hidden;
    }

    h1 {
        font-size: 2.5rem;
        color: #fff;
        margin-top: 40px;
        text-shadow: 2px 2px 6px #333;
        animation: flash 1.2s infinite alternate;
        z-index: 10;
        position: relative;
    }

    @keyframes flash {
        50% { color: #ffcc00; }
    }

    .sub-text {
        font-size: 1.3rem;
        margin: 15px 0;
        color: #222;
        z-index: 10;
        position: relative;
    }

    .brand-logos {
        margin: 30px auto;
        display: flex;
        justify-content: center;
        gap: 30px;
        flex-wrap: wrap;
        z-index: 10;
        position: relative;
    }
    .brand-logos img {
        width: 80px;
        height: auto;
        filter: drop-shadow(2px 2px 4px rgba(0,0,0,0.3));
        animation: float 3s ease-in-out infinite;
    }

    @keyframes float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-10px); }
    }

    .countdown {
        font-size: 1.5rem;
        font-weight: bold;
        margin: 20px 0;
        color: #b30000;
        z-index: 10;
        position: relative;
    }

    .button {
        display: inline-block;
        padding: 12px 24px;
        background: #b30000;
        color: #fff;
        border-radius: 30px;
        text-decoration: none;
        font-size: 1.2rem;
        transition: background 0.3s ease;
        z-index: 10;
        position: relative;
    }
    .button:hover { background: #ff0000; }

    /* Confetti effect */
    .confetti {
        position: absolute;
        width: 10px;
        height: 10px;
        background: red;
        top: -10px;
        animation: fall linear forwards;
        z-index: 5;
    }
    @keyframes fall {
        to { transform: translateY(100vh) rotate(720deg); }
    }

    /* Floating Ads Background */
    .ad {
        position: absolute;
        padding: 8px 12px;
        background: #fff;
        border-radius: 8px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.2);
        font-size: 12px;
        color: #111;
        font-weight: bold;
        z-index: 1;
        pointer-events: none;
        opacity: 0.8;
    }
</style>
</head>
<body>

<br><br><br<br><br>><h1>🎉 Congrats! Your Campaign is Live! 🎉</h1>
<p class="sub-text">Boosting your sales on Websites, Etsy & Shopping Platforms 🚀</p>

<!-- <div class="brand-logos">
    <img src="https://upload.wikimedia.org/wikipedia/commons/2/2f/Google_2015_logo.svg" alt="Google">
    <img src="https://upload.wikimedia.org/wikipedia/commons/4/45/Etsy_logo.svg" alt="Etsy">
    <img src="https://cdn-icons-png.flaticon.com/512/891/891462.png" alt="Shopping Bag">
    <img src="https://cdn-icons-png.flaticon.com/512/888/888879.png" alt="Sponsor">
</div>-->

<p class="countdown">Redirecting to My Campaign in <span id="timer">10</span> seconds...</p>
<a href="mycampaign.php" class="button">🚀 Go to My Campaign Now</a>

<!-- Floating Ads Background -->
<script>
const adTexts = ["Google Ads", "Sponsored", "Etsy Promo", "Buy Now", "Top Seller", "Shop Now", "Ad Click", "Sponsored Product"];
const adCount = 15;

for(let i=0;i<adCount;i++){
    let ad = document.createElement("div");
    ad.classList.add("ad");
    ad.textContent = adTexts[Math.floor(Math.random()*adTexts.length)];
    ad.style.top = Math.random()*90 + "vh";
    ad.style.left = Math.random()*90 + "vw";
    ad.style.fontSize = (Math.random()*10 + 12) + "px";
    ad.style.opacity = Math.random()*0.6 + 0.4;
    document.body.appendChild(ad);

    let speedX = (Math.random()*2 + 0.5) * (Math.random()<0.5?-1:1);
    let speedY = (Math.random()*2 + 0.5) * (Math.random()<0.5?-1:1);

    function moveAd(){
        let rect = ad.getBoundingClientRect();
        let newX = rect.left + speedX;
        let newY = rect.top + speedY;

        if(newX < 0 || newX + rect.width > window.innerWidth) speedX *= -1;
        if(newY < 0 || newY + rect.height > window.innerHeight) speedY *= -1;

        ad.style.left = newX + "px";
        ad.style.top = newY + "px";
        requestAnimationFrame(moveAd);
    }
    moveAd();
}

// Countdown
let seconds = 100;
let timerEl = document.getElementById("timer");
let countdown = setInterval(() => {
    seconds--;
    timerEl.textContent = seconds;
    if(seconds <= 0){
        clearInterval(countdown);
        window.location.href = "mycampaign.php";
    }
}, 1000);

// Confetti generator
function createConfetti(){
    const confetti = document.createElement("div");
    confetti.classList.add("confetti");
    confetti.style.left = Math.random() * window.innerWidth + "px";
    confetti.style.background = `hsl(${Math.random()*360}, 100%, 50%)`;
    confetti.style.animationDuration = (Math.random()*3+2) + "s";
    document.body.appendChild(confetti);
    setTimeout(() => confetti.remove(), 5000);
}
setInterval(createConfetti, 200);
</script>

</body>
</html>


<?php include 'templates/footer.php'; ?>