<?php
// Get POST values safely with defaults if not set
$campaignName    = $_POST['campaign_name'] ?? '';
$website         = $_POST['website'] ?? '';
$product         = $_POST['product'] ?? '';
$language        = $_POST['language'] ?? '';
$platform        = $_POST['platform'] ?? '';
$platformLinks   = $_POST['platform_links'] ?? '';
$uniqueVisitors  = $_POST['unique_visitors'] ?? '';
$bounceRate      = $_POST['bounce_rate'] ?? '';
$device          = $_POST['device'] ?? '';
$geoTargeting    = $_POST['geo_targeting'] ?? [];
$campaignStatus  = $_POST['campaign_status'] ?? '';
$newcampaignName    = $_POST['newcampaign_name'] ?? '';

// Sanitize strings for safe HTML output
function safeOutput($str) {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

// For array fields like geo_targeting, convert to comma-separated string
$geoTargetingStr = is_array($geoTargeting) ? implode(', ', array_map('safeOutput', $geoTargeting)) : safeOutput($geoTargeting);

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Submitted Campaign Data</title>
<style>
  body { font-family: Arial, sans-serif; padding: 20px; }
  h1 { margin-bottom: 20px; }
  .field { margin-bottom: 10px; }
  .label { font-weight: bold; }
</style>
</head>
<body>

<h1>Submitted Campaign Data</h1>

<div class="field">
  <span class="label">Campaign Name:</span> <?= safeOutput($newcampaignName) ?>
</div>
<div class="field">
  <span class="label">Campaign Name:</span> <?= safeOutput($campaignName) ?>
</div>

<div class="field">
  <span class="label">Website URL:</span> <?= safeOutput($website) ?>
</div>

<div class="field">
  <span class="label">Product Name:</span> <?= safeOutput($product) ?>
</div>

<div class="field">
  <span class="label">Language:</span> <?= safeOutput($language) ?>
</div>

<div class="field">
  <span class="label">Platform:</span> <?= safeOutput($platform) ?>
</div>

<div class="field">
  <span class="label">Platform Links:</span> <pre><?= safeOutput($platformLinks) ?></pre>
</div>

<div class="field">
  <span class="label">Unique Visitors per Day:</span> <?= safeOutput($uniqueVisitors) ?>
</div>

<div class="field">
  <span class="label">Bounce Rate (%):</span> <?= safeOutput($bounceRate) ?>
</div>

<div class="field">
  <span class="label">Device:</span> <?= safeOutput($device) ?>
</div>

<div class="field">
  <span class="label">Geo Targeting:</span> <?= $geoTargetingStr ?>
</div>

<div class="field">
  <span class="label">Campaign Status:</span> <?= safeOutput($campaign_status) ?>
</div>

</body>
</html>
