<?php







session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'templates/header.php';

$isReturning = isset($_GET['return']) && $_GET['return'] == '1';

$website = 'https://dropsell.info';
$campaignName = 'Test Campaign';
$product = 'Test Product';
$selectedLanguage = 'English';
$selectedPlatform = 'Google Search';
$platformLinks = '';
$uniqueVisitors = '';
$bounceRate = 50;
$device = 'desktop';
$geoTargeting = [];
$campaignStatus = 'Run Campaign';
$currentPackage = 'Free Plan';

$conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");

// Check for database connection error
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch packages from the database
$packages = [];
$sql = "SELECT id, Name, Description, price FROM Package ORDER BY price ASC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $packages[] = $row;
    }
}

// Fetch last campaign data for returning users
if ($isReturning) {
    $userid = $_SESSION['user_id'];
    
    $sql = "SELECT 
                c.Name AS campaign_name,
                a.website,
                a.Productname,
                a.language,
                a.platform,
                a.platlinks,
                a.UniqueVisitors,
                a.BounceRate,
                a.device,
                a.geo,
                c.status AS campaign_status,
                c.current_package
            FROM actions a
            JOIN campaign c ON a.campid = c.campid
            WHERE a.userid = $userid
            ORDER BY a.id DESC LIMIT 1";

    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();

        $campaignName = $row['campaign_name'] ?? $campaignName;
        $website = $row['website'] ?? $website;
        $product = $row['Productname'] ?? $product;
        $selectedLanguage = $row['language'] ?? $selectedLanguage;
        $selectedPlatform = $row['platform'] ?? $selectedPlatform;
        $platformLinks = $row['platlinks'] ?? $platformLinks;
        $uniqueVisitors = $row['UniqueVisitors'] ?? $uniqueVisitors;
        $bounceRate = $row['BounceRate'] ?? $bounceRate;
        $device = $row['device'] ?? $device;
        $geoTargeting = !empty($row['geo']) ? explode(',', $row['geo']) : $geoTargeting;
        $campaignStatus = $row['campaign_status'] ?? $campaignStatus;
        $currentPackage = $row['current_package'] ?? $currentPackage;
    }
}

// Function to fetch reviews from the database
function getReviews($conn) {
    $reviews = [];
    $sql = "SELECT 
                r.comment,
                r.created_at,
                u.firstname,
                u.country
            FROM reviews r
            JOIN users u ON r.userid = u.id
            WHERE r.status = 1
            ORDER BY r.id DESC 
            LIMIT 10";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $reviews[] = $row;
        }
    }
    return $reviews;
}

$reviews = getReviews($conn);

// Function to format "time ago"
function timeAgo($datetime) {
    $timeAgo = time() - strtotime($datetime);
    if ($timeAgo < 60) {
        return $timeAgo . " seconds ago";
    } elseif ($timeAgo < 3600) {
        return floor($timeAgo / 60) . " minutes ago";
    } elseif ($timeAgo < 86400) {
        return floor($timeAgo / 3600) . " hours ago";
    } else {
        return floor($timeAgo / 86400) . " days ago";
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Campaign - Ad Generator</title>
    <style>
    
    
  .payment-logos {
  margin-top: 8px;
  display: flex;
  gap: 10px;
  flex-wrap: wrap;
  align-items: center;
}

.payment-logos img {
  width: 45px;
  height: auto;
}

.custom-dropdown {
  border: 1px solid #ccc;
  border-radius: 8px;
  width: 100%;
  max-width: 400px;
  background: white;
  cursor: pointer;
  position: relative;
  font-size: 15px;
}

.custom-dropdown .selected {
  padding: 10px;
}

.custom-dropdown .options {
  display: none;
  position: absolute;
  width: 100%;
  background: white;
  border: 1px solid #ddd;
  border-radius: 8px;
  max-height: 250px;
  overflow-y: auto;
  z-index: 1000;
}

.custom-dropdown .option {
  display: flex;
  align-items: center;
  padding: 8px;
  cursor: pointer;
}

.custom-dropdown .option:hover {
  background: #f1f1f1;
}

.custom-dropdown img {
  width: 28px;
  height: auto;
  margin-left: 6px;
}

    .coupon-btn {
  background: linear-gradient(135deg, #ff6a00, #ee0979);
  color: white;
  font-weight: bold;
  border: none;
  border-radius: 30px;
  padding: 10px 25px;
  cursor: pointer;
  font-size: 16px;
  transition: all 0.3s ease;
  box-shadow: 0 4px 10px rgba(0,0,0,0.2);
}

.coupon-btn:hover {
  background: linear-gradient(135deg, #ee0979, #ff6a00);
  transform: scale(1.05);
  box-shadow: 0 6px 14px rgba(0,0,0,0.25);
}

.coupon-btn:active {
  transform: scale(0.97);
  box-shadow: 0 3px 6px rgba(0,0,0,0.2);
}

    
    .validation-msg {
  display: none;
  margin-left: 8px;
  font-weight: bold;
  padding: 5px 10px;
  border-radius: 6px;
}

.validation-success {
  color: #155724;
  background-color: #d4edda;
  border: 1px solid #c3e6cb;
}

.validation-error {
  color: #721c24;
  background-color: #f8d7da;
  border: 1px solid #f5c6cb;
}

.validation-warning {
  color: #856404;
  background-color: #fff3cd;
  border: 1px solid #ffeeba;
}

    
   /* Step 4 Styles */
   /* Custom Alert Modal Styles */
.custom-alert-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.7);
    z-index: 10000;
    justify-content: center;
    align-items: center;
}

.custom-alert-modal {
    background-color: white;
    border-radius: 12px;
    padding: 30px;
    width: 400px;
    max-width: 90%;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    text-align: center;
    animation: modalFadeIn 0.3s ease;
}

@keyframes modalFadeIn {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.custom-alert-icon {
    font-size: 50px;
    margin-bottom: 20px;
}

.custom-alert-title {
    font-size: 24px;
    font-weight: bold;
    color: #e53935;
    margin-bottom: 15px;
}

.custom-alert-message {
    font-size: 16px;
    color: #333;
    margin-bottom: 25px;
    line-height: 1.5;
}

.custom-alert-button {
    background: linear-gradient(135deg, #3949ab, #1a237e);
    color: white;
    padding: 12px 30px;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    font-size: 16px;
    cursor: pointer;
    box-shadow: 0 4px 10px rgba(26, 35, 126, 0.3);
    transition: all 0.3s ease;
}

.custom-alert-button:hover {
    background: linear-gradient(135deg, #1a237e, #121858);
    box-shadow: 0 6px 15px rgba(18, 24, 88, 0.4);
}

#step4-heading {
    font-weight: 700;
    color: #1a237e;
    margin-bottom: 30px;
    font-size: 28px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    text-align: center;
}
   
.tab-container {
    display: flex;
    justify-content: center;
    margin-bottom: 20px;
    gap: 10px;
}

.tab-button {
    padding: 10px 15px;
    background-color: #c5cae9;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-weight: 600;
    transition: all 0.3s ease;
}

.tab-button.active {
    background-color: #3949ab;
    color: white;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}

.tab-button:hover:not(.active) {
    background-color: #9fa8da;
}

.coupon-box {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-top: 5px;
}

.validation-icon {
    font-size: 18px;
    display: none;
}

.validation-msg {
    font-size: 14px;
    color: #666;
    display: none;
}
    
    
        /* General Layout */
        .main-wrapper {
            display: flex;
            min-height: 100vh;
        }
        .sidebar {
            width: 260px;
            background-color: #1e1e2f;
            padding-top: 40px;
            padding-bottom: 40px;
            color: #ddd;
            box-shadow: 2px 0 12px rgba(0,0,0,0.2);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            user-select: none;
            display: flex;
            flex-direction: column;
            flex-shrink: 0;
        }
        .sidebar-menu {
            list-style: none;
            padding: 0;
            margin: 0;
            width: 100%;
        }
        .sidebar-menu li {
            margin: 12px 0;
        }
        .sidebar-link {
            display: flex;
            align-items: center;
            text-decoration: none;
            color: #bbb;
            font-size: 18px;
            padding: 12px 24px;
            border-radius: 8px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }
        .sidebar-link .icon {
            margin-right: 14px;
            font-size: 20px;
            width: 32px;
            height: 32px;
            background: #fff;
            color: #4f63d3;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }
        .sidebar-link:hover {
            background: #3a3f55;
            color: #fff;
            box-shadow: 0 4px 12px rgba(58, 63, 85, 0.6);
        }
        .sidebar-link.active {
            background: #4f63d3;
            color: #fff;
            box-shadow: 0 4px 20px rgba(79, 99, 211, 0.7);
            font-weight: 600;
        }
        .main-content {
            flex-grow: 1;
            padding: 40px 30px;
            background-color: #e8f0fe;
        }
        h1 {
            font-weight: 700;
            color: #1a237e;
            margin-bottom: 30px;
            font-size: 28px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        form {
            background-color: #ffffff;
            border-radius: 16px;
            padding: 40px 50px;
            box-shadow: 0 8px 30px rgba(26, 35, 126, 0.12);
            display: grid;
            grid-template-columns: 1fr;
            gap: 28px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .form-group {
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .form-group label {
            font-weight: 600;
            margin-bottom: 8px;
            color: #3949ab;
        }
        .form-group input,
        .form-group select,
        .form-group textarea {
            padding: 12px 15px;
            font-size: 16px;
            border: 1.8px solid #c5cae9;
            border-radius: 10px;
            background-color: #f5f7ff;
            color: #1a237e;
            box-shadow: inset 0 2px 5px rgba(60, 66, 201, 0.05);
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
            width: 100%;
            max-width: 600px;
        }
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            border-color: #3949ab;
            box-shadow: 0 0 8px rgba(57, 73, 171, 0.4);
            outline: none;
            background-color: #e8ecff;
        }
        .form-group input.error,
        .form-group textarea.error {
            border-color: #e53935;
            background-color: #ffebee;
            box-shadow: 0 0 6px 2px rgba(229, 57, 53, 0.6);
            color: #b71c1c;
        }
        .error-msg {
            color: #e53935;
            font-size: 14px;
            margin-top: 5px;
            display: none;
            font-weight: 600;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .button-group {
            display: flex;
            justify-content: center;
            gap: 14px;
            margin-top: 28px;
        }
        .btn-primary {
            background: linear-gradient(135deg, #3949ab, #1a237e);
            color: white;
            padding: 12px 28px;
            border: none;
            border-radius: 10px;
            font-weight: 700;
            font-size: 16px;
            cursor: pointer;
            box-shadow: 0 6px 20px rgba(26, 35, 126, 0.5);
            transition: background 0.3s ease;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #1a237e, #121858);
            box-shadow: 0 8px 25px rgba(18, 24, 88, 0.7);
        }
        .btn-secondary {
            background-color: #c5cae9;
            color: #3949ab;
            padding: 12px 28px;
            border: none;
            border-radius: 10px;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            box-shadow: none;
            transition: background-color 0.3s ease;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .btn-secondary:hover {
            background-color: #9fa8da;
            color: #1a237e;
        }
        .info-icon {
            font-style: normal;
            font-size: 16px;
            color: #e53935;
            cursor: pointer;
            position: relative;
            user-select: none;
            outline: none;
        }
        .info-icon .tooltip {
            visibility: hidden;
            width: max-content;
            max-width: 180px;
            background-color: #e53935;
            color: #fff;
            text-align: center;
            border-radius: 8px;
            padding: 8px 12px;
            position: absolute;
            z-index: 10;
            bottom: 125%;
            left: 50%;
            transform: translateX(-50%);
            opacity: 0;
            transition: opacity 0.3s ease;
            font-size: 14px;
            pointer-events: none;
        }
        .info-icon .tooltip::after {
            content: "";
            position: absolute;
            top: 100%;
            left: 50%;
            transform: translateX(-50%);
            border-width: 6px;
            border-style: solid;
            border-color: #3949ab transparent transparent transparent;
        }
        .info-icon:hover .tooltip,
        .info-icon:focus .tooltip {
            visibility: visible;
            opacity: 1;
            pointer-events: auto;
        }
        #loading-overlay {
            display: none;
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(26, 35, 126, 0.6);
            z-index: 2000;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            color: white;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 22px;
            font-weight: 700;
            text-align: center;
        }
        .loader {
            border: 8px solid #f3f3f3;
            border-top: 8px solid #3949ab;
            border-radius: 50%;
            width: 70px;
            height: 70px;
            animation: spin 1.3s linear infinite;
            margin-bottom: 15px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .progress-container {
            width: 80%;
            max-width: 400px;
            background-color: #f0f0f0;
            border-radius: 20px;
            height: 20px;
            margin: 20px 0;
            overflow: hidden;
        }
        #progress-bar {
            height: 100%;
            width: 0;
            background-color: #4CAF50;
            border-radius: 20px;
            transition: width 0.5s ease-in-out;
        }

        /* SEO Report Styles */
        .data-cards-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-top: 40px;
            justify-content: center;
        }
        .data-card {
            background-color: #fff;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
        }
        .progress-circle-container {
            position: relative;
            width: 120px;
            height: 120px;
            margin-bottom: 20px;
        }
        .progress-circle {
            position: relative;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background: conic-gradient(#eee 0%, #eee 100%);
        }
        .progress-circle::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 90%;
            height: 90%;
            background: #fff;
            border-radius: 50%;
            z-index: 1;
        }
        .progress-value {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 2;
            font-size: 2rem;
            font-weight: 700;
            color: #1a237e;
        }
        .data-card-title {
            font-size: 1.1rem;
            color: #6a6a6a;
            margin-top: 5px;
            font-weight: 600;
        }
        .data-card-value {
            font-size: 2rem;
            font-weight: 700;
            color: #1a237e;
            margin-bottom: 10px;
        }
        .low-rating {
            background: conic-gradient(#ff0000 var(--progress), #eee var(--progress));
        }
        .medium-rating {
            background: conic-gradient(#ffc107 var(--progress), #eee var(--progress));
        }
        .high-rating {
            background: conic-gradient(#4caf50 var(--progress), #eee var(--progress));
        }
        .indicator {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            position: absolute;
            top: 10px;
            right: 10px;
            border: 2px solid white;
        }
        .indicator.red { background-color: #f44336; }
        .indicator.orange { background-color: #ff9800; }
        .indicator.green { background-color: #4caf50; }
        .blinking-light {
            animation: blink 1.5s infinite;
        }
        @keyframes blink {
            0% { opacity: 1; }
            50% { opacity: 0.3; }
            100% { opacity: 1; }
        }
        .blinking-text {
            animation: blink 1.5s infinite;
            font-weight: bold;
            font-size: 0.9em;
            margin-top: 8px;
            text-transform: uppercase;
        }
        .blinking-text.red { color: #f44336; }
        .blinking-text.orange { color: #ff9800; }
        .blinking-text.green { color: #4caf50; }
        .data-card {
            animation: fadeIn 1s ease-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Package Selection Styles */
        .budget-container {
            background-color: #fff;
            border-radius: 16px;
            padding: 40px 50px;
            box-shadow: 0 8px 30px rgba(26, 35, 126, 0.12);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin-top: 40px;
        }
        .budget-container h2 {
            font-weight: 600;
            color: #3949ab;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .price-display {
            font-size: 2.5rem;
            font-weight: 700;
            color: #1a237e;
            text-align: center;
            margin-bottom: 30px;
            transition: color 0.3s ease;
        }
        .blinking-suggestion-text {
            text-align: center;
            font-weight: bold;
            font-size: 1em;
            color: #4CAF50;
            animation: blink 1.5s infinite;
        }
        .budget-slider {
            width: 100%;
            max-width: 600px;
            height: 10px;
            background: #c5cae9;
            border-radius: 5px;
            outline: none;
            -webkit-appearance: none;
            appearance: none;
            cursor: grab;
        }
        .budget-slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 25px;
            height: 25px;
            background: #3949ab;
            cursor: grab;
            border-radius: 50%;
            border: 3px solid #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
            transition: background 0.3s ease;
        }
        .budget-slider::-webkit-slider-thumb:active {
            cursor: grabbing;
        }
        .budget-slider::-webkit-slider-thumb:hover {
            background: #1a237e;
        }
        .campaign-details {
            background-color: #f5f7ff;
            border-radius: 12px;
            padding: 30px;
            margin-top: 30px;
            border: 1px dashed #c5cae9;
        }
        .campaign-details h3 {
            font-weight: 600;
            color: #1a237e;
            margin-bottom: 15px;
            font-size: 20px;
            text-align: center;
        }
        .campaign-details h4 {
            font-weight: 600;
            color: #3949ab;
            margin-bottom: 15px;
            font-size: 18px;
            text-align: center;
        }
        .campaign-details ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .campaign-details li {
            font-size: 16px;
            color: #3949ab;
            margin-bottom: 10px;
            padding-left: 20px;
            position: relative;
        }
        .campaign-details li::before {
            content: '↳';
            position: absolute;
            left: 0;
            color: #3949ab;
            font-weight: bold;
        }
        .campaign-details li.nested-item::before {
            color: #9fa8da;
        }
        .box-container {
            display: inline-flex;
            gap: 5px;
            margin-left: 5px;
        }
        .box-red {
            background-color: #e53935;
            color: white;
            padding: 2px 6px;
            border-radius: 4px;
            font-weight: bold;
        }
        .box-black {
            background-color: #000;
            color: white;
            padding: 2px 6px;
            border-radius: 4px;
            font-weight: bold;
        }
        .slider-wrapper {
            position: relative;
            max-width: 600px;
            margin: 0 auto;
        }
        .animated-hand-text-container {
            text-align: center;
            height: 25px;
            margin-bottom: 15px;
            font-weight: bold;
            color: #3949ab;
            position: relative;
            overflow: hidden;
            white-space: nowrap;
        }
        .animated-text {
            display: inline-block;
            animation: slide-text-animation 5s infinite ease-in-out;
            position: relative;
        }
        .hand-icon {
            display: inline-block;
            font-size: 1.5rem;
            position: absolute;
            top: -5px;
        }
        .hand-left {
            left: -30px;
            animation: move-left-hand 5s infinite ease-in-out;
        }
        .hand-right {
            right: -30px;
            animation: move-right-hand 5s infinite ease-in-out;
        }
        @keyframes move-left-hand {
            0%, 100% { transform: translateX(0); }
            50% { transform: translateX(450px); }
        }
        @keyframes move-right-hand {
            0%, 100% { transform: translateX(0); }
            50% { transform: translateX(-450px); }
        }

        /* Customer Reviews Styles */
        .reviews-container {
            position: relative;
            width: 100%;
            max-width: 850px;
            margin: 40px auto;
            overflow: hidden;
        }
        .review-carousel {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }
        .review-carousel::-webkit-scrollbar {
            display: none;
        }
        .review-card {
            flex: 0 0 auto;
            width: 250px;
            margin: 10px;
            padding: 20px;
            border-radius: 10px;
            background: #fff;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s;
        }
        .review-card:hover {
            transform: scale(1.05);
        }
        .profile-img {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            margin-bottom: 10px;
        }
        .username {
            font-weight: bold;
            font-size: 16px;
        }
        .country {
            font-size: 14px;
            color: #555;
        }
        .review-text {
            font-size: 14px;
            margin: 10px 0;
        }
        .star-rating {
            color: #FFD700;
            margin: 5px 0;
        }
        .carousel-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background-color: rgba(79, 99, 211, 0.7);
            color: white;
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            font-size: 20px;
            cursor: pointer;
            z-index: 10;
        }
        .carousel-btn.left {
            left: 10px;
        }
        .carousel-btn.right {
            right: 10px;
        }
        .carousel-btn:hover {
            background-color: rgba(79, 99, 211, 1);
        }
        @keyframes blink {
            50% { opacity: 0; }
        }
    </style>
</head>
<body>

<div class="main-wrapper">
    <div class="sidebar">
        <nav>
            <ul class="sidebar-menu">
                <li><a href="dashboard.php" class="sidebar-link"><span class="icon">🏠</span> Dashboard</a></li>
                <li><a href="create_campaign.php" class="sidebar-link active"><span class="icon">📈</span> Create Campaign</a></li>
                <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
                <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="main-content">
        <h1 id="form-heading">Step 1: Submit Your Website</h1>

        <form id="campaign-form">
            <div class="form-group">
                <label for="website">Website URL:<span class="info-icon" tabindex="0">ℹ️<span class="tooltip">Please type your correct URL</span></span></label>
                <input type="url" id="website" name="website" placeholder="https://example.com" value="<?= htmlspecialchars($website) ?>">
                <div id="website-error" class="error-msg">Please enter a valid website URL.</div>
            </div>

            <div class="button-group">
                <button type="button" class="btn-primary" id="next-btn">Next</button>
            </div>
            
            <input type="hidden" id="campid" name="campid" value="">
            <input type="hidden" id="actionid" name="actionid" value="">
        </form>
        
        <!-- Reviews Section Added to Step 1 -->
        

        <div id="loading-overlay">
            <div class="loader"></div>
            <p id="loading-text">Analyzing SEO for your website...</p>
            <div class="progress-container">
                <div id="progress-bar"></div>
            </div>
        </div>

        <div id="step2-container" style="display:none;">
            <h1 id="step2-heading" style="text-align:center;">AI Agent Analyzing Summary for <span id="domain-name"></span></h1>
            <p id="step2-message" style="text-align:center; color:#e53935; font-weight:bold;">Don't worry if you are getting a lower ranking issue. Please proceed to our next step and start your AI SEO Campaign.</p>

            <div class="data-cards-container">
                <div class="data-card">
                    <span id="domain-rating-indicator" class="indicator"></span>
                    <div class="progress-circle-container">
                        <div id="domain-rating-circle" class="progress-circle"></div>
                        <span id="domain-rating-value" class="progress-value">--</span>
                    </div>
                    <h3 class="data-card-title">Domain Rating</h3>
                    <p id="domain-rating-text" class="blinking-text"></p>
                </div>

                <div class="data-card">
                    <span id="url-rating-indicator" class="indicator"></span>
                    <div class="progress-circle-container">
                        <div id="url-rating-circle" class="progress-circle"></div>
                        <span id="url-rating-value" class="progress-value">--</span>
                    </div>
                    <h3 class="data-card-title">URL Rating</h3>
                    <p id="url-rating-text" class="blinking-text"></p>
                </div>

                <div class="data-card">
                    <span id="keywords-indicator" class="indicator"></span>
                    <h3 class="data-card-title">Organic Keywords</h3>
                    <p class="data-card-value" id="keywords-value">--</p>
                    <p id="keywords-text" class="blinking-text"></p>
                </div>
                
                <div class="data-card">
                    <span id="ref-domains-indicator" class="indicator"></span>
                    <h3 class="data-card-title">Referring Domains</h3>
                    <p class="data-card-value" id="ref-domains-value">--</p>
                    <p id="ref-domains-text" class="blinking-text"></p>
                </div>
                
                <div class="data-card">
                    <span id="traffic-indicator" class="indicator"></span>
                    <h3 class="data-card-title">Monthly Traffic</h3>
                    <p class="data-card-value" id="traffic-value">--</p>
                    <p id="traffic-text" class="blinking-text"></p>
                </div>

                <div class="data-card">
                    <span id="words-indicator" class="indicator"></span>
                    <h3 class="data-card-title">Page Words</h3>
                    <p class="data-card-value" id="words-value">--</p>
                    <p id="words-text" class="blinking-text"></p>
                </div>
            </div>

            <div class="reviews-container">
                <h2 style="text-align:center; font-weight:700; color:purple; font-size:28px; margin-bottom:20px; text-transform:uppercase; letter-spacing:1px;">
                    Our Customer Reviews
                </h2>
                
                <button class="carousel-btn left" onclick="moveSlide(-1)">&#10094;</button>
                <button class="carousel-btn right" onclick="moveSlide(1)">&#10095;</button>
                
                <div class="review-carousel" id="reviewCarouselStep2">
                    <?php if (!empty($reviews)): ?>
                        <?php foreach ($reviews as $review): ?>
                            <div class="review-card">
                                <img src="https://i.pravatar.cc/150?u=<?= htmlspecialchars($review['firstname']) ?>" 
                                     class="profile-img" alt="User Profile Image">
                                <div class="username"><?= htmlspecialchars($review['firstname']) ?></div>
                                <div class="country"><?= htmlspecialchars($review['country']) ?></div>
                                <div class="star-rating">⭐⭐⭐⭐⭐</div>
                                <p class="review-text" style="font-style:italic; color:purple;">
                                    “<?= htmlspecialchars($review['comment']) ?>”
                                </p>
                                <small style="display:block; text-align:center; margin-top:10px; color:red; font-weight:bold; animation: blink 1s infinite;">
                                    <?= timeAgo($review['created_at']); ?>
                                </small>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>No reviews available yet.</p>
                    <?php endif; ?>
                </div>
            </div>

            <div style="text-align:center; margin-top: 40px;">
                <button id="step2-prev" class="btn-secondary" type="button">Previous</button>
                <button id="step2-submit" class="btn-primary" type="button">Next: Configure Campaign</button>
            </div>
        </div>

        <div id="step3-container" style="display:none;">
            <h1 style="text-align:center;">Step 3: Selected Package</h1>
            <p style="text-align:center; margin-bottom: 30px; font-size: 1.2rem; font-weight: bold; color: #e53935;">
                Choose your budget, Fill your website details & Submit in one click!
            </p>

            <div class="budget-container">
                <h2>Choose Your Budget</h2>
                <div class="price-display" id="price-display">$25</div>
                <div id="suggestion-text" class="blinking-suggestion-text" style="display:none;"></div>
                <div class="slider-wrapper">
                    <div class="animated-hand-text-container">
                        <div id="animated-text" class="animated-text">
                            <span class="hand-icon hand-left">👈</span> Slide to Change Package <span class="hand-icon hand-right">👉</span>
                        </div>
                    </div>
                    <input type="range" id="budget-slider" class="budget-slider" min="0" max="8" value="0">
                </div>
            </div>

            <div class="campaign-details">
                <h3 id="package-name-heading"></h3>
                <h4>Campaign Details</h4>
                <ul id="campaign-features">
                    </ul>
            </div>
            
            <form id="final-campaign-form" style="margin-top: 30px; padding: 20px; box-shadow: none;">
                <h4 style="text-align: center; color: #1a237e;">Order details</h4>
                <div class="form-group">
                    <label for="campaign-name">Campaign Name:</label>
                    <input type="text" id="campaign-name" name="campaign-name" placeholder="E.g., My first campaign" required>
                </div>
                <div class="form-group">
                    <label for="keywords">Target Keywords (separated by commas):</label>
                    <input type="text" id="keywords" name="keywords" placeholder="E.g., SEO tool, marketing software" required>
                </div>
                <div class="form-group">
                    <label for="website-urls">Website URLs (one per line):</label>
                    <textarea id="website-urls" name="website-urls" rows="5" required
                        placeholder="http://example.com/page-one.html
http://example.com/page-two.html
http://example.com/page-three.html"></textarea>
                </div>
            </form>

           <!-- In your HTML, find this section: -->
<div style="text-align:center; margin-top: 40px;">
    <button id="step3-prev" class="btn-secondary" type="button">Previous</button>
    <button id="step3-submit" class="btn-primary" type="button">Campaign Scheduling</button>
</div>

</div> <!-- This closes the step3-container -->

<!-- STEP 4 - Move this section right here -->
<div id="step4-container" style="display:none;">
    <h1 id="step4-heading">Step 4: Campaign Scheduling</h1>

    <div class="campaign-details">
        <h3 id="step4-package-summary-heading"></h3>
    </div>

    <div class="budget-container" style="margin-top: 30px;">
        <h2>Campaign Scheduling Area</h2>
        <p style="text-align: center; font-weight: bold; margin-bottom: 20px;">
            Please choose your preferred billing option below.
        </p>
        
        <div class="tab-container" id="billing-tabs">
            
            <button class="tab-button active" data-period="onetime">Onetime Campaign </button>
            <button class="tab-button" data-period="weekly">Weekly Campaigne</button>
            <button class="tab-button" data-period="monthly">Monthly Campaign</button>
            <button class="tab-button" data-period="six-months">6 Months Campaign</button>
        </div>

        <div class="form-group">
  <label for="coupon-code">Coupon Code:</label>
  <div class="coupon-box">
    <input type="text" id="coupon-code" name="coupon-code" placeholder="Enter coupon code">
    <span id="coupon-validation-icon" class="validation-icon" style="display:none;">❓</span>
    <span id="coupon-validation-msg" class="validation-msg" style="display:none;">Not validated</span>
  </div>
 <button id="apply-coupon-btn" type="button" class="coupon-btn">Apply Coupon</button>

</div>

        
        
       <script>
           
           

document.addEventListener('DOMContentLoaded', function() {
    const applyCouponBtn = document.getElementById('apply-coupon-btn');
    const couponInput = document.getElementById('coupon-code');
    const couponMsg = document.getElementById('coupon-validation-msg');
    const icon = document.getElementById('coupon-validation-icon');

    applyCouponBtn.addEventListener('click', function() {
        const couponCode = couponInput.value.trim();

        if (couponCode === '') {
            couponMsg.textContent = '⚠️ Please enter a coupon code.';
            couponMsg.className = 'validation-msg validation-warning';
            couponMsg.style.display = 'inline-block';
            icon.style.display = 'none';
            return;
        }

        fetch('validate_coupon.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ coupon: couponCode }),
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                // Example: base package price comes from step3 slider
                const currentPackageIndex = parseInt(budgetSlider.value);
                const packageInfo = packages[currentPackageIndex];
                const basePrice = parseFloat(packageInfo.price);

                // Apply discount
                let discountValue = parseFloat(data.discount);
                let finalPrice = basePrice;

                if (data.discount_type === 'percent') {
                    finalPrice = basePrice - (basePrice * discountValue / 100);
                    discountValue = basePrice * discountValue / 100;
                } else {
                    finalPrice = basePrice - discountValue;
                }

                // Update UI
                couponMsg.innerHTML = `✅ Coupon applied successfully!<br>
                    Discount: <strong style="color:green;">$${discountValue.toFixed(2)}</strong><br>
                    New Total: <strong style="color:#d63384;">$${finalPrice.toFixed(2)}</strong>`;
                couponMsg.className = 'validation-msg validation-success';
                couponMsg.style.display = 'inline-block';
                icon.style.display = 'none';

                // Update step4 heading with discounted price
                document.getElementById('step4-package-summary-heading').innerHTML = 
                    `Selected Package: <span style="color:red; font-weight:bold;">
                        ${packageInfo.Name} - $${basePrice.toFixed(2)}
                    </span><br>
                    <span style="color:green; font-weight:bold;">
                        Discount Applied: -$${discountValue.toFixed(2)}
                    </span><br>
                    <span style="color:#007bff; font-weight:bold;">
                        Final Total: $${finalPrice.toFixed(2)}
                    </span>`;
            } else {
                couponMsg.textContent = '❌ Invalid or expired coupon code.';
                couponMsg.className = 'validation-msg validation-error';
                couponMsg.style.display = 'inline-block';
                icon.style.display = 'none';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            couponMsg.textContent = '⚠️ An error occurred. Please try again.';
            couponMsg.className = 'validation-msg validation-warning';
            couponMsg.style.display = 'inline-block';
            icon.style.display = 'none';
        });
    });
});

           
       </script>
        
        
       
        
        

       <div class="form-group">
  <label for="payment-gateway">Select Payment Gateway:</label>
  <div id="payment-dropdown" class="custom-dropdown"></div>
</div>




    <div style="text-align:center; margin-top: 40px;">
        <button id="step4-prev" class="btn-secondary" type="button">Previous</button>
        <button id="pay-now-btn" class="btn-primary" type="button">Pay Now</button>
    </div>
</div>

</div> <!-- This closes the main-content div -->
<script>
    
  document.addEventListener('DOMContentLoaded', function() {
    const dropdown = document.getElementById('payment-dropdown');

    const logoMap = {
        visa: "https://img.icons8.com/color/48/000000/visa.png",
        master: "https://img.icons8.com/color/48/000000/mastercard.png",
        amex: "https://img.icons8.com/color/48/000000/amex.png",
        discover: "https://img.icons8.com/color/48/000000/discover.png",
        unionpay: "https://img.icons8.com/color/48/000000/unionpay.png",
        crypto: "https://img.icons8.com/color/48/000000/blockchain.png",  // generic crypto icon
    btc: "https://img.icons8.com/color/48/000000/bitcoin--v1.png",
    eth: "https://img.icons8.com/color/48/000000/ethereum.png",
    usdt: "https://cryptologos.cc/logos/tether-usdt-logo.png",
    bnb: "https://cryptologos.cc/logos/bnb-bnb-logo.png"
    };

    fetch('get_payment_methods.php')
        .then(res => res.json())
        .then(data => {
            if (data.status === 'success' && data.methods.length > 0) {
                // Build custom dropdown
                dropdown.innerHTML = `
                  <div class="selected">-- Select Payment Gateway --</div>
                  <div class="options"></div>
                `;

                const optionsDiv = dropdown.querySelector('.options');
                const selectedDiv = dropdown.querySelector('.selected');

                data.methods.forEach(method => {
                    let option = document.createElement('div');
                    option.classList.add('option');

                    let logos = '';
                    method.options.forEach(opt => {
                        const key = opt.trim().toLowerCase();
                        if (logoMap[key]) {
                            logos += `<img src="${logoMap[key]}" alt="${key}">`;
                        }
                    });

                    option.innerHTML = `${method.name.trim()} ${logos}`;
                    option.dataset.value = method.id;

                    option.addEventListener('click', () => {
                        selectedDiv.innerHTML = option.innerHTML;
                        optionsDiv.style.display = 'none';
                    });

                    optionsDiv.appendChild(option);
                });

                // Toggle dropdown on click
                selectedDiv.addEventListener('click', () => {
                    const isVisible = optionsDiv.style.display === 'block';
                    optionsDiv.style.display = isVisible ? 'none' : 'block';
                });

                // Close if clicked outside
                document.addEventListener('click', (e) => {
                    if (!dropdown.contains(e.target)) {
                        optionsDiv.style.display = 'none';
                    }
                });
            }
        });
});



</script>


<!--step4  -->




<script>
const packages = <?php echo json_encode($packages); ?>;

const debounce = (fn, ms = 400) => {
    let t;
    return (...args) => { clearTimeout(t); t = setTimeout(() => fn(...args), ms); }
};

const loadingMessages = [
    "Analyzing SEO for your website...",
    "Scanning content and keywords...",
    "Identifying primary product/service...",
    "Generating SEO-optimized campaign suggestions...",
    "Finalizing campaign settings...",
    "Almost there!"
];

// Carousel functionality
let currentIndex = 0;
const carousels = [
    document.getElementById("reviewCarousel"),
    document.getElementById("reviewCarouselStep2")
];

function moveSlide(direction, carouselIndex = 0) {
    const carousel = carousels[carouselIndex];
    if (!carousel) return;
    
    const cards = carousel.querySelectorAll(".review-card");
    const visibleCards = 3;
    const cardWidth = cards[0]?.offsetWidth + 20 || 270;

    currentIndex += direction;

    // Loop back to start if at end
    if (currentIndex > cards.length - visibleCards) {
        currentIndex = 0;
    } else if (currentIndex < 0) {
        currentIndex = cards.length - visibleCards;
    }

    carousel.style.transform = `translateX(${-currentIndex * cardWidth}px)`;
}

// Auto move carousels
setInterval(() => {
    moveSlide(1, 0);
}, 3000);

setInterval(() => {
    moveSlide(1, 1);
}, 3200);

function autoSaveAll() {
    const campid = document.getElementById('campid').value || '';
    const actionid = document.getElementById('actionid').value || '';
    const website = document.getElementById('website').value || '';

    fetch('autosave.php', {
        method: 'POST',
        headers: { 'Content-Type':'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            campid,
            actionid,
            website
        })
    })
    .then(res => res.json())
    .then(data => {
        document.getElementById('campid').value = data.campid;
        document.getElementById('actionid').value = data.actionid;
        console.log("Autosave:", data);
    });
}

function fetchAIResults(websiteUrl) {
    return new Promise((resolve, reject) => {
        fetch(`api_proxy.php?website_url=${encodeURIComponent(websiteUrl)}`)
            .then(res => {
                if (!res.ok) {
                    throw new Error('Network response was not ok');
                }
                return res.json();
            })
            .then(data => {
                if (data.success === true) {
                    resolve(data);
                } else {
                    reject(new Error(data.error || 'API returned a non-success response.'));
                }
            })
            .catch(error => {
                console.error('Fetch Error:', error);
                reject(error);
            });
    });
}

let seoData = null;
let suggestedPackageIndex = null;

document.getElementById('next-btn').addEventListener('click', (e) => {
    e.preventDefault();
    const websiteUrl = document.getElementById('website').value;
    const websiteError = document.getElementById('website-error');
    const websiteInput = document.getElementById('website');

    if (!websiteUrl || !websiteUrl.match(/^(https?:\/\/(?:www\.|(?!www))[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\.[^\s]{2,}|www\.[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\.[^\s]{2,}|https?:\/\/(?:www\.|(?!www))[a-zA-Z0-9]+\.[^\s]{2,}|[a-zA-Z0-9]+\.[^\s]{2,})$/)) {
        websiteInput.classList.add('error');
        websiteError.style.display = 'block';
        return;
    } else {
        websiteInput.classList.remove('error');
        websiteError.style.display = 'none';
        
        const loadingOverlay = document.getElementById('loading-overlay');
        const loadingText = document.getElementById('loading-text');
        const progressBar = document.getElementById('progress-bar');
        loadingOverlay.style.display = 'flex';

        let messageIndex = 0;
        const totalMessages = loadingMessages.length;
        const intervalId = setInterval(() => {
            if (messageIndex < totalMessages - 1) {
                loadingText.textContent = loadingMessages[messageIndex];
                const progressPercentage = (messageIndex + 1) / totalMessages * 99;
                progressBar.style.width = progressPercentage + '%';
                messageIndex++;
            } else {
                loadingText.textContent = loadingMessages[totalMessages - 1] + " Please wait...";
                progressBar.style.width = '99%';
                clearInterval(intervalId);
                
                fetchAIResults(websiteUrl)
                    .then(apiResponse => {
                        seoData = apiResponse.data.domain;
                        populateStep2Dashboard(apiResponse);
                        loadingOverlay.style.display = 'none';
                        document.getElementById('campaign-form').style.display = 'none';
                        document.getElementById('step2-container').style.display = 'block';
                        document.getElementById('form-heading').innerText = 'Step 2: SEO Report';
                        
                        
                        
                    })
                    .catch(error => {
                        loadingOverlay.style.display = 'none';
                        alert('Failed to fetch SEO data: ' + error.message);
                    });
            }
        }, 1500); 
    }
});

function populateStep2Dashboard(data) {
    const domainData = data.data.domain;
    const pageData = data.data.page;

    const websiteUrl = document.getElementById('website').value;
    const domainName = new URL(websiteUrl).hostname;
    document.getElementById('domain-name').textContent = domainName;

    const formatNumber = (num) => {
        if (num >= 1000000) {
            return (num / 1000000).toFixed(1) + 'M';
        } else if (num >= 1000) {
            return (num / 1000).toFixed(1) + 'K';
        }
        return num.toString();
    };

    const animateCircle = (elementId, value) => {
        const circle = document.getElementById(elementId);
        const percent = Math.min(Math.max(value, 0), 100);
        let colorClass = 'low-rating';
        if (percent > 40 && percent < 70) {
            colorClass = 'medium-rating';
        } else if (percent >= 70) {
            colorClass = 'high-rating';
        }
        circle.style.setProperty('--progress', `${percent}%`);
        circle.className = `progress-circle ${colorClass}`;
    };

    const setIndicator = (elementId, textElementId, value, goodThreshold, badThreshold) => {
        const indicator = document.getElementById(elementId);
        const textElement = document.getElementById(textElementId);
        let colorClass, text;

        if (value >= goodThreshold) {
            colorClass = 'green';
            text = 'Good to Go!';
        } else if (value > badThreshold) {
            colorClass = 'orange';
            text = 'Needs Improvement';
        } else {
            colorClass = 'red';
            text = 'Needs Major Improvement';
        }

        indicator.className = `indicator blinking-light ${colorClass}`;
        textElement.className = `blinking-text ${colorClass}`;
        textElement.textContent = text;
    };

    const domainRating = domainData.domainRating || 0;
    const urlRating = pageData.urlRating || 0;
    const organicKeywords = domainData.organicKeywords || 0;
    const refDomains = domainData.refDomains || 0;
    const traffic = Math.round(domainData.traffic * 100000) || 0;
    const pageWords = pageData.numberOfWordsOnPage || 0;
    
    document.getElementById('domain-rating-value').textContent = domainRating;
    animateCircle('domain-rating-circle', domainRating);
    setIndicator('domain-rating-indicator', 'domain-rating-text', domainRating, 70, 40);

    document.getElementById('url-rating-value').textContent = urlRating;
    animateCircle('url-rating-circle', urlRating);
    setIndicator('url-rating-indicator', 'url-rating-text', urlRating, 70, 40);

    document.getElementById('keywords-value').textContent = formatNumber(organicKeywords);
    setIndicator('keywords-indicator', 'keywords-text', organicKeywords, 500, 50);

    document.getElementById('ref-domains-value').textContent = formatNumber(refDomains);
    setIndicator('ref-domains-indicator', 'ref-domains-text', refDomains, 500, 50);

    document.getElementById('traffic-value').textContent = formatNumber(traffic);
    setIndicator('traffic-indicator', 'traffic-text', traffic, 10000, 1000);

    document.getElementById('words-value').textContent = formatNumber(pageWords);
    setIndicator('words-indicator', 'words-text', pageWords, 800, 300);
}

const websiteInput = document.getElementById('website');
if (websiteInput) {
    websiteInput.addEventListener('input', debounce(autoSaveAll, 400));
}

document.getElementById('step2-prev').addEventListener('click', () => {
    document.getElementById('step2-container').style.display = 'none';
    document.getElementById('campaign-form').style.display = 'grid';
    document.getElementById('form-heading').innerText = 'Step 1: Submit Your Website';
});

document.getElementById('step2-submit').addEventListener('click', () => {
    document.getElementById('step2-container').style.display = 'none';
    document.getElementById('step3-container').style.display = 'block';
    
    // Also update the Step 3 heading
    
    
document.querySelector('#step3-container h1').innerText = 'Step 3: Configure Your Campaign';
    
    document.getElementById('website-urls').value = document.getElementById('website').value;
    
    let newSuggestedPackageIndex = 0;
    if (seoData && (seoData.domainRating < 40 || seoData.organicKeywords < 50 || seoData.refDomains < 50)) {
        newSuggestedPackageIndex = packages.findIndex(pkg => pkg.price === "150");
        if(newSuggestedPackageIndex === -1) { 
            newSuggestedPackageIndex = 4;
        }
    }
    
    suggestedPackageIndex = newSuggestedPackageIndex;
    
    budgetSlider.value = suggestedPackageIndex;
    updateCampaignDetails(suggestedPackageIndex);

    suggestionTextElement.style.display = 'block';
    suggestionTextElement.innerHTML = `<b>OUR AI suggested best package for your rank.</b>`;

});

document.getElementById('step3-prev').addEventListener('click', () => {
    document.getElementById('step3-container').style.display = 'none';
    document.getElementById('step2-container').style.display = 'block';
});

const budgetSlider = document.getElementById('budget-slider');
const priceDisplay = document.getElementById('price-display');
const campaignFeatures = document.getElementById('campaign-features');
const packageNameHeading = document.getElementById('package-name-heading');
const suggestionTextElement = document.getElementById('suggestion-text');

budgetSlider.max = packages.length > 0 ? packages.length - 1 : 0;

function updateCampaignDetails(index) {
    const packageInfo = packages[index];
    if (packageInfo) {
        priceDisplay.textContent = `$${packageInfo.price}`;
        packageNameHeading.innerHTML = `<span style="color:red; font-weight:bold;">${packageInfo.Name}</span>`;

        const features = packageInfo.Description.split('\n').filter(line => line.trim() !== '');
        campaignFeatures.innerHTML = '';
        features.forEach(feature => {
            const li = document.createElement('li');
            
            let formattedFeature = feature.trim().replace(
                /^(\d+)(\s.*)/,
                '<div class="box-container"><span class="box-red">$1</span><span class="box-black">$2</span></div>'
            );
            
            if (formattedFeature.startsWith('↳')) {
                li.classList.add('nested-item');
                li.innerHTML = formattedFeature;
            } else {
                 li.innerHTML = `↳ ${formattedFeature}`;
            }

            campaignFeatures.appendChild(li);
        });
    }
}

budgetSlider.addEventListener('input', (event) => {
    const index = parseInt(event.target.value);
    updateCampaignDetails(index);
    
    // Check if the current package is the suggested one
    if (index === suggestedPackageIndex) {
        suggestionTextElement.style.display = 'block';
    } else {
        suggestionTextElement.style.display = 'none';
    }
});

// Final form validation
// Final form validation
document.getElementById('step3-submit').addEventListener('click', (e) => {
    const form = document.getElementById('final-campaign-form');
    let isValid = true;
    form.querySelectorAll('input[required], textarea[required]').forEach(field => {
        if (!field.value.trim()) {
            field.classList.add('error');
            isValid = false;
        } else {
            field.classList.remove('error');
        }
    });

    if (isValid) {
        // Show step4 and hide step3
        document.getElementById('step3-container').style.display = 'none';
        document.getElementById('step4-container').style.display = 'block';
        //document.getElementById('form-heading').innerText = 'Step 4: Campaign Scheduling';
        
        // Update step4 heading and package summary
        const currentPackageIndex = parseInt(budgetSlider.value);
        const packageInfo = packages[currentPackageIndex];
        document.getElementById('step4-package-summary-heading').innerHTML = 
            `Selected Package: <span style="color:red; font-weight:bold;">${packageInfo.Name} - $${packageInfo.price}</span>`;
    } else {
        // Replace the alert with custom alert
        showCustomAlert("Please fill in all mandatory fields before submitting.");
    }
});

// Step 4 previous button
document.getElementById('step4-prev').addEventListener('click', () => {
    document.getElementById('step4-container').style.display = 'none';
    document.getElementById('step3-container').style.display = 'block';
});

// Coupon validation (example)
document.getElementById('coupon-code').addEventListener('input', debounce(function() {
    const couponCode = this.value;
    const validationIcon = document.getElementById('coupon-validation-icon');
    const validationMsg = document.getElementById('coupon-validation-msg');
    
    if (couponCode) {
        // Simulate coupon validation
        setTimeout(() => {
            if (couponCode.toLowerCase() === 'valid2024') {
                validationIcon.style.display = 'inline';
                validationIcon.textContent = '✅';
                validationMsg.style.display = 'inline';
                validationMsg.textContent = 'Coupon applied! 10% discount';
                validationMsg.style.color = 'green';
            } else {
                validationIcon.style.display = 'inline';
                validationIcon.textContent = '❌';
                validationMsg.style.display = 'inline';
                validationMsg.textContent = 'Invalid coupon code';
                validationMsg.style.color = 'red';
            }
        }, 800);
    } else {
        validationIcon.style.display = 'none';
        validationMsg.style.display = 'none';
    }
}));

// Billing tabs functionality
document.querySelectorAll('.tab-button').forEach(button => {
    button.addEventListener('click', function() {
        // Remove active class from all buttons
        document.querySelectorAll('.tab-button').forEach(btn => {
            btn.classList.remove('active');
        });
        
        // Add active class to clicked button
        this.classList.add('active');
        
        // Here you can handle different billing periods
        const period = this.getAttribute('data-period');
        console.log('Selected billing period:', period);
        // You can update pricing based on the selected period
    });
});

// Pay Now button
document.getElementById('pay-now-btn').addEventListener('click', () => {
    const paymentGateway = document.getElementById('payment-gateway').value;
    const couponCode = document.getElementById('coupon-code').value;
    const activeTab = document.querySelector('.tab-button.active').getAttribute('data-period');
    
    alert(`Proceeding to payment with:\nGateway: ${paymentGateway}\nBilling: ${activeTab}\nCoupon: ${couponCode || 'None'}`);
    // Here you would redirect to the payment processor
});

if (packages.length > 0) {
    updateCampaignDetails(0);
}
</script>

</body>
</html>