<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'templates/header.php';

// Check if returning from step2
$isReturning = isset($_GET['return']) && $_GET['return'] == '1';

// Defaults

// Default values for form fields
$campaignName    = 'Test Campaign';
$website         = 'https://dropsell.info';
$product         = 'Test Product';
$selectedLanguage = 'English';
$selectedPlatform = 'Google Search';
$platformLinks   = '';
$uniqueVisitors  = '';
$bounceRate      = 50;
$device          = 'desktop';
$geoTargeting    = [];
$campaignStatus  = 'Run Campaign';
$currentPackage  = 'Free Plan';






if ($isReturning) {
    $conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");

    if (!$conn->connect_error) {
        $userid = $_SESSION['user_id'];

       
       
       
        $sql = "SELECT 
                    c.Name AS campaign_name,
                    a.website,
                    a.Productname,
                    a.language,
                    a.platform,
                    a.platlinks,
                    a.UniqueVisitors,
                    a.BounceRate,
                    a.device,
                    a.geo,
                    c.status AS campaign_status,
                    c.current_package
                FROM actions a
                JOIN campaign c ON a.campid = c.campid
                WHERE a.userid = $userid
                ORDER BY a.id DESC LIMIT 1";

        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();

            $campaignName    = $row['campaign_name'] ?? $campaignName;
            $website         = $row['website'] ?? $website;
            $product         = $row['Productname'] ?? $product;
            $selectedLanguage = $row['language'] ?? $selectedLanguage;
            $selectedPlatform = $row['platform'] ?? $selectedPlatform;
            $platformLinks   = $row['platlinks'] ?? $platformLinks;
            $uniqueVisitors  = $row['UniqueVisitors'] ?? $uniqueVisitors;
            $bounceRate      = $row['BounceRate'] ?? $bounceRate;
            $device          = $row['device'] ?? $device;

            // geo might be stored as comma separated string
            $geoTargeting    = !empty($row['geo']) ? explode(',', $row['geo']) : $geoTargeting;
            $campaignStatus  = $row['campaign_status'] ?? $campaignStatus;
            $currentPackage  = $row['current_package'] ?? $currentPackage;
        }
        
        

        $conn->close();
    }
}





?>


<style>
    /* Your existing styles unchanged */
    .main-wrapper {
        display: flex;
        min-height: 100vh;
    }

    .sidebar {
        width: 250px;
        background-color: #343a40;
        padding: 20px 0;
        color: #fff;
    }

    .sidebar a {
        display: block;
        padding: 12px 20px;
        color: #fff;
        text-decoration: none;
    }

    .sidebar a:hover,
    .sidebar a.active {
        background-color: #495057;
    }

    .main-content {
        flex-grow: 1;
        padding: 40px 30px;
        background-color: #e8f0fe; /* light pastel blue background */
    }

    h1 {
        font-weight: 700;
        color: #1a237e; /* dark navy blue */
        margin-bottom: 30px;
        font-size: 28px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* New form container styling */
    form {
        background-color: #ffffff;
        border-radius: 16px;
        padding: 40px 50px;
        box-shadow: 0 8px 30px rgba(26, 35, 126, 0.12);
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 28px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group label {
        font-weight: 600;
        margin-bottom: 8px;
        color: #3949ab; /* medium blue */
    }

    .form-group input,
    .form-group select {
        padding: 12px 15px;
        font-size: 16px;
        border: 1.8px solid #c5cae9; /* soft blue border */
        border-radius: 10px;
        background-color: #f5f7ff; /* very light blue */
        color: #1a237e;
        box-shadow: inset 0 2px 5px rgba(60, 66, 201, 0.05);
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }

    .form-group input:focus,
    .form-group select:focus {
        border-color: #3949ab; /* highlight on focus */
        box-shadow: 0 0 8px rgba(57, 73, 171, 0.4);
        outline: none;
        background-color: #e8ecff;
    }

    .form-group input.error {
        border-color: #e53935;
        background-color: #ffebee;
        box-shadow: 0 0 6px 2px rgba(229, 57, 53, 0.6);
        color: #b71c1c;
    }

    .error-msg {
        color: #e53935;
        font-size: 14px;
        margin-top: 5px;
        display: none;
        font-weight: 600;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .button-group {
        grid-column: 1 / -1;
        display: flex;
        justify-content: flex-end;
        gap: 14px;
        margin-top: 28px;
    }

    .btn-primary {
        background: linear-gradient(135deg, #3949ab, #1a237e);
        color: white;
        padding: 12px 28px;
        border: none;
        border-radius: 10px;
        font-weight: 700;
        font-size: 16px;
        cursor: pointer;
        box-shadow: 0 6px 20px rgba(26, 35, 126, 0.5);
        transition: background 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #1a237e, #121858);
        box-shadow: 0 8px 25px rgba(18, 24, 88, 0.7);
    }

    .btn-secondary {
        background-color: #c5cae9;
        color: #3949ab;
        padding: 12px 28px;
        border: none;
        border-radius: 10px;
        font-weight: 600;
        font-size: 16px;
        cursor: pointer;
        box-shadow: none;
        transition: background-color 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .btn-secondary:hover {
        background-color: #9fa8da;
        color: #1a237e;
    }

    .flag, .platform-icon {
        margin-right: 8px;
        width: 20px;
        height: 15px;
        vertical-align: middle;
    }

    @media screen and (max-width: 768px) {
        form {
            grid-template-columns: 1fr;
        }
    }

    /* Keep your popup styles exactly the same as before */

    #confirm-modal {
        display: none;
        position: fixed;
        top: 0; left: 0; right: 0; bottom: 0;
        background: rgba(62, 39, 35, 0.75);
        z-index: 1000;
        align-items: center;
        justify-content: center;
    }

    #confirm-modal.active {
        display: flex;
    }

    #confirm-modal .modal-content {
        background: #fff3e0;
        border-radius: 14px;
        padding: 40px 35px;
        max-width: 430px;
        width: 90%;
        box-shadow:
            0 6px 25px rgba(160, 82, 45, 0.4),
            0 0 18px 4px rgba(255, 152, 0, 0.7);
        text-align: center;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        border: 4px solid #fb8c00;
        color: #6d4c41;
        transition: transform 0.3s ease;
    }

    #confirm-modal.active .modal-content {
        transform: scale(1);
    }

    #confirm-modal .modal-content p {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 30px;
        line-height: 1.5;
        white-space: pre-line;
    }

    #confirm-modal .modal-buttons {
        display: flex;
        justify-content: center;
        gap: 22px;
    }

    #confirm-modal .modal-buttons button {
        padding: 14px 30px;
        border-radius: 10px;
        font-size: 17px;
        cursor: pointer;
        transition: all 0.35s ease;
        min-width: 120px;
        font-weight: 700;
        box-shadow: 0 5px 14px rgba(0, 0, 0, 0.1);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    #confirm-modal .btn-ok {
        background: linear-gradient(135deg, #fb8c00, #ef6c00);
        border: none;
        color: #fff;
        box-shadow:
            0 5px 20px rgba(251, 140, 0, 0.75);
    }
    #confirm-modal .btn-ok:hover {
        background: linear-gradient(135deg, #ef6c00, #e65100);
        box-shadow:
            0 7px 24px rgba(230, 81, 0, 0.85);
        transform: translateY(-3px);
    }

    #confirm-modal .btn-cancel {
        background: #fff8e1;
        border: 3px solid #a1887f;
        color: #6d4c41;
        box-shadow: none;
    }
    #confirm-modal .btn-cancel:hover {
        background: #ffe0b2;
        border-color: #8d6e63;
        color: #4e342e;
        transform: translateY(-3px);
    }

    /* Loader overlay - Added only */
    #loading-overlay {
        display: none;
        position: fixed;
        top: 0; left: 0; right: 0; bottom: 0;
        background: rgba(26, 35, 126, 0.6);
        z-index: 2000;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        color: white;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        font-size: 22px;
        font-weight: 700;
    }

    .loader {
        border: 8px solid #f3f3f3;
        border-top: 8px solid #3949ab;
        border-radius: 50%;
        width: 70px;
        height: 70px;
        animation: spin 1.3s linear infinite;
        margin-bottom: 15px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Your platform tab styles */
    .platform-tab {
        padding: 8px 14px;
        border: 1px solid #ccc;
        background-color: #f9f9f9;
        cursor: pointer;
        border-radius: 4px;
        color: #000;
        transition: background-color 0.2s ease;
    }

    .platform-tab.active {
        background-color: #007bff;
        color: white;
        border-color: #007bff;
    }

    textarea.error {
        border-color: #e53935;
        background-color: #ffebee;
        box-shadow: 0 0 6px 2px rgba(229, 57, 53, 0.6);
        color: #b71c1c;
    }
    
    
   .device-tab {
    position: relative;
    padding: 12px 24px; /* slightly larger for rounded look */
    border: 1.8px solid #c5cae9;
    border-radius: 999px; /* fully rounded pill shape */
    background-color: #f5f7ff;
    cursor: pointer;
    font-size: 18px;
    transition: background-color 0.25s ease, border-color 0.25s ease;
    user-select: none;
    white-space: nowrap;
    display: flex;
    align-items: center;
    gap: 12px; /* reduced gap between icon and text */
    
}


.device-tabs-container {
    display: flex;
    flex-wrap: wrap; /* allows wrapping to new rows */
    gap: 10px; /* spacing between tabs */
}



.device-tab.active {
    background-color: #3949ab;
    border-color: #1a237e;
    color: white;
    font-weight: 700;
    box-shadow: 0 6px 20px rgba(26, 35, 126, 0.5);
}
.device-tab:hover:not(.active) {
    background-color: #d4d9f8;
}

/* Info icon style */
.info-icon {
    font-style: normal;
    font-size: 16px;
    color: #3949ab;
    cursor: default;
    position: relative;
    user-select: none;
    outline: none;
}

/* Tooltip container */
.info-icon .tooltip {
    visibility: hidden;
    width: max-content;
    max-width: 180px;
    background-color: #e53935;
    color: #fff;
    text-align: center;
    border-radius: 8px;
    padding: 8px 12px;
    position: absolute;
    z-index: 10;
    bottom: 125%; /* show above icon */
    left: 50%;
    transform: translateX(-50%);
    opacity: 0;
    transition: opacity 0.3s ease;
    font-size: 14px;
    pointer-events: none;
}

/* Tooltip arrow */
.info-icon .tooltip::after {
    content: "";
    position: absolute;
    top: 100%; /* bottom of tooltip */
    left: 50%;
    transform: translateX(-50%);
    border-width: 6px;
    border-style: solid;
    border-color: #3949ab transparent transparent transparent;
}

/* Show tooltip on hover or focus */
.info-icon:hover .tooltip,
.info-icon:focus .tooltip {
    visibility: visible;
    opacity: 1;
    pointer-events: auto;
}


    
    <style>
  .info-icon {
    position: relative;
    display: inline-block;
    cursor: pointer;
    font-size: 16px;
    color: #e53935;
  }

  .info-icon .tooltip {
    visibility: hidden;
    width: 160px;
    background-color: #e53935;
    color: #fff;
    text-align: left;
    border-radius: 6px;
    padding: 8px;
    position: absolute;
    z-index: 1;
    bottom: 125%;
    left: 50%;
    transform: translateX(-50%);
    opacity: 0;
    transition: opacity 0.3s ease;
  }

  .info-icon:hover .tooltip,
  .info-icon:focus .tooltip {
    visibility: visible;
    opacity: 1;
  }
</style>

    
    
    
    
    
</style>

<div class="main-wrapper">
  <!-- Sidebar -->
  <div class="sidebar">
    <nav>
      <ul class="sidebar-menu">
        <li><a href="dashboard.php" class="sidebar-link"><span class="icon">🏠</span> Dashboard</a></li>
        <li><a href="create_campaign.php" class="sidebar-link active"><span class="icon">📈</span> Create Campaign</a></li>
        <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
        <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
      </ul>
    </nav>
  </div>

  <style>
  .sidebar {
      width: 260px;
      background-color: #1e1e2f;
      padding-top: 40px;
      padding-bottom: 40px;
      color: #ddd;
      box-shadow: 2px 0 12px rgba(0,0,0,0.2);
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      user-select: none;
      display: flex;
      flex-direction: column;
      align-items: center;
      flex-shrink: 0;
  }

  .sidebar-menu {
      list-style: none;
      padding: 0;
      margin: 0;
      width: 100%;
  }

  .sidebar-menu li {
      margin: 12px 0;
  }

  .sidebar-link {
      display: flex;
      align-items: center;
      text-decoration: none;
      color: #bbb;
      font-size: 18px;
      padding: 12px 24px;
      border-radius: 8px;
      transition: background-color 0.3s ease, color 0.3s ease;
  }

  .sidebar-link .icon {
      margin-right: 14px;
      font-size: 20px;
      width: 32px;
      height: 32px;
      background: #fff;
      color: #4f63d3;
      border-radius: 50%;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
  }

  .sidebar-link:hover {
      background: #3a3f55;
      color: #fff;
      box-shadow: 0 4px 12px rgba(58, 63, 85, 0.6);
  }

  .sidebar-link.active {
      background: #4f63d3;
      color: #fff;
      box-shadow: 0 4px 20px rgba(79, 99, 211, 0.7);
      font-weight: 600;
  }
  
  
  .modal {
  display: none; /* Hidden by default */
  position: fixed;
  z-index: 1000;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  overflow: auto;
  background-color: rgba(0,0,0,0.5); /* semi-transparent */
}

.modal-content {
  background-color: #fff;
  margin: 15% auto;
  padding: 20px;
  border-radius: 10px;
  width: 400px;
  text-align: center;
  box-shadow: 0 5px 15px rgba(0,0,0,0.3);
}

.close {
  color: #aaa;
  float: right;
  font-size: 28px;
  font-weight: bold;
  cursor: pointer;
}
.close:hover { color: black; }

#upgrade-btn {
  margin-top: 15px;
  padding: 10px 20px;
  font-size: 16px;
  cursor: pointer;
}

  
  
  
  
  
  
  </style>
  
  


  
  

  
  

  <div class="main-content">

    <h1 id="form-heading">Step 1: Submit Your Website & Product</h1>


    <form id="campaign-form" method="POST" action="save_step1_data.php" onsubmit="return onFormSubmit(event)">
        
      <div class="form-group">
          
        <label for="campaign_name">Campaign Name:<span class="info-icon" tabindex="0">ℹ️
    <span class="tooltip">You can set Campaign Name</span>
  </span></label>
        
        <input type="text" id="campaign_name" name="campaign_name"
          value="<?= htmlspecialchars($campaignName) ?>"
          <?= $isReturning ? 'readonly' : '' ?>>
        <div id="campaign_name-error" class="error-msg">Campaign name is required.</div>
      </div>

      <div class="form-group">
        <label for="website">Website URL:<span class="info-icon" tabindex="0">ℹ️
    <span class="tooltip">Please type your correct URL</span>
  </span></label>
        <input type="url" id="website" name="website" style="width:100%;" placeholder="https://example.com" value="<?= htmlspecialchars($website) ?>">
        <div id="website-error" class="error-msg" style="display:none; color:red; margin-top:4px;">
          Please enter a valid website URL.
        </div>
      </div>

      <div class="form-group">
        <label for="product">Product Name:<span class="info-icon" tabindex="0">ℹ️
    <span class="tooltip">Please Type your Product Name</span>
  </span></label>
        <input type="text" id="product" name="product" value="<?= htmlspecialchars($product) ?>">
        <div id="product-error" class="error-msg">Product name is required.</div>
      </div>

      <div class="form-group">
        <label for="language">Language:<span class="info-icon" tabindex="0">ℹ️
    <span class="tooltip">Please Type your Site Launage</span>
  </span></label>
        <select id="language" name="language" <?= $isReturning ? 'disabled' : '' ?>>
          <option value="English" <?= $selectedLanguage === 'English' ? 'selected' : '' ?>>🇬🇧 English</option>
          <option value="Spanish" <?= $selectedLanguage === 'Spanish' ? 'selected' : '' ?>>🇪🇸 Spanish</option>
          <option value="French" <?= $selectedLanguage === 'French' ? 'selected' : '' ?>>🇫🇷 French</option>
          <option value="German" <?= $selectedLanguage === 'German' ? 'selected' : '' ?>>🇩🇪 German</option>
          <option value="Sinhala" <?= $selectedLanguage === 'Sinhala' ? 'selected' : '' ?>>🇱🇰 Sinhala</option>
        </select>
      </div>

      <div class="form-group">
        <label>Platform:<span class="info-icon" tabindex="0">ℹ️
    <span class="tooltip">Please select Platform by default set to Direct</span>
  </span></label>
        <div id="platform-tabs" style="display:flex; gap:10px; margin-bottom:8px;">
          <button type="button" class="platform-tab" data-value="Organic">Organic</button>
          <button type="button" class="platform-tab" data-value="Referral">Referral</button>
          <button type="button" class="platform-tab" data-value="Social">Social</button>
          <button type="button" class="platform-tab active" data-value="Direct">Direct</button>
        </div>
        <input type="hidden" name="platform" id="platform" value="Direct" />

        <div id="platform-links-container" style="display:none; margin-top:8px;">
          <label for="platform-links" id="platform-links-label">Enter text (one per line):</label>
          <textarea
            name="platform_links"
            id="platform-links"
            rows="4"
            style="width:100%;"
            placeholder="Enter one entry per line"
          ></textarea>

          <small></small>
          <div id="platform-links-error" class="error-msg" style="color:#e53935; margin-top:4px; display:none;">Please enter at least one entry.</div>
        </div>
      </div>

      <div class="button-group">
          
        <button type="submit" class="btn-primary" id="next-btn">Next</button>
        <input type="hidden" id="campid" name="campid" value="">
<input type="hidden" id="actionid" name="actionid" value="">

      </div>
      <script>
      // Utility debounce function
const debounce = (fn, ms = 400) => { 
    let t; 
    return (...args) => { clearTimeout(t); t = setTimeout(() => fn(...args), ms); } 
};

// Save function
function autoSaveAll() {
    const campid = document.getElementById('campid').value || '';
    const actionid = document.getElementById('actionid').value || '';
    const website = document.getElementById('website').value || '';
    const product = document.getElementById('product').value || '';
    const language = document.getElementById('language').value;
    const platform = document.getElementById('platform').value;
    const platlinks = document.getElementById('platform-links')?.value || '';
    const campaignName = document.getElementById('campaign_name')?.value || 'Test Campaignn';
   
   const uniqueVisitors = document.getElementById('unique-visitors')?.value || 0;
    const bounceRate     = document.getElementById('bounce-rate')?.value || 50;
    
    const device = document.getElementById('device')?.value || 'desktop';
    
    
    

    fetch('autosave.php', {
        method: 'POST',
        headers: { 'Content-Type':'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            campid, 
            actionid, 
            website, 
            productname: product, 
            language, 
            platform, 
            platlinks,
            campaignName,
            uniqueVisitors, bounceRate
            
        })
    })
    .then(res => res.json())
    .then(data => {
        document.getElementById('campid').value = data.campid;
        document.getElementById('actionid').value = data.actionid;
        console.log("Autosave:", data);
    });
}

// Platform tab click handler
document.querySelectorAll('.platform-tab').forEach(btn => {
    btn.addEventListener('click', () => {
        document.querySelectorAll('.platform-tab').forEach(b => b.classList.remove('active'));
        btn.classList.add('active');

        const platform = btn.dataset.value;
        document.getElementById('platform').value = platform;

        // Show/hide textarea for Referral, Social, Organic
        const container = document.getElementById('platform-links-container');
        container.style.display = ['Referral','Social','Organic'].includes(platform) ? 'block' : 'none';

        autoSaveAll();
    });
});




// Textarea input autosave (debounced)
const platTextarea = document.getElementById('platform-links');
if (platTextarea) platTextarea.addEventListener('input', debounce(autoSaveAll, 400));

// Also autosave other fields
['website','product','language','unique-visitors','bounce-rate'].forEach(id => {
    const el = document.getElementById(id);
    if (el) el.addEventListener('input', debounce(autoSaveAll, 400));
});



</script>
      
    </form>
    

    <!-- Step 2 container - hidden initially -->
     <div id="step2-container" style="display:none;">

    
    <form id="step2-form" style="display: grid; grid-template-columns: 1fr 1fr; gap: 28px;">
        <div class="form-group" style="grid-column: span 1;">
  <label for="unique-visitors" style="display: flex; align-items: center; gap: 8px;">
    Unique Visitors per Day:
    <span class="info-icon" tabindex="0">ℹ️
    <span class="tooltip">Enter how many unique visitors are expected per day.</span>
  </label>
  <input type="number" id="unique-visitors" name="unique_visitors" min="1"value="0"  placeholder="Ex: 1000 daily"
    style="width: 100%; padding: 10px; border-radius: 10px; border: 1.8px solid #c5cae9; background-color: #f5f7ff;">
  <div id="unique-visitors-error" class="error-msg" style="display: none; color: red; margin-top: 4px;">
    Please enter a valid number of visitors.
  </div>
</div>

        <div class="form-group" style="grid-column: span 1;">
            <label for="bounce-rate">Bounce Rate (%): <span id="bounce-rate-display">50</span>%
            <span class="info-icon" tabindex="0">ℹ️
            <span class="tooltip"> Presentage of visitro's who viewing one page </span>
            
            </label>
            <input type="range" id="bounce-rate" name="bounce_rate" min="0" max="100" value="50" step="1" />
        </div>

        <div class="form-group" style="grid-column: span 1;">
  <label>Devices:
  <span class="info-icon" tabindex="0">ℹ️
      <span class="tooltip">Choose which devices to target</span>
  
  
  </label>
  <div style="display:flex; gap:12px; flex-wrap: wrap; align-items: center;">
    <button type="button" class="device-tab active" data-device="desktop" title="Only desktop visitors">
      🖥️ Desktop
      <span class="info-icon" tabindex="0">ℹ️
        <span class="tooltip">Only desktop visitors</span>
      </span>
    </button>

    <button type="button" class="device-tab" data-device="mobile" title="Only mobile visitors">
      📱 Mobile
      <span class="info-icon" tabindex="0">ℹ️
        <span class="tooltip">Only mobile visitors</span>
      </span>
    </button>

    <button type="button" class="device-tab" data-device="tablet" title="Only tablet visitors">
      📲 Tablet
      <span class="info-icon" tabindex="0">ℹ️
        <span class="tooltip">Only tablet visitors</span>
      </span>
    </button>

    <button type="button" class="device-tab" data-device="random" title="Random device visitors">
      🎲 Random
      <span class="info-icon" tabindex="0">ℹ️
        <span class="tooltip">Random device visitors</span>
      </span>
    </button>

    <button type="button" class="device-tab" data-device="realistic" title="Realistic device visitors">
      🤖 Realistic
      <span class="info-icon" tabindex="0">ℹ️
        <span class="tooltip">About 20% Destop 80% Mobile</span>
      </span>
    </button>
  </div>
  <input type="hidden" name="device" id="device" value="desktop" />
</div>


    <div class="form-group" style="grid-column: span 1;" >
  <label for="geo-targeting" style="display: flex; align-items: center; gap: 8px;"   >
    
    Geo Targeting:
    
    <span class="info-icon" tabindex="0">ℹ️
      <span class="tooltip">Select target Country 100 % Residential IPs</span>
    </span>
  </label>
  <small style="color:#ff0000;">Please select at least one country.</small>

  <select id="geo-targeting" name="geo_targeting[]" multiple
    style="width: 100%; height: 250px; font-size: 14px; line-height: 1.5; padding: 4px;">
      <option value="ALLcountry"selected>All-Country</option>
      
      selected
    <option value="AF">Afghanistan</option>
    <option value="AL">Albania</option>
    <option value="DZ">Algeria</option>
    <option value="AD">Andorra</option>
    <option value="AO">Angola</option>
    <option value="AR">Argentina</option>
    <option value="AM">Armenia</option>
    <option value="AU">Australia</option>
    <option value="AT">Austria</option>
    <option value="AZ">Azerbaijan</option>
    <option value="BH">Bahrain</option>
    <option value="BD">Bangladesh</option>
    <option value="BY">Belarus</option>
    <option value="BE">Belgium</option>
    <option value="BT">Bhutan</option>
    <option value="BO">Bolivia</option>
    <option value="BA">Bosnia and Herzegovina</option>
    <option value="BR">Brazil</option>
    <option value="BG">Bulgaria</option>
    <option value="KH">Cambodia</option>
    <option value="CM">Cameroon</option>
    <option value="CA">Canada</option>
    <option value="CL">Chile</option>
    <option value="CN">China</option>
    <option value="CO">Colombia</option>
    <option value="CR">Costa Rica</option>
    <option value="HR">Croatia</option>
    <option value="CU">Cuba</option>
    <option value="CY">Cyprus</option>
    <option value="CZ">Czech Republic</option>
    <option value="DK">Denmark</option>
    <option value="DO">Dominican Republic</option>
    <option value="EC">Ecuador</option>
    <option value="EG">Egypt</option>
    <option value="SV">El Salvador</option>
    <option value="EE">Estonia</option>
    <option value="ET">Ethiopia</option>
    <option value="FI">Finland</option>
    <option value="FR">France</option>
    <option value="DE">Germany</option>
    <option value="GH">Ghana</option>
    <option value="GR">Greece</option>
    <option value="HK">Hong Kong</option>
    <option value="HU">Hungary</option>
    <option value="IS">Iceland</option>
    <option value="IN">India</option>
    <option value="ID">Indonesia</option>
    <option value="IR">Iran</option>
    <option value="IQ">Iraq</option>
    <option value="IE">Ireland</option>
    <option value="IL">Israel</option>
    <option value="IT">Italy</option>
    <option value="JP">Japan</option>
    <option value="JO">Jordan</option>
    <option value="KZ">Kazakhstan</option>
    <option value="KE">Kenya</option>
    <option value="KR">Korea, South</option>
    <option value="KW">Kuwait</option>
    <option value="LV">Latvia</option>
    <option value="LB">Lebanon</option>
    <option value="LT">Lithuania</option>
    <option value="LU">Luxembourg</option>
    <option value="MY">Malaysia</option>
    <option value="MV">Maldives</option>
    <option value="MT">Malta</option>
    <option value="MX">Mexico</option>
    <option value="MD">Moldova</option>
    <option value="MC">Monaco</option>
    <option value="MN">Mongolia</option>
    <option value="MA">Morocco</option>
    <option value="NP">Nepal</option>
    <option value="NL">Netherlands</option>
    <option value="NZ">New Zealand</option>
    <option value="NG">Nigeria</option>
    <option value="NO">Norway</option>
    <option value="OM">Oman</option>
    <option value="PK">Pakistan</option>
    <option value="PA">Panama</option>
    <option value="PE">Peru</option>
    <option value="PH">Philippines</option>
    <option value="PL">Poland</option>
    <option value="PT">Portugal</option>
    <option value="QA">Qatar</option>
    <option value="RO">Romania</option>
    <option value="RU">Russia</option>
    <option value="SA">Saudi Arabia</option>
    <option value="RS">Serbia</option>
    <option value="SG">Singapore</option>
    <option value="SK">Slovakia</option>
    <option value="SI">Slovenia</option>
    <option value="ZA">South Africa</option>
    <option value="ES">Spain</option>
    <option value="LK">Sri Lanka</option>
    <option value="SE">Sweden</option>
    <option value="CH">Switzerland</option>
    <option value="TW">Taiwan</option>
    <option value="TH">Thailand</option>
    <option value="TR">Turkey</option>
    <option value="UA">Ukraine</option>
    <option value="AE">United Arab Emirates</option>
    <option value="GB">United Kingdom</option>
    <option value="US">United States</option>
    <option value="VN">Vietnam</option>
    <option value="ZW">Zimbabwe</option>
  </select>
  <div id="geo-targeting-error" class="error-msg">Please select at least one country.</div>

 
  <small style="color:#666;">(Hold CTRL/Command to select multiple)</small>
</div>



        <div style="grid-column: 1 / -1; display:flex; justify-content:flex-end; gap:14px; margin-top:28px;">
            <button id="step2-prev" class="btn-secondary" type="button">Previous</button>
            <button id="next2-btn" class="btn-primary" type="button">Next
            

           
           
           
           
           
        


            
           
            </button>
        </div>
    </form>
    
    <script>
        
};

function debounce(fn, delay) {
    let timer;
    return function(...args) {
        clearTimeout(timer);
        timer = setTimeout(() => fn.apply(this, args), delay);
    };
}

// Capture Step2 values
function autoSaveStep2() {
    const campid    = document.getElementById('campid')?.value || '';
    const actionid  = document.getElementById('actionid')?.value || '';
    const userid    = document.getElementById('userid')?.value || '';

    const uniqueVisitors = document.getElementById('unique-visitors')?.value || '';
    const bounceRate     = document.getElementById('bounce-rate')?.value || '';

    // devices (plain text + JSON)
    const devicesEls = document.querySelectorAll('.device-tab.active');
    let devices = [];
    devicesEls.forEach(el => devices.push(el.dataset.value));
    const devicesStr  = devices.join(',');
    const devicesJson = JSON.stringify(devices);

    // geo (plain + JSON)
    const geoEls = document.querySelectorAll('.selected-country');
    let geo = [];
    geoEls.forEach(el => geo.push(el.dataset.value));
    const geoStr  = geo.join(',');
    const geoJson = JSON.stringify(geo);

    fetch('autosave_step2.php', {
        method: 'POST',
        headers: { 'Content-Type':'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            campid, actionid, userid,
            uniqueVisitors,
            bounceRate,
            devices: devicesStr,
            devicesjosn: devicesJson,
            geo: geoStr,
            geojason: geoJson
        })
    })
    .then(res => res.json())
    .then(data => {
        console.log("Step2 Autosave:", data);
    });
}

// Attach autosave events only to Step 2 inputs
document.getElementById('unique-visitors')?.addEventListener('input', debounce(autoSaveStep2, 400));
document.getElementById('bounce-rate')?.addEventListener('input', debounce(autoSaveStep2, 400));

// device tab clicks
document.querySelectorAll('.device-tab').forEach(btn => {
    btn.addEventListener('click', () => {
        btn.classList.toggle('active'); 
        autoSaveStep2();
    });
});
  
        
        
        
    </script>
    
    
    
    
    
    
</div>

<div id="step3-container" style="display:none;">
    

    
    <form id="step3-container" method="POST" action="save_step1_data.php" style="display: grid; grid-template-columns: 1fr 1fr; gap: 28px;">



    
  
       
   <style>
@keyframes blink {
  0%, 50%, 100% { opacity: 1; }
  25%, 75% { opacity: 0; }
}

@keyframes moveArrow {
  0% { transform: translateX(0); }
  50% { transform: translateX(10px); }
  100% { transform: translateX(0); }
}

.blinking-text {
  animation: blink 1s infinite;
  color: darkred;      /* Dark red color */
     /* Bold text */
}

.moving-arrow {
  display: inline-block;
  margin-left: 8px;
  animation: moveArrow 1s infinite;
}
</style>

<h2 style="font-family: Arial, sans-serif; display: flex; align-items: center; gap: 10px; color:#333;">
    <img src="https://img.icons8.com/ios-filled/24/007BFF/megaphone.png" alt="Ad Icon" style="width:24px; height:24px;">
    <span class="blinking-text">Your Ad Preview</span>
    <span class="moving-arrow">👉</span>
</h2>





<table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
    <tr style="background-color: #f5f5f5;">
        <th style="padding: 8px; border: 1px solid #ddd; text-align: left;">Field</th>
        <th style="padding: 8px; border: 1px solid #ddd; text-align: left;">Value</th>
    </tr>
    
    
    <tr>
        <td>Campain name</td>
  <td>
    <span id="view_step3_campaign_name"></span>
    <input type="text" id="step3_campaign_name" name="campaign_name" readonly>
  </td>
    </tr>
    
    
    <tr>
        <td>Website</td>
  <td>
    <span id="view_step3_website"></span>
    <input type="text" id="step3_website" name="website" readonly>
  </td>
    </tr>
    <tr>
        <td>Product Name</td>
  <td>
    <span id="view_step3_product"></span>
    <input type="text" id="step3_product" name="product" readonly>
  </td>
    </tr>
    <tr>
        <td>Language</td>
        <td>
    <span id="view_step3_language"></span>
    <input type="text" id="step3_language" name="language" readonly>
  </td>
    </tr>
    <tr>
        <td>Platform</td>
        <td>
    <span id="view_step3_platform"></span>
    <input type="text" id="step3_platform" name="platform" readonly>
  </td>
    </tr>
    <tr>
        <tr>
        <td>Platform-Links</td>
        <td>
    
    
    <span id="view_step3_platform_links"></span>
        <textarea id="step3_platform_links" name="platlinks" rows="3" readonly style="width:100%; resize: vertical;"></textarea>
    
    

  </td>
    </tr>
    <tr>
        
        
        
        <td>Unique Visitors</td>
        <td>
    <span id="view_step3_unique_visitors"></span>
    <input type="text" id="step3_unique_visitors" name="unique_visitors" readonly  >
  </td>
    </tr>
    <tr>
        <td>Bounce Rate</td>
        <td>
    <span id="view_step3_bounce_rate"></span>
    <input type="text" id="step3_bounce_rate" name="bounce_rate" readonly>
  </td>
    </tr>
    <tr>
        <td>Device</td>
        <td>
    <span id="view_step3_device"></span>
    <input type="text" id="step3_device" name="device" readonly>
  </td>
    </tr>
    <tr>
        <td>Geo Targeting</td>
        <td>
    <span id="view_step3_geo_targeting"></span>
        <textarea id="step3_geo_targeting" name="geo_targeting" rows="3" readonly style="width:100%; resize: vertical;"></textarea>

  </td>
    </tr>
</table>  

<input type="hidden" id="step3_campaign_names" name="campaign_names"
<input type="hidden" id="step3_websites" name="websites">
<input type="hidden" id="step3_products" name="products">
<input type="hidden" id="step3_languages" name="languages">
<input type="hidden" id="step3_platforms" name="platforms">
<input type="hidden" id="step3_platlinkss" name="platlinkss">
<input type="hidden" id="step3_unique_visitorss" name="unique_visitorss">
<input type="hidden" id="step3_bounce_rates" name="bounce_rates">
<input type="hidden" id="step3_devicess" name="devicess">
<input type="hidden" id="step3_geo_targetings" name="geo_targetings">
       
      
       
    <div class="form-group" style="grid-column: span 2;">
  <label style="font-weight: bold; display: flex; align-items: center; gap: 8px;">
    <input type="checkbox" id="traffic-schedule-checkbox">
    Arrange Traffic Schedule ?
    <span class="info-icon" tabindex="0">ℹ️
      <span class="tooltip">You can setup the Campaign Start date & End date</span>
    </span>
  </label>

  <div id="traffic-schedule-dates" style="margin-top: 10px; display: none; grid-column: span 2;">
    <div style="margin-bottom: 8px;">
      <label for="start-date">Start Date:</label>
      <input 
        type="date" 
        id="start_date" 
        name="start_date" 
        value="<?php echo date('Y-m-d'); ?>" 
        min="<?php echo date('Y-m-d'); ?>">
    </div>
    <div>
      <label for="end-date">End Date:</label>
      <input 
        type="date" 
        id="end_date" 
        name="end_date" 
        value="<?php echo date('Y-m-d'); ?>" 
        min="<?php echo date('Y-m-d'); ?>">
    </div>
  </div>
</div>

<script>
  document.getElementById('start_date').addEventListener('change', function() {
    let startDate = new Date(this.value);
    let endDateInput = document.getElementById('end_date');

    // End date must be at least 1 day after start date
    startDate.setDate(startDate.getDate() + 1);
    let minEndDate = startDate.toISOString().split('T')[0];

    endDateInput.min = minEndDate;

    // If current end date is less than new min, reset it
    if (endDateInput.value < minEndDate) {
      endDateInput.value = minEndDate;
    }
  });
</script>



       
       
        <div class="form-group" style="margin: 10px 0;">
    <label style="display: flex; align-items: center; gap: 8px;">
        <input type="checkbox" id="agree_terms" name="agree_terms" required>
        I have read and agree to the 
        <a href="termsandcondition.html" target="_blank" style="margin-left: 4px; color: blue; text-decoration: underline;">
            Terms and Conditions
        </a>
    </label>
</div>


    



<script>
document.getElementById('traffic-schedule-checkbox').addEventListener('change', function() {
    const dateFields = document.getElementById('traffic-schedule-dates');
    dateFields.style.display = this.checked ? 'block' : 'none';
    const scheduleDates = document.getElementById('traffic-schedule-dates');
    scheduleDates.style.display = this.checked ? 'block' : 'none';
});
</script>

       
    
    <script>
// Function to copy values from visible inputs to hidden ones
function syncStep3Values() {
    document.getElementById("step3_campaign_name_hidden").value = document.getElementById("step3_campaign_name").value;
    document.getElementById("step3_website_hidden").value       = document.getElementById("step3_website").value;
    document.getElementById("step3_product_hidden").value       = document.getElementById("step3_product").value;
    document.getElementById("step3_language_hidden").value      = document.getElementById("step3_language").value;
    document.getElementById("step3_platform_hidden").value      = document.getElementById("step3_platform").value;
    document.getElementById("step3_platform_links_hidden").value= document.getElementById("step3_platform_links").value;
    document.getElementById("step3_unique_visitors_hidden").value= document.getElementById("step3_unique_visitors").value;
    document.getElementById("step3_bounce_rate_hidden").value   = document.getElementById("step3_bounce_rate").value;
    document.getElementById("step3_device_hidden").value        = document.getElementById("step3_device").value;
    document.getElementById("step3_geo_targeting_hidden").value = document.getElementById("step3_geo_targeting").value;
}

// Attach to form submit
document.addEventListener("DOMContentLoaded", function() {
    let form = document.querySelector("form"); // replace with your form id if needed
    if(form){
        form.addEventListener("submit", function() {
            syncStep3Values();
        });
    }
});
</script>

    
    
    
    
        <!-- Inside <form id="step3-container"> -->
<!--<input type="hidden" id="step3_campaign_name" name="campaign_name"



<!-- New ones -->
<input type="hidden" id="step3_campaign_name_hiddens" name="campaign_names">
<input type="hidden" id="step3_website_hiddesn" name="websites">
<input type="hidden" id="step3_product_hiddens" name="productss">
<input type="hidden" id="step3_language_hiddens" name="languages">
<input type="hidden" id="step3_platform_hiddens" name="platforms">
<input type="hidden" id="step3_platform_platlinkss" name="platlinkss">
<input type="hidden" id="step3_unique_visitors_hiddens" name="unique_visitorss">
<input type="hidden" id="step3_bounce_rate_hiddens" name="bounce_rates">
<input type="hidden" id="step3_devices_hiddens" name="devices">
<input type="hidden" id="step3_geo_targeting_hiddens" name="geo_targetings"> 


<input type="hidden" id="step3_platlinkss" name="platlinkss">

<input type="hidden" name="user_id" value="<?= $_SESSION['user_id'] ?>">

       





  <div style="margin:20px 0;">
    <button type="button" id="generate-ai" class="btn-primary">Generate AI Suggestions</button>
</div>
</div> 
        
<div id="ai-results" style="display:none; margin-top:20px;">
   <h3 style="text-align:center;">AI Suggestions</h3>
    <table border="1" cellpadding="8" style="border-collapse:collapse; width:100%; background:#fff;">
        <thead style="background:#f4f4f4;">
            <tr>
                <th>Metric</th>
                <th>Value</th>
                <th>Metric</th>
                <th>Value</th>
            </tr>
        </thead>
        <tbody id="ai-results-body"></tbody>
    </table>
</div>



    
    
    <div style="grid-column: 1 / -1; display:flex; justify-content:flex-end; gap:14px; margin-top:28px;">
            <button id="step3-prev" class="btn-secondary" type="button">Previous</button>
            <button id="" class="btn-primary" type="submit">Start Campaign
            
            
         
    <script>
</script>
    
    
</div




<!-- Modal -->
<div id="limitModal" class="modal" style="display:none;">
  <div class="modal-content">
    <span class="close">&times;</span>
    <h3>Package Limit Exceeded</h3>
    <p id="modal-message">You have exceeded your package limit. Please upgrade your package.</p>
    <button id="upgrade-btn" class="btn-primary">Upgrade Package</button>
  </div>
</div>








<script>
document.getElementById('generate-ai').addEventListener('click', function() {
    const website = document.getElementById('step3_website').value || '';
    if (!website) { alert('Website URL is missing.'); return; }

    const resultsDiv = document.getElementById('ai-results'); 
    const tbody = document.getElementById('ai-results-body');
    resultsDiv.style.display = 'none';
    tbody.innerHTML = `<tr><td colspan="4" style="text-align:center;">Loading...</td></tr>`;

    // Check API limit first
    fetch('check_api_limit.php')
    .then(res => res.json())
    .then(limitData => {
        if (limitData.status === 'exceeded') {
            // Show modal instead of alert
            document.getElementById('modal-message').innerText = limitData.message;
            document.getElementById('limitModal').style.display = 'block';
            resultsDiv.style.display = 'none'; // keep table hidden
            return; // stop further execution
        }

        // Only run AI API fetch if limit is OK
        resultsDiv.style.display = 'block';
        fetch(`https://seo-traffic-authority.p.rapidapi.com/url-metrics?url=${encodeURIComponent(website)}`, {
            method: 'GET',
            headers: {
                'x-rapidapi-host': 'seo-traffic-authority.p.rapidapi.com',
                'x-rapidapi-key': 'b2c3068295msh01cbe5f76a46a69p1b3c47jsna4af4654b449'
            }
        })
        .then(res => res.json())
        .then(res => {
            tbody.innerHTML = '';

            const fields = [
                { label: 'Page Backlinks', value: res.data.page.backlinks, icon: '🔗', advice: 'Consider improving your backlinks with our plan.' },
                { label: 'Page Referring Domains', value: res.data.page.refDomains, icon: '🌐', advice: 'More referring domains will boost authority.' },
                { label: 'Page Organic Keywords', value: res.data.page.organicKeywords, icon: '🔑', advice: 'Optimize content for more keywords.' },
                { label: 'URL Rating', value: res.data.page.urlRating, icon: '⭐', advice: 'A low rating suggests strengthening page SEO.' },
                { label: 'Words on Page', value: res.data.page.numberOfWordsOnPage, icon: '📝', advice: 'More quality content improves ranking.' },
                { label: 'Domain Rating', value: res.data.domain.domainRating, icon: '🏆', advice: 'Improve domain authority for better results.' },
                { label: 'Domain Rank', value: res.data.domain.domainRank, icon: '🎯', advice: 'Lower rank? Consider our growth strategies.' },
                { label: 'Domain Backlinks', value: res.data.domain.backlinks, icon: '🔗', advice: 'Increase backlinks for stronger domain.' },
                { label: 'Domain Traffic', value: res.data.domain.traffic, icon: '📈', advice: 'Traffic is low, You can improve it doing more Campaigns.' }
            ];

            for (let i = 0; i < fields.length; i += 2) {
                let row = '<tr>';
                let color1 = fields[i].value > 50 ? 'green' : fields[i].value > 10 ? 'orange' : 'red';
                let msg1 = fields[i].value <= 10 ? ` (${fields[i].advice})` : '';
                row += `<td>${fields[i].icon} ${fields[i].label}</td><td style="color:${color1}; font-weight:bold;">${fields[i].value}${msg1}</td>`;
                if (fields[i+1]) {
                    let color2 = fields[i+1].value > 50 ? 'green' : fields[i+1].value > 10 ? 'orange' : 'red';
                    let msg2 = fields[i+1].value <= 10 ? ` (${fields[i+1].advice})` : '';
                    row += `<td>${fields[i+1].icon} ${fields[i+1].label}</td><td style="color:${color2}; font-weight:bold;">${fields[i+1].value}${msg2}</td>`;
                } else {
                    row += `<td></td><td></td>`;
                }
                row += '</tr>';
                tbody.innerHTML += row;
            }
        })
        .catch(err => {
            tbody.innerHTML = `<tr><td colspan="4" style="color:red;">Error: ${err.message}</td></tr>`;
        });

    })
    .catch(err => {
        alert('Error checking API limit: ' + err.message);
    });
});

// Modal close logic
document.querySelector('.modal .close').onclick = function() {
    document.getElementById('limitModal').style.display = 'none';
}
window.onclick = function(event) {
    if (event.target == document.getElementById('limitModal')) document.getElementById('limitModal').style.display = 'none';
}
document.getElementById('upgrade-btn').onclick = function() {
    window.open('upgrade_package.php', '_blank'); // open in new tab
};


</script>








<!-- Confirmation Modal -->
<div id="confirm-modal" role="dialog" aria-modal="true" aria-labelledby="modal-title" aria-describedby="modal-desc">
  <div class="modal-content">
    <p id="modal-desc">
      Are you sure you want to create this campaign? <br>
      Please verify all details before confirming.
    </p>
    <div class="modal-buttons">
      <button class="btn-ok" id="modal-ok-btn">Yes, create it</button>
      <button class="btn-cancel" id="modal-cancel-btn">Cancel</button>
    </div>
  </div>
</div>

<!-- Loading Overlay -->
<div id="loading-overlay" aria-live="assertive" aria-busy="true" style="display:none; flex-direction: column; align-items:center; justify-content:center;">
  <div class="loader" role="progressbar" aria-label="Loading"></div>
  <div>Our AI agent will analyze your data, please hold for a moment...</div>
</div>

<script>
  // Platform tab behavior
  const platformTabs = document.querySelectorAll('.platform-tab');
  const platformInput = document.getElementById('platform');
  const platformLinksContainer = document.getElementById('platform-links-container');
  const platformLinksTextarea = document.getElementById('platform-links');
  const platformLinksLabel = document.getElementById('platform-links-label');
  const platformLinksError = document.getElementById('platform-links-error');

  platformTabs.forEach(tab => {
    tab.addEventListener('click', () => {
      platformTabs.forEach(t => t.classList.remove('active'));
      tab.classList.add('active');
      platformInput.value = tab.getAttribute('data-value');

      // Show/hide textarea based on platform
      if (['Referral', 'Social', 'Organic'].includes(platformInput.value)) {
        platformLinksContainer.style.display = 'block';
        if (platformInput.value === 'Referral') {
        platformLinksLabel.innerHTML = 'Referral links (one per line): ' +
          '<span class="info-icon" tabindex="0">ℹ️' +
          '<span class="tooltip">Enter one referral link per line<br> Ex-https://yourdomain.com</span>' +
          '</span>';
        platformLinksTextarea.placeholder = 'Enter referral links one per line ';
        } else if (platformInput.value === 'Social') {
        platformLinksLabel.innerHTML = 'Social links (one per line): ' +
          '<span class="info-icon" tabindex="0">ℹ️' +
          '<span class="tooltip">Enter one social link per line <br> Ex-https://yourdomain.com</span>' +
          '</span>';
          
          platformLinksTextarea.placeholder = 'Enter social links one per line ';
        } else {
          {
        platformLinksLabel.innerHTML = 'Enter Your Keywords (one per line): ' +
          '<span class="info-icon" tabindex="0">ℹ️' +
          '<span class="tooltip">All Major Search Engines Supported Ex-Google,Yahoo,Bing</span>' +
          '</span>';
        platformLinksTextarea.placeholder = 'Enter one entry per line';
    }
        }
      } else {
        platformLinksContainer.style.display = 'none';
        platformLinksError.style.display = 'none';
        platformLinksTextarea.classList.remove('error');
      }
    });
  });

  // Device tab behavior
  const deviceTabs = document.querySelectorAll('.device-tab');
  const deviceInput = document.getElementById('device');

  deviceTabs.forEach(tab => {
    tab.addEventListener('click', () => {
      deviceTabs.forEach(t => t.classList.remove('active'));
      tab.classList.add('active');
      deviceInput.value = tab.getAttribute('data-device');
    });
  });

  // Bounce rate slider display update
  const bounceRateSlider = document.getElementById('bounce-rate');
  const bounceRateDisplay = document.getElementById('bounce-rate-display');

  bounceRateSlider.addEventListener('input', () => {
    bounceRateDisplay.textContent = bounceRateSlider.value;
  });

  // Geo targeting multi-select simulation (basic)
  const geoInput = document.getElementById('geo-targeting');
  const geoSelected = document.getElementById('geo-selected');
  let selectedCountries = [];

  geoInput.addEventListener('keydown', e => {
    if (e.key === 'Enter') {
      e.preventDefault();
      let country = geoInput.value.trim();
      if (country && !selectedCountries.includes(country)) {
        selectedCountries.push(country);
        updateGeoSelected();
        geoInput.value = '';
      }
    }
  });
  
  
  
  
  
  
  
  

  function updateGeoSelected() {
    geoSelected.innerHTML = '';
    selectedCountries.forEach(country => {
      const span = document.createElement('span');
      span.textContent = country + ' ×';
      span.style.marginRight = '6px';
      span.style.padding = '3px 8px';
      span.style.backgroundColor = '#3949ab';
      span.style.color = '#fff';
      span.style.borderRadius = '10px';
      span.style.cursor = 'pointer';
      span.addEventListener('click', () => {
        selectedCountries = selectedCountries.filter(c => c !== country);
        updateGeoSelected();
      });
      geoSelected.appendChild(span);
    });
  }

  // Form validation
  function validateForm() {
    let isValid = true;

    // Campaign Name
    const campaignName = document.getElementById('campaign_name');
    const campaignNameError = document.getElementById('campaign_name-error');
    if (campaignName.value.trim() === '') {
      campaignNameError.style.display = 'block';
      campaignName.classList.add('error');
      isValid = false;
    } else {
      campaignNameError.style.display = 'none';
      campaignName.classList.remove('error');
    }

    // Website URL
    const website = document.getElementById('website');
    const websiteError = document.getElementById('website-error');
    const websitePattern = /^(https?:\/\/)?([\w-]+(\.[\w-]+)+)(\/[\w-./?%&=]*)?$/i;
    if (!websitePattern.test(website.value.trim())) {
      websiteError.style.display = 'block';
      website.classList.add('error');
      isValid = false;
    } else {
      websiteError.style.display = 'none';
      website.classList.remove('error');
    }

    // Product Name
    const product = document.getElementById('product');
    const productError = document.getElementById('product-error');
    if (product.value.trim() === '') {
      productError.style.display = 'block';
      product.classList.add('error');
      isValid = false;
    } else {
      productError.style.display = 'none';
      product.classList.remove('error');
    }
    
    
    
    
    
    
    
    

    // Platform links validation if textarea shown
    if (platformLinksContainer.style.display === 'block') {
      const lines = platformLinksTextarea.value.trim().split('\n').filter(line => line.trim() !== '');
      if (lines.length === 0) {
        platformLinksError.style.display = 'block';
        platformLinksTextarea.classList.add('error');
        isValid = false;
      } else {
        platformLinksError.style.display = 'none';
        platformLinksTextarea.classList.remove('error');
      }
    }

    return isValid;
  }
  
  // Geo Targeting Validation
const geoTargeting = document.getElementById('geo-targeting');
let geoError = document.getElementById('geo-targeting-error');

// Create error div if it doesn't exist
if (!geoError) {
    geoError = document.createElement('div');
    geoError.id = 'geo-targeting-error';
    geoError.className = 'error-msg';
    geoError.textContent = 'Please select at least one country.';
    geoTargeting.parentNode.appendChild(geoError);
}

if (geoTargeting.selectedOptions.length === 0) {
    geoError.style.display = 'block';
    geoTargeting.classList.add('error');
    isValid = false;
} else {
    geoError.style.display = 'none';
    geoTargeting.classList.remove('error');
}

  
  
  

  // Modal and loading overlay
  const modal = document.getElementById('confirm-modal');
  const modalOkBtn = document.getElementById('modal-ok-btn');
  const modalCancelBtn = document.getElementById('modal-cancel-btn');
  const loadingOverlay = document.getElementById('loading-overlay');

  function showModal() {
    modal.classList.add('active');
  }

  function hideModal() {
    modal.classList.remove('active');
  }

  modalCancelBtn.addEventListener('click', () => {
    hideModal();
  });

  modalOkBtn.addEventListener('click', () => {
    hideModal();
    loadingOverlay.style.display = 'flex';
    // Submit the form after showing loading overlay
    document.getElementById('campaign-form').submit();
  });

  // Override form submit - we handle submit in step 2 now
  function onFormSubmit(event) {
    // This will be prevented to show step 2 instead
    event.preventDefault();
    return false;
  }

  // Step 1 Next button shows step 2 instead of submitting
  // Step 1 Next button shows step 2 instead of submitting
const step1NextBtn = document.getElementById('next-btn');
const step2Container = document.getElementById('step2-container');
const campaignForm = document.getElementById('campaign-form');
const step2PrevBtn = document.getElementById('step2-prev');
// const step2SubmitBtn = document.getElementById('step2-submit');

const step2NextBtn = document.getElementById('next2-btn');
const step3Container = document.getElementById('step3-container');
const campaign2Form = document.getElementById('step2-form');
const step3PrevBtn = document.getElementById('step3-prev');

// Step 1 → Step 2
step1NextBtn.addEventListener('click', (e) => {
    e.preventDefault();
    if (!validateForm()) return;

    campaignForm.style.display = 'none';
    step2Container.style.display = 'block';
    step2Container.scrollIntoView({ behavior: 'smooth' });
});

// Step 2 → Step 1
step2PrevBtn.addEventListener('click', () => {
    campaignForm.style.display = 'grid';
    step2Container.style.display = 'none';
    campaignForm.scrollIntoView({ behavior: 'smooth' });
});

// Step 2 → Step 3
step2NextBtn.addEventListener('click', (e) => {
    e.preventDefault();
    if (!validateForm()) return;

   document.getElementById('step3_campaign_name').value = document.getElementById('campaign_name').value;
    document.getElementById('step3_website').value = document.getElementById('website').value;
    document.getElementById('step3_product').value = document.getElementById('product').value;
    document.getElementById('step3_language').value = document.getElementById('language').value;
    document.getElementById('step3_platform').value = document.getElementById('platform').value;
    document.getElementById('step3_platform_links').value = document.getElementById('platform-links').value;

    // copy Step 2 values
    document.getElementById('step3_unique_visitors').value = document.getElementById('unique-visitors').value;
    document.getElementById('step3_bounce_rate').value = document.getElementById('bounce-rate').value;
    document.getElementById('step3_device').value = document.getElementById('device').value;

    // copy geo-targeting
    const geoSelect = document.getElementById('geo-targeting');
    const selectedCountries = Array.from(geoSelect.selectedOptions).map(option => option.value);
    document.getElementById('step3_geo_targeting').value = selectedCountries.join(',');

    // show Step 3
    campaign2Form.style.display = 'none';
    step3Container.style.display = 'block';
    step3Container.scrollIntoView({ behavior: 'smooth' });
});
  
  // Step 3 → Step 2
step3PrevBtn.addEventListener('click', () => {
    // Show Step 2 form again
    campaign2Form.style.display = 'grid'; // Step 2 form
    step2Container.style.display = 'block'; // Step 2 container

    // Hide Step 3 container
    step3Container.style.display = 'none';

    // Scroll to Step 2
    step2Container.scrollIntoView({ behavior: 'smooth' });
});

  

 // step2SubmitBtn.addEventListener('click', (e) => {
    //e.preventDefault();
   // showModal();
  //});
</script>



<script>
    // Devices tab toggle
    const deviceTabs = document.querySelectorAll('.device-tab');
    const deviceInput = document.getElementById('device');

    deviceTabs.forEach(tab => {
        tab.addEventListener('click', () => {
            deviceTabs.forEach(t => t.classList.remove('active'));
            tab.classList.add('active');
            deviceInput.value = tab.getAttribute('data-device');
        });
    });

    // Bounce rate slider update
    const bounceRateSlider = document.getElementById('bounce-rate');
    const bounceRateDisplay = document.getElementById('bounce-rate-display');
    bounceRateSlider.addEventListener('input', () => {
        bounceRateDisplay.textContent = bounceRateSlider.value;
    });

    // Countries list with flags
    const geoSelect = document.getElementById('geo-targeting');
    const countries = [
        { code: 'US', name: 'United States', flag: '🇺🇸' },
        { code: 'GB', name: 'United Kingdom', flag: '🇬🇧' },
        { code: 'DE', name: 'Germany', flag: '🇩🇪' },
        { code: 'FR', name: 'France', flag: '🇫🇷' },
        { code: 'LK', name: 'Sri Lanka', flag: '🇱🇰' },
        { code: 'ES', name: 'Spain', flag: '🇪🇸' },
        { code: 'IN', name: 'India', flag: '🇮🇳' },
        { code: 'CA', name: 'Canada', flag: '🇨🇦' },
        // Add more countries if needed
    ];

    countries.forEach(country => {
        const option = document.createElement('option');
        option.value = country.code;
        option.textContent = `${country.flag} ${country.name}`;
        geoSelect.appendChild(option);
    });

    // Navigation buttons (assumes step1-container exists)
    const step1Container = document.getElementById('step1-container');
const step2Container = document.getElementById('step2-container');
const step3Container = document.getElementById('step3-container');

const step2PrevBtn = document.getElementById('step2-prev');
const step2NextBtn = document.getElementById('next-to-step3');
const step3PrevBtn = document.getElementById('step3-prev'); // optional if you have a back button in step 3

// Step 1 → Step 2
document.getElementById('next-step1').addEventListener('click', () => {
    step1Container.style.display = 'none';
    step2Container.style.display = 'block';
    window.scrollTo({ top: 0, behavior: 'smooth' });
});

// Step 2 → Step 1
step2PrevBtn.addEventListener('click', () => {
    step2Container.style.display = 'none';
    step1Container.style.display = 'block';
    window.scrollTo({ top: 0, behavior: 'smooth' });
});

// Step 2 → Step 3
step2NextBtn.addEventListener('click', () => {
    // Optionally: save data here before going to Step 3
    // alert('Saving Step 2 data...');
    
    step2Container.style.display = 'none';
    step3Container.style.display = 'block';
    window.scrollTo({ top: 0, behavior: 'smooth' });
});

// Step 3 → Step 2
if (step3PrevBtn) {
    step3PrevBtn.addEventListener('click', () => {
        step3Container.style.display = 'none';
        step2Container.style.display = 'block';
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });
}

</script>









<?php include 'templates/footer.php'; ?>
