<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'templates/header.php';
?>

<style>
  /* Global & layout */
  *, *::before, *::after { box-sizing: border-box; }
  body, html {
    margin: 0; padding: 0; overflow-x: hidden; width: 100vw; height: 100vh;
    font-family: Arial, sans-serif;
  }
  .main-wrapper {
    display: flex;
    height: 100vh;
    overflow-x: hidden;
  }
  .sidebar {
    width: 250px;
    background-color: #343a40;
    padding: 20px 0;
    color: #fff;
    flex-shrink: 0;
  }
  .sidebar a {
    display: block;
    padding: 12px 20px;
    color: #fff;
    text-decoration: none;
  }
  .sidebar a:hover,
  .sidebar a.active {
    background-color: #495057;
  }
  .main-content {
    flex-grow: 1;
    padding: 30px 25px;
    background-color: #f8f9fa;
    overflow-y: auto;
    overflow-x: hidden;
    height: 100vh;
  }
  h1 {
    font-weight: bold;
    color: #000;
    margin-bottom: 10px;
    font-size: 26px;
  }

  /* Notification bulb */
  .notification {
    font-size: 14px;
    margin-bottom: 20px;
    background-color: #fff3cd;
    color: #856404;
    border-left: 6px solid #ffc107;
    padding: 10px 16px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    gap: 8px;
  }

  /* Tabs */
  .tabs {
    display: flex;
    gap: 10px;
    margin-bottom: 20px;
    flex-wrap: wrap;
  }
  .tab {
    cursor: pointer;
    padding: 10px 16px;
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: 600;
    user-select: none;
    transition: background-color 0.25s ease;
    color: #333;
  }
  .tab:hover {
    background-color: #e2e6ea;
  }
  .tab.active {
    background-color: #007bff;
    color: white;
  }
  .tab-icon {
    font-size: 18px;
  }

  /* Content area */
  .tab-content {
    background: white;
    padding: 20px;
    border-radius: 12px;
    max-width: 700px;
    margin: 0 auto;
    box-shadow: 0 2px 6px rgba(0,0,0,0.06);
    min-height: 220px;
  }

  /* Google style ad preview with reduced spacing */
  .google-preview {
      opacity: 1;
      transition: opacity 0.5s ease-in-out;
      position: relative;
      display: flex;
      flex-direction: column;
      gap: 6px; /* reduced gap */
  }
  .google-preview.fade-out {
      opacity: 0;
  }
  .sponsored {
      color: #5f6368;
      font-size: 12px;
      margin-bottom: 4px; /* reduced */
      font-weight: 600;
      letter-spacing: 0.05em;
      text-transform: uppercase;
  }
  .headline-wrapper {
      display: flex;
      align-items: center;
      gap: 8px; /* reduced */
      margin-bottom: 4px; /* reduced */
  }
  .icon {
      width: 28px;
      height: 28px;
      padding: 4px;
      background-color: #e8f0fe;
      border-radius: 50%;
      color: #1a73e8;
      flex-shrink: 0;
  }
  .headline-content p:first-child {
      font-weight: bold;
      color: #202124;
      margin: 0;
  }
  .headline-content p:last-child {
      font-size: 14px;
      color: #1a0dab;
      margin: 0;
  }
  .title {
      font-weight: bold;
      color: #1a0dab;
      font-size: 16px;
      margin: 6px 0 2px;
  }
  .description {
      font-size: 14px;
      color: #4d5156;
      line-height: 1.4;
      margin-bottom: 4px;
  }
  /* Smaller CTA Button */
  .cta-button {
    align-self: flex-start;
    padding: 4px 10px;
    background-color: #1a73e8;
    color: white;
    font-weight: 600;
    border-radius: 4px;
    text-decoration: none;
    font-size: 12px;
    transition: background-color 0.3s ease;
    cursor: pointer;
    user-select: none;
    border: none;
    margin-top: 0;
  }
  .cta-button:hover {
    background-color: #155ab6;
  }
  /* Prev/Next buttons */
  button {
      padding: 6px 12px;
      margin: 8px 4px 0 4px;
      border-radius: 5px;
      border: none;
      background-color: #007bff;
      color: #fff;
      cursor: pointer;
      font-size: 14px;
      user-select: none;
  }
  button:hover {
      background-color: #0056b3;
  }

  /* Competition Level table styling */
  table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
  }
  table th, table td {
    border: 1px solid #ddd;
    padding: 8px;
    text-align: left;
  }
  table th {
    background-color: #007bff;
    color: white;
  }
  table tr:nth-child(even) {
    background-color: #f9f9f9;
  }

  /* Target Audience Recommendations two-column layout */
  .target-audience-container {
    display: flex;
    gap: 40px;
    justify-content: center;
    max-width: 700px;
    margin: 0 auto;
    font-size: 14px;
    color: #333;
  }

  .audience-section {
    flex: 1;
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    min-width: 280px;
  }

  .audience-section h3 {
    margin-top: 0;
    margin-bottom: 12px;
    color: #007bff;
    font-weight: 700;
    font-size: 18px;
    border-bottom: 2px solid #007bff;
    padding-bottom: 6px;
  }

  .audience-section ul {
    list-style-type: disc;
    padding-left: 18px;
    margin: 0 0 15px 0;
  }

  .audience-section li {
    margin-bottom: 6px;
    line-height: 1.4;
  }

  .audience-label {
    font-weight: 600;
    margin-top: 12px;
    margin-bottom: 6px;
  }
</style>

<div class="main-wrapper">
  <!-- Sidebar -->
<div class="sidebar">
  <nav>
    <ul class="sidebar-menu">
      <li><a href="dashboard.php" class="sidebar-link"><span class="icon">🏠</span> Dashboard</a></li>
      <li><a href="create_campaign.php" class="sidebar-link active"><span class="icon">📈</span> Create Campaign</a></li>
      <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
      <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
    </ul>
  </nav>
</div>

<style>
.sidebar {
    width: 260px;
    background-color: #1e1e2f;
    padding-top: 40px;
    padding-bottom: 40px;
    color: #ddd;
    box-shadow: 2px 0 12px rgba(0,0,0,0.2);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    user-select: none;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.sidebar-menu {
    list-style: none;
    padding: 0;
    margin: 0;
    width: 100%;
}

.sidebar-menu li {
    margin: 12px 0;
}

.sidebar-link {
    display: flex;
    align-items: center;
    text-decoration: none;
    color: #bbb;
    font-size: 18px;
    padding: 12px 24px;
    border-radius: 8px;
    transition: background-color 0.3s ease, color 0.3s ease;
}

.sidebar-link .icon {
    margin-right: 14px;
    font-size: 22px;
    line-height: 1;
}

.sidebar-link:hover {
    background: #3a3f55;
    color: #fff;
    box-shadow: 0 4px 12px rgba(58, 63, 85, 0.6);
}

.sidebar-link.active {
    background: #4f63d3;
    color: #fff;
    box-shadow: 0 4px 20px rgba(79, 99, 211, 0.7);
    font-weight: 600;
}

.sidebar-link.active .icon {
    color: #fff;
}
</style>



  <div class="main-content">
      <div class="button-group" style="display: flex; gap: 10px; justify-content: flex-end;">
    <button type="submit" class="btn-primary">Next</button>
    <button type="button" class="btn-secondary" onclick="location.href='step1_submit_details.php'">Previous</button>
</div>

    <h1>Step 2: Our AI Tool Analyzes &amp; Suggests</h1>
    

    <!-- Notification bulb -->
    <div id="notificationBulb" class="notification">🔔 Preview of your ads as they would appear on Google.</div>

    <div class="tabs" id="tabs">
      <div class="tab" data-tab="keywords"><span class="tab-icon">🔑</span>Keywords</div>
      <div class="tab" data-tab="targetAudience"><span class="tab-icon">🎯</span>Target Audience Recommendations</div>
      <div class="tab" data-tab="competition"><span class="tab-icon">⚔️</span>Competition Level</div>
      <div class="tab active" data-tab="adPreview"><span class="tab-icon">📝</span>Ad Preview</div>
      <div class="tab" data-tab="budget"><span class="tab-icon">💡</span>Budget Recommendation</div>
    </div>

    <div class="tab-content" id="tab-content-area">

      <!-- Keywords content -->
      <div id="keywords-content" style="display:none;">
        <p>Here are your suggested keywords based on your product.</p>
        <ul>
          <li>Social Media Marketing</li>
          <li>SEO Growth</li>
          <li>Online Traffic</li>
          <li>Content Optimization</li>
        </ul>
      </div>

      <!-- Target Audience Recommendations -->
      <div id="targetAudience-content" style="display:none;">
        <div class="target-audience-container">
          <div class="audience-section" id="primaryAudience">
            <h3>Primary Audience</h3>
            <div><span class="audience-label">Demographics:</span> Coffee enthusiasts aged 25-45, both genders</div>

            <div class="audience-label">Interests:</div>
            <ul>
              <li>Coffee</li>
              <li>Gourmet Food</li>
              <li>Home Brewing</li>
            </ul>

            <div class="audience-label">Behaviors:</div>
            <ul>
              <li>Online Shoppers</li>
              <li>Subscription Service Users</li>
              <li>Foodies</li>
            </ul>

            <div><span class="audience-label">Age Range:</span> 25-45</div>
            <div><span class="audience-label">Income:</span> Middle to high income</div>
            <div><span class="audience-label">Location:</span> Urban areas in the USA and UK</div>
          </div>

          <div class="audience-section" id="secondaryAudience">
            <h3>Secondary Audience</h3>
            <div><span class="audience-label">Demographics:</span> Coffee enthusiasts aged 25-45, both genders</div>

            <div class="audience-label">Interests:</div>
            <ul>
              <li>Coffee</li>
              <li>Gourmet Food</li>
              <li>Home Brewing</li>
            </ul>

            <div class="audience-label">Behaviors:</div>
            <ul>
              <li>Online Shoppers</li>
              <li>Subscription Service Users</li>
              <li>Foodies</li>
            </ul>

            <div><span class="audience-label">Age Range:</span> 25-45</div>
            <div><span class="audience-label">Income:</span> Middle to high income</div>
            <div><span class="audience-label">Location:</span> Urban areas in the USA and UK</div>
          </div>
        </div>
      </div>

      <!-- Competition Level Table -->
      <div id="competition-content" style="display:none;">
        <table>
          <thead>
            <tr>
              <th>Keyword</th>
              <th>CPC</th>
              <th>CTR</th>
              <th>Competitive Level</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>Social Media Marketing</td>
              <td>$1.20</td>
              <td>4.5%</td>
              <td>High</td>
            </tr>
            <tr>
              <td>SEO Growth</td>
              <td>$0.90</td>
              <td>3.8%</td>
              <td>Medium</td>
            </tr>
            <tr>
              <td>Online Traffic</td>
              <td>$0.75</td>
              <td>4.1%</td>
              <td>Low</td>
            </tr>
            <tr>
              <td>Content Optimization</td>
              <td>$1.00</td>
              <td>3.6%</td>
              <td>Medium</td>
            </tr>
          </tbody>
        </table>
      </div>

      <!-- Ad Preview content -->
      <div id="adPreview-content" style="display:block;">
        <div id="adPreviewCarousel" class="google-preview"></div>
        <div style="text-align:center; margin-top: 12px;">
          <button id="prevAdBtn">Prev</button>
          <button id="nextAdBtn">Next</button>
        </div>
      </div>


      <!-- Budget Recommendation -->
      <div id="budget-content" style="display:none; color:#555;">
        <p>Recommended budget range for your campaign:</p>
        <ul>
          <li>Low Budget: $100 - $500</li>
          <li>Medium Budget: $500 - $2,000</li>
          <li>High Budget: $2,000+</li>
        </ul>
      </div>

    </div>
  </div>
</div>

<script>
  const notificationMessages = {
    keywords: "🔔 Keywords to help you grow your campaign.",
    targetAudience: "🔔 Recommended target audiences for better reach.",
    competition: "🔔 Keyword competition data including CPC & CTR.",
    adPreview: "🔔 Preview of your ads as they would appear on Google.",
    budget: "🔔 Suggested budget ranges to maximize your ad performance."
  };

  const tabs = document.querySelectorAll('.tab');
  const notificationBulb = document.getElementById('notificationBulb');

  // Default notification text for Ad Preview tab on page load
  notificationBulb.textContent = notificationMessages['adPreview'];

  tabs.forEach(tab => {
    tab.addEventListener('click', () => {
      tabs.forEach(t => t.classList.remove('active'));
      tab.classList.add('active');

      const tabName = tab.getAttribute('data-tab');
      notificationBulb.textContent = notificationMessages[tabName] || "";

      // Hide all tab content
      ['keywords', 'targetAudience', 'competition', 'adPreview', 'budget'].forEach(id => {
        document.getElementById(id + '-content').style.display = 'none';
      });

      // Show active tab content
      document.getElementById(tabName + '-content').style.display = 'block';
    });
  });

  // Ads data for Ad Preview tab
  const ads = [
    {
      brand: "Example Brand",
      url: "https://example.com",
      title: "Organic Growth Strategies – Secure & Private Payments",
      description: "Browse hundreds of gigs for social growth, traffic & SEO in one place – One dashboard for Instagram, Facebook, TikTok, YouTube & more growth",
      cta: {text: "Learn More", url: "https://example.com"}
    },
    {
      brand: "Traffic Mionz",
      url: "https://dropsell.info",
      title: "Drive Real Traffic to Your Website",
      description: "Get quality traffic for your site from top-tier networks. Trusted by 10,000+ marketers.",
      cta: {text: "Shop Now", url: "https://dropsell.info"}
    },
    {
      brand: "FastAds",
      url: "https://fastads.example",
      title: "Boost Your Ads Performance Now",
      description: "Cutting-edge tools to improve your campaigns & maximize ROI. Easy to use & trusted by pros.",
      cta: {text: "Get Started", url: "https://fastads.example"}
    }
  ];

  let currentIndex = 0;
  const adContainer = document.getElementById("adPreviewCarousel");

  function renderAd(index) {
    const ad = ads[index];
    adContainer.classList.add("fade-out");
    setTimeout(() => {
      adContainer.innerHTML = `
        <p class="sponsored">Sponsored</p>
        <div class="headline-wrapper">
          <svg xmlns="http://www.w3.org/2000/svg" class="icon" viewBox="0 0 24 24" fill="currentColor">
            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10
              10-4.48 10-10S17.52 2 12 2zm-1
              17.93c-3.95-.49-7-3.85-7-7.93
              0-.62.08-1.21.21-1.79L9 15v1c0
              1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55
              0 1-.45 1-1V7h2c1.1 0 2-.9
              2-2v-.41c2.93 1.19 5 4.06 5
              7.41 0 2.08-.8 3.97-2.1 5.39z"/>
          </svg>
          <div class="headline-content">
            <p>${ad.brand}</p>
            <p>${ad.url}</p>
          </div>
        </div>
        <p class="title">${ad.title}</p>
        <p class="description">${ad.description}</p>
        <a href="${ad.cta.url}" target="_blank" class="cta-button">${ad.cta.text}</a>
      `;
      adContainer.classList.remove("fade-out");
    }, 300);
  }

  renderAd(currentIndex);

  document.getElementById("prevAdBtn").addEventListener("click", () => {
    currentIndex = (currentIndex - 1 + ads.length) % ads.length;
    renderAd(currentIndex);
  });

  document.getElementById("nextAdBtn").addEventListener("click", () => {
    currentIndex = (currentIndex + 1) % ads.length;
    renderAd(currentIndex);
  });
</script>

<?php include 'templates/footer.php'; ?>
