<html>
<head>
    <title>My Campaigns</title>
</head>
<body>
   
    
    <style>
/* CSS for the updated notification layout and colors */
#notification-alert {
    position: fixed;
    bottom: 20px;
    left: 20px;
    background-color: #800080;
    color: #fff;
    padding: 15px 25px;
    border-radius: 50px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
    font-size: 14px;
    font-family: Arial, sans-serif;
    z-index: 1000;
    opacity: 0;
    transition: opacity 0.5s ease;
    display: flex;
    align-items: center;
    width: fit-content;
    max-width: 250px;
    gap: 15px;
}

.animated-icon {
    font-size: 1.2rem;
    background-color: #fff;
    color: #800080;
    border-radius: 50%;
    width: 2rem;
    height: 2rem;
    display: flex;
    justify-content: center;
    align-items: center;
    animation: bounce 1s cubic-bezier(0.68, -0.55, 0.27, 1.55) infinite;
}

.message-area {
    display: flex;
    flex-direction: column;
    line-height: 1.4;
}

.main-message {
    margin: 0;
    padding: 0;
    font-weight: bold;
}

.timing-text {
    font-style: italic;
    font-size: 12px;
    color: #ccc;
    margin-top: 5px;
}

/* --- New CSS for the animated rocket emoji --- */
.rocket-emoji {
    display: inline-block; /* Essential for animation */
    animation: fly-rocket 2s ease-in-out infinite;
    transform: translateX(0); /* Ensure initial state */
}

@keyframes fly-rocket {
    0% { transform: translateX(0) translateY(0); }
    25% { transform: translateX(5px) translateY(-2px); }
    50% { transform: translateX(0) translateY(0); }
    75% { transform: translateX(-5px) translateY(2px); }
    100% { transform: translateX(0) translateY(0); }
}
/* --- End of new CSS --- */

@keyframes bounce {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}

#notification-alert[style*="display: flex"] {
    animation: fadeInOut 5s ease-in-out forwards;
}

@keyframes fadeInOut {
    0% { opacity: 0; transform: translateY(20px); }
    10% { opacity: 1; transform: translateY(0); }
    90% { opacity: 1; transform: translateY(0); }
    100% { opacity: 0; transform: translateY(20px); }
}
</style>

   <div id="notification-alert" style="display:none;">
    <span class="animated-icon">📢</span>
    <div class="message-area">
        <p class="main-message"></p>
        <span class="timing-text"></span>
    </div>
</div>

<script>
     const notificationContainer = document.getElementById('notification-alert');
    let notificationsData = [];
    let currentNotificationIndex = 0;
    
    function updateNotificationDisplay() {
        if (notificationsData.length === 0) {
            notificationContainer.style.display = 'none';
            return;
        }

        const data = notificationsData[currentNotificationIndex];
        
        const countryText = data.country ? `from ${data.country}` : '';
        // --- Added a span with class 'rocket-emoji' around the rocket ---
        const mainMessage = `${data.firstname} ${countryText} purchased ${data.package_name} <span class="rocket-emoji">🚀</span>`;
        
        let timingMessage;
        if (data.minutes_ago < 60) {
            timingMessage = `${data.minutes_ago} minutes ago!`;
        } else if (data.hours_ago < 24) {
            timingMessage = `${data.hours_ago} hours ago!`;
        } else {
            timingMessage = `${data.days_ago} days ago!`;
        }

        notificationContainer.querySelector('.main-message').innerHTML = mainMessage;
        notificationContainer.querySelector('.timing-text').innerHTML = timingMessage;

        notificationContainer.style.display = 'flex';

        currentNotificationIndex = (currentNotificationIndex + 1) % notificationsData.length;
    }

    function fetchNotifications() {
        fetch('get_notifications.php')
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (data.length > 0) {
                    notificationsData = data;
                }
            })
            .catch(error => console.error('Error fetching notification:', error));
    }

    fetchNotifications();
    updateNotificationDisplay();

    setInterval(() => {
        if (currentNotificationIndex === 0 && notificationsData.length > 0) {
            fetchNotifications();
        }
        updateNotificationDisplay();
    }, 5000);

    setInterval(() => {
        notificationContainer.style.display = 'none';
    }, 4500); 
</script>
</body>
</html>