<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'templates/header.php';

$isReturning = isset($_GET['return']) && $_GET['return'] == '1';

$website = 'https://dropsell.info';
$campaignName = 'Test Campaign';
$product = 'Test Product';
$selectedLanguage = 'English';
$selectedPlatform = 'Google Search';
$platformLinks = '';
$uniqueVisitors = '';
$bounceRate = 50;
$device = 'desktop';
$geoTargeting = [];
$campaignStatus = 'Run Campaign';
$currentPackage = 'Free Plan';

$conn = new mysqli("localhost", "dropjwxg_ad_generator", "ad_generator", "dropjwxg_ad_generator");

// Check for database connection error
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch packages from the database
$packages = [];
$sql = "SELECT id, Name, Description, price FROM Package ORDER BY price ASC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $packages[] = $row;
    }
}

// Fetch last campaign data for returning users
if ($isReturning) {
    $userid = $_SESSION['user_id'];
    
    $sql = "SELECT 
                c.Name AS campaign_name,
                a.website,
                a.Productname,
                a.language,
                a.platform,
                a.platlinks,
                a.UniqueVisitors,
                a.BounceRate,
                a.device,
                a.geo,
                c.status AS campaign_status,
                c.current_package
            FROM actions a
            JOIN campaign c ON a.campid = c.campid
            WHERE a.userid = $userid
            ORDER BY a.id DESC LIMIT 1";

    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();

        $campaignName = $row['campaign_name'] ?? $campaignName;
        $website = $row['website'] ?? $website;
        $product = $row['Productname'] ?? $product;
        $selectedLanguage = $row['language'] ?? $selectedLanguage;
        $selectedPlatform = $row['platform'] ?? $selectedPlatform;
        $platformLinks = $row['platlinks'] ?? $platformLinks;
        $uniqueVisitors = $row['UniqueVisitors'] ?? $uniqueVisitors;
        $bounceRate = $row['BounceRate'] ?? $bounceRate;
        $device = $row['device'] ?? $device;
        $geoTargeting = !empty($row['geo']) ? explode(',', $row['geo']) : $geoTargeting;
        $campaignStatus = $row['campaign_status'] ?? $campaignStatus;
        $currentPackage = $row['current_package'] ?? $currentPackage;
    }
}

// Function to fetch reviews from the database
function getReviews($conn) {
    $reviews = [];
    $sql = "SELECT 
                r.comment,
                r.created_at,
                u.firstname,
                u.country
            FROM reviews r
            JOIN users u ON r.userid = u.id
            WHERE r.status = 1
            ORDER BY r.id DESC 
            LIMIT 10";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $reviews[] = $row;
        }
    }
    return $reviews;
}

$reviews = getReviews($conn);

// Function to format "time ago"
function timeAgo($datetime) {
    $timeAgo = time() - strtotime($datetime);
    if ($timeAgo < 60) {
        return $timeAgo . " seconds ago";
    } elseif ($timeAgo < 3600) {
        return floor($timeAgo / 60) . " minutes ago";
    } elseif ($timeAgo < 86400) {
        return floor($timeAgo / 3600) . " hours ago";
    } else {
        return floor($timeAgo / 86400) . " days ago";
    }
}

// PHP logic for coupon validation goes here
if (isset($_POST['validate_coupon'])) {
    header('Content-Type: application/json');

    $couponCode = $_POST['validate_coupon'];
    $isValid = false;

    if ($couponCode) {
        // Use a prepared statement to prevent SQL injection
        $stmt = $conn->prepare("SELECT COUNT(*) FROM coupen WHERE Name = ?");
        $stmt->bind_param("s", $couponCode);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();
        
        if ($count > 0) {
            $isValid = true;
        }
    }
    
    echo json_encode(['isValid' => $isValid]);
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Campaign - Ad Generator</title>
    <style>
        /* General Layout */
        .main-wrapper {
            display: flex;
            min-height: 100vh;
        }
        .sidebar {
            width: 260px;
            background-color: #1e1e2f;
            padding-top: 40px;
            padding-bottom: 40px;
            color: #ddd;
            box-shadow: 2px 0 12px rgba(0,0,0,0.2);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            user-select: none;
            display: flex;
            flex-direction: column;
            flex-shrink: 0;
        }
        .sidebar-menu {
            list-style: none;
            padding: 0;
            margin: 0;
            width: 100%;
        }
        .sidebar-menu li {
            margin: 12px 0;
        }
        .sidebar-link {
            display: flex;
            align-items: center;
            text-decoration: none;
            color: #bbb;
            font-size: 18px;
            padding: 12px 24px;
            border-radius: 8px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }
        .sidebar-link .icon {
            margin-right: 14px;
            font-size: 20px;
            width: 32px;
            height: 32px;
            background: #fff;
            color: #4f63d3;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }
        .sidebar-link:hover {
            background: #3a3f55;
            color: #fff;
            box-shadow: 0 4px 12px rgba(58, 63, 85, 0.6);
        }
        .sidebar-link.active {
            background: #4f63d3;
            color: #fff;
            box-shadow: 0 4px 20px rgba(79, 99, 211, 0.7);
            font-weight: 600;
        }
        .main-content {
            flex-grow: 1;
            padding: 40px 30px;
            background-color: #e8f0fe;
        }
        h1 {
            font-weight: 700;
            color: #1a237e;
            margin-bottom: 30px;
            font-size: 28px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        form {
            background-color: #ffffff;
            border-radius: 16px;
            padding: 40px 50px;
            box-shadow: 0 8px 30px rgba(26, 35, 126, 0.12);
            display: grid;
            grid-template-columns: 1fr;
            gap: 28px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .form-group {
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .form-group label {
            font-weight: 600;
            margin-bottom: 8px;
            color: #3949ab;
        }
        .form-group input,
        .form-group select,
        .form-group textarea {
            padding: 12px 15px;
            font-size: 16px;
            border: 1.8px solid #c5cae9;
            border-radius: 10px;
            background-color: #f5f7ff;
            color: #1a237e;
            box-shadow: inset 0 2px 5px rgba(60, 66, 201, 0.05);
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
            width: 100%;
            max-width: 600px;
        }
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            border-color: #3949ab;
            box-shadow: 0 0 8px rgba(57, 73, 171, 0.4);
            outline: none;
            background-color: #e8ecff;
        }
        .form-group input.error,
        .form-group textarea.error {
            border-color: #e53935;
            background-color: #ffebee;
            box-shadow: 0 0 6px 2px rgba(229, 57, 53, 0.6);
            color: #b71c1c;
        }
        .error-msg {
            color: #e53935;
            font-size: 14px;
            margin-top: 5px;
            display: none;
            font-weight: 600;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .button-group {
            display: flex;
            justify-content: center;
            gap: 14px;
            margin-top: 28px;
        }
        .btn-primary {
            background: linear-gradient(135deg, #3949ab, #1a237e);
            color: white;
            padding: 12px 28px;
            border: none;
            border-radius: 10px;
            font-weight: 700;
            font-size: 16px;
            cursor: pointer;
            box-shadow: 0 6px 20px rgba(26, 35, 126, 0.5);
            transition: background 0.3s ease;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #1a237e, #121858);
            box-shadow: 0 8px 25px rgba(18, 24, 88, 0.7);
        }
        .btn-secondary {
            background-color: #c5cae9;
            color: #3949ab;
            padding: 12px 28px;
            border: none;
            border-radius: 10px;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            box-shadow: none;
            transition: background-color 0.3s ease;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .btn-secondary:hover {
            background-color: #9fa8da;
            color: #1a237e;
        }
        .info-icon {
            font-style: normal;
            font-size: 16px;
            color: #e53935;
            cursor: pointer;
            position: relative;
            user-select: none;
            outline: none;
        }
        .info-icon .tooltip {
            visibility: hidden;
            width: max-content;
            max-width: 180px;
            background-color: #e53935;
            color: #fff;
            text-align: center;
            border-radius: 8px;
            padding: 8px 12px;
            position: absolute;
            z-index: 10;
            bottom: 125%;
            left: 50%;
            transform: translateX(-50%);
            opacity: 0;
            transition: opacity 0.3s ease;
            font-size: 14px;
            pointer-events: none;
        }
        .info-icon .tooltip::after {
            content: "";
            position: absolute;
            top: 100%;
            left: 50%;
            transform: translateX(-50%);
            border-width: 6px;
            border-style: solid;
            border-color: #3949ab transparent transparent transparent;
        }
        .info-icon:hover .tooltip,
        .info-icon:focus .tooltip {
            visibility: visible;
            opacity: 1;
            pointer-events: auto;
        }
        #loading-overlay {
            display: none;
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(26, 35, 126, 0.6);
            z-index: 2000;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            color: white;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 22px;
            font-weight: 700;
            text-align: center;
        }
        .loader {
            border: 8px solid #f3f3f3;
            border-top: 8px solid #3949ab;
            border-radius: 50%;
            width: 70px;
            height: 70px;
            animation: spin 1.3s linear infinite;
            margin-bottom: 15px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .progress-container {
            width: 80%;
            max-width: 400px;
            background-color: #f0f0f0;
            border-radius: 20px;
            height: 20px;
            margin: 20px 0;
            overflow: hidden;
        }
        #progress-bar {
            height: 100%;
            width: 0;
            background-color: #4CAF50;
            border-radius: 20px;
            transition: width 0.5s ease-in-out;
        }

        /* SEO Report Styles */
        .data-cards-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-top: 40px;
            justify-content: center;
        }
        .data-card {
            background-color: #fff;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
        }
        .progress-circle-container {
            position: relative;
            width: 120px;
            height: 120px;
            margin-bottom: 20px;
        }
        .progress-circle {
            position: relative;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background: conic-gradient(#eee 0%, #eee 100%);
        }
        .progress-circle::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 90%;
            height: 90%;
            background: #fff;
            border-radius: 50%;
            z-index: 1;
        }
        .progress-value {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 2;
            font-size: 2rem;
            font-weight: 700;
            color: #1a237e;
        }
        .data-card-title {
            font-size: 1.1rem;
            color: #6a6a6a;
            margin-top: 5px;
            font-weight: 600;
        }
        .data-card-value {
            font-size: 2rem;
            font-weight: 700;
            color: #1a237e;
            margin-bottom: 10px;
        }
        .low-rating {
            background: conic-gradient(#ff0000 var(--progress), #eee var(--progress));
        }
        .medium-rating {
            background: conic-gradient(#ffc107 var(--progress), #eee var(--progress));
        }
        .high-rating {
            background: conic-gradient(#4caf50 var(--progress), #eee var(--progress));
        }
        .indicator {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            position: absolute;
            top: 10px;
            right: 10px;
            border: 2px solid white;
        }
        .indicator.red { background-color: #f44336; }
        .indicator.orange { background-color: #ff9800; }
        .indicator.green { background-color: #4caf50; }
        .blinking-light {
            animation: blink 1.5s infinite;
        }
        @keyframes blink {
            0% { opacity: 1; }
            50% { opacity: 0.3; }
            100% { opacity: 1; }
        }
        .blinking-text {
            animation: blink 1.5s infinite;
            font-weight: bold;
            font-size: 0.9em;
            margin-top: 8px;
            text-transform: uppercase;
        }
        .blinking-text.red { color: #f44336; }
        .blinking-text.orange { color: #ff9800; }
        .blinking-text.green { color: #4caf50; }
        .data-card {
            animation: fadeIn 1s ease-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Package Selection Styles */
        .budget-container {
            background-color: #fff;
            border-radius: 16px;
            padding: 40px 50px;
            box-shadow: 0 8px 30px rgba(26, 35, 126, 0.12);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin-top: 40px;
        }
        .budget-container h2 {
            font-weight: 600;
            color: #3949ab;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .price-display {
            font-size: 2.5rem;
            font-weight: 700;
            color: #1a237e;
            text-align: center;
            margin-bottom: 30px;
            transition: color 0.3s ease;
        }
        .blinking-suggestion-text {
            text-align: center;
            font-weight: bold;
            font-size: 1em;
            color: #4CAF50;
            animation: blink 1.5s infinite;
        }
        .budget-slider {
            width: 100%;
            max-width: 600px;
            height: 10px;
            background: #c5cae9;
            border-radius: 5px;
            outline: none;
            -webkit-appearance: none;
            appearance: none;
            cursor: grab;
        }
        .budget-slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 25px;
            height: 25px;
            background: #3949ab;
            cursor: grab;
            border-radius: 50%;
            border: 3px solid #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
            transition: background 0.3s ease;
        }
        .budget-slider::-webkit-slider-thumb:active {
            cursor: grabbing;
        }
        .budget-slider::-webkit-slider-thumb:hover {
            background: #1a237e;
        }
        .campaign-details {
            background-color: #f5f7ff;
            border-radius: 12px;
            padding: 30px;
            margin-top: 30px;
            border: 1px dashed #c5cae9;
        }
        .campaign-details h3 {
            font-weight: 600;
            color: #1a237e;
            margin-bottom: 15px;
            font-size: 20px;
            text-align: center;
        }
        .campaign-details h4 {
            font-weight: 600;
            color: #3949ab;
            margin-bottom: 15px;
            font-size: 18px;
            text-align: center;
        }
        .campaign-details ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .campaign-details li {
            font-size: 16px;
            color: #3949ab;
            margin-bottom: 10px;
            padding-left: 20px;
            position: relative;
        }
        .campaign-details li::before {
            content: '↳';
            position: absolute;
            left: 0;
            color: #3949ab;
            font-weight: bold;
        }
        .campaign-details li.nested-item::before {
            color: #9fa8da;
        }
        .box-container {
            display: inline-flex;
            gap: 5px;
            margin-left: 5px;
        }
        .box-red {
            background-color: #e53935;
            color: white;
            padding: 2px 6px;
            border-radius: 4px;
            font-weight: bold;
        }
        .box-black {
            background-color: #000;
            color: white;
            padding: 2px 6px;
            border-radius: 4px;
            font-weight: bold;
        }
        .slider-wrapper {
            position: relative;
            max-width: 600px;
            margin: 0 auto;
        }
        .animated-hand-text-container {
            text-align: center;
            height: 25px;
            margin-bottom: 15px;
            font-weight: bold;
            color: #3949ab;
            position: relative;
            overflow: hidden;
            white-space: nowrap;
        }
        .animated-text {
            display: inline-block;
            animation: slide-text-animation 5s infinite ease-in-out;
            position: relative;
        }
        .hand-icon {
            display: inline-block;
            font-size: 1.5rem;
            position: absolute;
            top: -5px;
        }
        .hand-left {
            left: -30px;
            animation: move-left-hand 5s infinite ease-in-out;
        }
        .hand-right {
            right: -30px;
            animation: move-right-hand 5s infinite ease-in-out;
        }
        @keyframes move-left-hand {
            0%, 100% { transform: translateX(0); }
            50% { transform: translateX(450px); }
        }
        @keyframes move-right-hand {
            0%, 100% { transform: translateX(0); }
            50% { transform: translateX(-450px); }
        }

        /* Customer Reviews Styles */
        .reviews-container {
            position: relative;
            width: 100%;
            max-width: 850px;
            margin: 40px auto;
            overflow: hidden;
        }
        .review-carousel {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }
        .review-carousel::-webkit-scrollbar {
            display: none;
        }
        .review-card {
            flex: 0 0 auto;
            width: 250px;
            margin: 10px;
            padding: 20px;
            border-radius: 10px;
            background: #fff;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s;
        }
        .review-card:hover {
            transform: scale(1.05);
        }
        .profile-img {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            margin-bottom: 10px;
        }
        .username {
            font-weight: bold;
            font-size: 16px;
        }
        .country {
            font-size: 14px;
            color: #555;
        }
        .review-text {
            font-size: 14px;
            margin: 10px 0;
        }
        .star-rating {
            color: #FFD700;
            margin: 5px 0;
        }
        .carousel-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background-color: rgba(79, 99, 211, 0.7);
            color: white;
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            font-size: 20px;
            cursor: pointer;
            z-index: 10;
        }
        .carousel-btn.left {
            left: 10px;
        }
        .carousel-btn.right {
            right: 10px;
        }
        .carousel-btn:hover {
            background-color: rgba(79, 99, 211, 1);
        }
        @keyframes blink {
            50% { opacity: 0; }
        }
        /* New Styles for Step 4 */
        .tab-container {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        .tab-button {
            background-color: #f0f0f0;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 10px 20px;
            margin: 0 5px;
            cursor: pointer;
            transition: background-color 0.3s, color 0.3s;
        }
        .tab-button.active {
            background-color: #3949ab;
            color: white;
            border-color: #3949ab;
        }
        .coupon-box {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            max-width: 600px;
            margin: 10px auto;
        }
        .coupon-box input {
            flex-grow: 1;
        }
        .validation-icon {
            font-size: 1.5em;
            vertical-align: middle;
            display: none;
        }
        .validation-msg {
            font-size: 0.9em;
            font-weight: bold;
            display: none;
        }

    </style>
</head>
<body>

<div class="main-wrapper">
    <div class="sidebar">
        <nav>
            <ul class="sidebar-menu">
                <li><a href="dashboard.php" class="sidebar-link"><span class="icon">🏠</span> Dashboard</a></li>
                <li><a href="create_campaign.php" class="sidebar-link active"><span class="icon">📈</span> Create Campaign</a></li>
                <li><a href="profile.php" class="sidebar-link"><span class="icon">👤</span> Profile</a></li>
                <li><a href="logout.php" class="sidebar-link"><span class="icon">🚪</span> Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="main-content">
        <div id="step1-container">
            <h1 id="form-heading">Step 1: Submit Your Website</h1>
            <form id="campaign-form">
                <div class="form-group">
                    <label for="website">Website URL:<span class="info-icon" tabindex="0">ℹ️<span class="tooltip">Please type your correct URL</span></span></label>
                    <input type="url" id="website" name="website" placeholder="https://example.com" value="<?= htmlspecialchars($website) ?>">
                    <div id="website-error" class="error-msg">Please enter a valid website URL.</div>
                </div>

                <div class="button-group">
                    <button type="button" class="btn-primary" id="next-btn">Next</button>
                </div>
                
                <input type="hidden" id="campid" name="campid" value="">
                <input type="hidden" id="actionid" name="actionid" value="">
            </form>
        </div>

        <div id="loading-overlay">
            <div class="loader"></div>
            <p id="loading-text">Analyzing SEO for your website...</p>
            <div class="progress-container">
                <div id="progress-bar"></div>
            </div>
        </div>

        <div id="step2-container" style="display:none;">
            <h1 id="step2-heading" style="text-align:center;">AI Agent Analyzing Summary for <span id="domain-name"></span></h1>
            <p id="step2-message" style="text-align:center; color:#e53935; font-weight:bold;">Don't worry if you are getting a lower ranking issue. Please proceed to our next step and start your AI SEO Campaign.</p>

            <div class="data-cards-container">
                <div class="data-card">
                    <span id="domain-rating-indicator" class="indicator"></span>
                    <div class="progress-circle-container">
                        <div id="domain-rating-circle" class="progress-circle"></div>
                        <span id="domain-rating-value" class="progress-value">--</span>
                    </div>
                    <h3 class="data-card-title">Domain Rating</h3>
                    <p id="domain-rating-text" class="blinking-text"></p>
                </div>

                <div class="data-card">
                    <span id="url-rating-indicator" class="indicator"></span>
                    <div class="progress-circle-container">
                        <div id="url-rating-circle" class="progress-circle"></div>
                        <span id="url-rating-value" class="progress-value">--</span>
                    </div>
                    <h3 class="data-card-title">URL Rating</h3>
                    <p id="url-rating-text" class="blinking-text"></p>
                </div>

                <div class="data-card">
                    <span id="keywords-indicator" class="indicator"></span>
                    <h3 class="data-card-title">Organic Keywords</h3>
                    <p class="data-card-value" id="keywords-value">--</p>
                    <p id="keywords-text" class="blinking-text"></p>
                </div>
                
                <div class="data-card">
                    <span id="ref-domains-indicator" class="indicator"></span>
                    <h3 class="data-card-title">Referring Domains</h3>
                    <p class="data-card-value" id="ref-domains-value">--</p>
                    <p id="ref-domains-text" class="blinking-text"></p>
                </div>
                
                <div class="data-card">
                    <span id="traffic-indicator" class="indicator"></span>
                    <h3 class="data-card-title">Monthly Traffic</h3>
                    <p class="data-card-value" id="traffic-value">--</p>
                    <p id="traffic-text" class="blinking-text"></p>
                </div>

                <div class="data-card">
                    <span id="words-indicator" class="indicator"></span>
                    <h3 class="data-card-title">Page Words</h3>
                    <p class="data-card-value" id="words-value">--</p>
                    <p id="words-text" class="blinking-text"></p>
                </div>
            </div>

            <div class="reviews-container">
                <h2 style="text-align:center; font-weight:700; color:purple; font-size:28px; margin-bottom:20px; text-transform:uppercase; letter-spacing:1px;">
                    Our Customer Reviews
                </h2>
                
                <button class="carousel-btn left" onclick="moveSlide(-1)">&#10094;</button>
                <button class="carousel-btn right" onclick="moveSlide(1)">&#10095;</button>
                
                <div class="review-carousel" id="reviewCarouselStep2">
                    <?php if (!empty($reviews)): ?>
                        <?php foreach ($reviews as $review): ?>
                            <div class="review-card">
                                <img src="https://i.pravatar.cc/150?u=<?= htmlspecialchars($review['firstname']) ?>" 
                                     class="profile-img" alt="User Profile Image">
                                <div class="username"><?= htmlspecialchars($review['firstname']) ?></div>
                                <div class="country"><?= htmlspecialchars($review['country']) ?></div>
                                <div class="star-rating">⭐⭐⭐⭐⭐</div>
                                <p class="review-text" style="font-style:italic; color:purple;">
                                    “<?= htmlspecialchars($review['comment']) ?>”
                                </p>
                                <small style="display:block; text-align:center; margin-top:10px; color:red; font-weight:bold; animation: blink 1s infinite;">
                                    <?= timeAgo($review['created_at']); ?>
                                </small>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>No reviews available yet.</p>
                    <?php endif; ?>
                </div>
            </div>

            <div style="text-align:center; margin-top: 40px;">
                <button id="step2-prev" class="btn-secondary" type="button">Previous</button>
                <button id="step2-submit" class="btn-primary" type="button">Next: Configure Campaign</button>
            </div>
        </div>

        <div id="step3-container" style="display:none;">
            <h1 style="text-align:center;">Step 3: Selected Package</h1>
            <p style="text-align:center; margin-bottom: 30px; font-size: 1.2rem; font-weight: bold; color: #e53935;">
                Choose your budget, Fill your website details & Submit in one click!
            </p>

            <div class="budget-container">
                <h2>Choose Your Budget</h2>
                <div class="price-display" id="price-display">$25</div>
                <div id="suggestion-text" class="blinking-suggestion-text" style="display:none;"></div>
                <div class="slider-wrapper">
                    <div class="animated-hand-text-container">
                        <div id="animated-text" class="animated-text">
                            <span class="hand-icon hand-left">👈</span> Slide to Change Package <span class="hand-icon hand-right">👉</span>
                        </div>
                    </div>
                    <input type="range" id="budget-slider" class="budget-slider" min="0" max="8" value="0">
                </div>
            </div>

            <div class="campaign-details">
                <h3 id="package-name-heading"></h3>
                <h4>Campaign Details</h4>
                <ul id="campaign-features">
                    </ul>
            </div>
            
            <form id="final-campaign-form" style="margin-top: 30px; padding: 20px; box-shadow: none;">
                <h4 style="text-align: center; color: #1a237e;">Order details</h4>
                <div class="form-group">
                    <label for="campaign-name">Campaign Name:</label>
                    <input type="text" id="campaign-name" name="campaign-name" placeholder="E.g., My first campaign" required>
                </div>
                <div class="form-group">
                    <label for="keywords">Target Keywords (separated by commas):</label>
                    <input type="text" id="keywords" name="keywords" placeholder="E.g., SEO tool, marketing software" required>
                </div>
                <div class="form-group">
                    <label for="website-urls">Website URLs (one per line):</label>
                    <textarea id="website-urls" name="website-urls" rows="5" required
                        placeholder="http://example.com/page-one.html
http://example.com/page-two.html
http://example.com/page-three.html"></textarea>
                </div>
            </form>

            <div style="text-align:center; margin-top: 40px;">
                <button id="step3-prev" class="btn-secondary" type="button">Previous</button>
                <button id="step3-submit" class="btn-primary" type="button">Campaign Scheduling</button>
            </div>
        </div>
        
        <div id="step4-container" style="display:none;">
            <h1 id="step4-heading">Step 4: Campaign Scheduling</h1>
            <div class="campaign-details">
                <h3 id="step4-package-summary-heading"></h3>
                <p><strong>Price:</strong> <span id="step4-package-price"></span></p>
            </div>
            
            <div class="budget-container" style="margin-top: 30px;">
                <h2>Campaign Scheduling Area</h2>
                <p style="text-align: center; font-weight: bold; margin-bottom: 20px;">
                    Please choose your preferred billing option below.
                </p>
                
                <div class="tab-container" id="billing-tabs">
                    <button class="tab-button active" data-period="weekly">Weekly Subscribe</button>
                    <button class="tab-button" data-period="monthly">Monthly Subscribe</button>
                    <button class="tab-button" data-period="six-months">6 Months Subscribe</button>
                </div>

                <div class="form-group">
                    <label for="coupon-code">Coupon Code:</label>
                    <div class="coupon-box">
                        <input type="text" id="coupon-code" name="coupon-code" placeholder="Enter coupon code">
                        <span id="coupon-validation-icon" class="validation-icon"></span>
                        <span id="coupon-validation-msg" class="validation-msg"></span>
                    </div>
                </div>

                <div class="form-group">
                    <label for="payment-gateway">Select Payment Gateway:</label>
                    <select id="payment-gateway" name="payment-gateway">
                        <option value="gateway1">Payment Gateway 1</option>
                        <option value="gateway2">Payment Gateway 2</option>
                        <option value="gateway3">Payment Gateway 3</option>
                    </select>
                </div>
            </div>

            <div style="text-align:center; margin-top: 40px;">
                <button id="step4-prev" class="btn-secondary" type="button">Previous</button>
                <button id="pay-now-btn" class="btn-primary" type="button">Pay Now</button>
            </div>
        </div>
        
    </div>
</div>

<script>
// Main JavaScript to handle step transitions and other logic
document.addEventListener('DOMContentLoaded', function() {
    // Select all step containers
    const stepContainers = document.querySelectorAll('#step1-container, #step2-container, #step3-container, #step4-container');
    const formHeading = document.getElementById('form-heading');

    function showStep(stepId) {
        stepContainers.forEach(container => {
            container.style.display = 'none';
        });
        document.getElementById(stepId).style.display = 'block';

        // Update the main heading based on the step
        switch (stepId) {
            case 'step1-container':
                formHeading.textContent = 'Step 1: Submit Your Website';
                break;
            case 'step2-container':
                formHeading.textContent = 'Step 2: AI Agent Analyzing Summary';
                break;
            case 'step3-container':
                formHeading.textContent = 'Step 3: Selected Package';
                break;
            case 'step4-container':
                formHeading.textContent = 'Step 4: Campaign Scheduling';
                break;
        }
    }

    // Event listeners for navigation buttons
    document.getElementById('next-btn').addEventListener('click', function() {
        showStep('step2-container');
    });

    document.getElementById('step2-prev').addEventListener('click', function() {
        showStep('step1-container');
    });

    document.getElementById('step2-submit').addEventListener('click', function() {
        showStep('step3-container');
    });

    document.getElementById('step3-prev').addEventListener('click', function() {
        showStep('step2-container');
    });
    
    document.getElementById('step3-submit').addEventListener('click', function() {
        // Here you would get the package details from step 3 before moving to step 4
        // Example placeholders
        const selectedPackageName = document.getElementById('package-name-heading').textContent;
        const selectedPackagePrice = document.getElementById('price-display').textContent;
        
        // Pass data to step 4
        document.getElementById('step4-package-summary-heading').textContent = `Package Summary: ${selectedPackageName}`;
        document.getElementById('step4-package-price').textContent = selectedPackagePrice;

        showStep('step4-container');
    });

    document.getElementById('step4-prev').addEventListener('click', function() {
        showStep('step3-container');
    });

    // --- Step 4 Functionality ---
    
    // Tab switching for billing options
    document.querySelectorAll('.tab-button').forEach(button => {
        button.addEventListener('click', function() {
            document.querySelectorAll('.tab-button').forEach(btn => btn.classList.remove('active'));
            this.classList.add('active');
            // Logic to update pricing based on selected plan can go here
        });
    });

    // Coupon code validation
    const couponInput = document.getElementById('coupon-code');
    const couponIcon = document.getElementById('coupon-validation-icon');
    const couponMsg = document.getElementById('coupon-validation-msg');
    
    couponInput.addEventListener('input', function() {
        const code = this.value;
        
        couponIcon.style.display = 'none';
        couponMsg.style.display = 'none';

        if (code.length > 0) {
            // Use FormData for POST requests
            const formData = new FormData();
            formData.append('validate_coupon', code);
            
            fetch('campaign.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                couponIcon.style.display = 'inline-block';
                couponMsg.style.display = 'inline-block';
                
                if (data.isValid) {
                    couponIcon.textContent = '✅';
                    couponMsg.textContent = 'Validated';
                    couponMsg.style.color = 'green';
                } else {
                    couponIcon.textContent = '❌';
                    couponMsg.textContent = 'Not validated';
                    couponMsg.style.color = 'red';
                }
            })
            .catch(error => {
                console.error('Error:', error);
                couponIcon.style.display = 'inline-block';
                couponIcon.textContent = '❌';
                couponMsg.textContent = 'An error occurred';
                couponMsg.style.color = 'red';
            });
        }
    });
});
</script>

</body>
</html>