<?php
session_start();
header('Content-Type: application/json');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection details
$servername = "localhost";
$username = "dropjwxg_ad_generator";
$password = "ad_generator";
$dbname = "dropjwxg_ad_generator";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed.']);
    exit;
}

// Get the POST data from the request body
$data = json_decode(file_get_contents('php://input'), true);
$couponName = $data['coupon'] ?? '';

// Get the user ID from the session
$userId = (int)($_SESSION['user_id'] ?? 0); // Casts the session value to an integer

if ($userId === null) {
    echo json_encode(['status' => 'error', 'message' => 'User not logged in.']);
    exit;
}

// Prepare the SQL statement to find a coupon that matches both the name AND user ID
$sql = "SELECT Discount, DiscountType, ExpiryDate, UsageLimit, TimesUsed FROM coupen WHERE Name = ? AND userid = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to prepare statement.']);
    exit;
}

// Bind the coupon name (string) and user ID (integer)
$stmt->bind_param("si", $couponName, $userId);
$stmt->execute();

// Bind the results to PHP variables
$stmt->bind_result($discount, $discountType, $expiryDate, $usageLimit, $timesUsed);

// Fetch the result
if ($stmt->fetch()) {
    $currentDate = date('Y-m-d');

    // Check for expiration date
    if ($expiryDate < $currentDate) {
        echo json_encode(['status' => 'error', 'message' => 'Coupon has expired.']);
        exit;
    }

    // Check for usage limit
    if ($usageLimit !== null && $timesUsed >= $usageLimit) {
        echo json_encode(['status' => 'error', 'message' => 'Coupon usage limit reached.']);
        exit;
    }

    // If all checks pass, return a success message
    echo json_encode([
        'status' => 'success',
        'message' => 'Coupon applied successfully!',
        'discount' => $discount,
        'discount_type' => $discountType
    ]);
} else {
    // No matching coupon found for this user
    echo json_encode(['status' => 'error', 'message' => 'Invalid coupon code or not assigned to this user.']);
}

$stmt->close();
$conn->close();

?>